/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.data.provider;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;

public abstract class ComponentL10nProvider
implements DataProvider {
    private final Map<String, Component> data = new TreeMap<String, Component>();
    private final PackOutput output;
    private final String modid;
    private final String locale;

    public ComponentL10nProvider(PackOutput output, String modid, String locale) {
        this.output = output;
        this.modid = modid;
        this.locale = locale;
    }

    protected abstract void addTranslations();

    public CompletableFuture<?> run(CachedOutput cache) {
        this.addTranslations();
        if (!this.data.isEmpty()) {
            return this.save(cache, this.output.getOutputFolder(PackOutput.Target.RESOURCE_PACK).resolve(this.modid).resolve("lang").resolve(this.locale + ".json"));
        }
        return CompletableFuture.allOf(new CompletableFuture[0]);
    }

    public String getName() {
        return "Languages: " + this.locale + " for mod: " + this.modid;
    }

    private CompletableFuture<?> save(CachedOutput cache, Path target) {
        JsonObject json = new JsonObject();
        for (Map.Entry<String, Component> entry : this.data.entrySet()) {
            String key = entry.getKey();
            Component value = entry.getValue();
            String str = value.tryCollapseToString();
            if (str != null) {
                json.addProperty(key, str);
                continue;
            }
            json.add(key, (JsonElement)ComponentSerialization.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)value).map(elem -> (JsonArray)Util.make((Object)new JsonArray(), arr -> arr.add(elem))).getOrThrow());
        }
        return DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)target);
    }

    public void addBlock(Supplier<? extends Block> key, String name) {
        this.add(key.get(), name);
    }

    public void add(Block key, String name) {
        this.add(key.getDescriptionId(), name);
    }

    public void addItem(Supplier<? extends Item> key, String name) {
        this.add(key.get(), name);
    }

    public void add(Item key, String name) {
        this.add(key.getDescriptionId(), name);
    }

    public void addItemStack(Supplier<ItemStack> key, String name) {
        this.add(key.get(), name);
    }

    public void add(ItemStack key, String name) {
        this.add(key.getDescriptionId(), name);
    }

    public void addEffect(Supplier<? extends MobEffect> key, String name) {
        this.add(key.get(), name);
    }

    public void add(MobEffect key, String name) {
        this.add(key.getDescriptionId(), name);
    }

    public void addEntityType(Supplier<? extends EntityType<?>> key, String name) {
        this.add(key.get(), name);
    }

    public void add(EntityType<?> key, String name) {
        this.add(key.getDescriptionId(), name);
    }

    public void addTag(Supplier<? extends TagKey<?>> key, String name) {
        this.add(key.get(), name);
    }

    public void add(TagKey<?> tagKey, String name) {
        this.add(Tags.getTagTranslationKey(tagKey), name);
    }

    public void addDimension(ResourceKey<Level> dimension, String value) {
        this.add(dimension.location().toLanguageKey("dimension"), value);
    }

    public void addBlock(Supplier<? extends Block> key, Component name) {
        this.add(key.get(), name);
    }

    public void add(Block key, Component name) {
        this.add(key.getDescriptionId(), name);
    }

    public void addItem(Supplier<? extends Item> key, Component name) {
        this.add(key.get(), name);
    }

    public void add(Item key, Component name) {
        this.add(key.getDescriptionId(), name);
    }

    public void addItemStack(Supplier<ItemStack> key, Component name) {
        this.add(key.get(), name);
    }

    public void add(ItemStack key, Component name) {
        this.add(key.getDescriptionId(), name);
    }

    public void addEffect(Supplier<? extends MobEffect> key, Component name) {
        this.add(key.get(), name);
    }

    public void add(MobEffect key, Component name) {
        this.add(key.getDescriptionId(), name);
    }

    public void addEntityType(Supplier<? extends EntityType<?>> key, Component name) {
        this.add(key.get(), name);
    }

    public void add(EntityType<?> key, Component name) {
        this.add(key.getDescriptionId(), name);
    }

    public void addTag(Supplier<? extends TagKey<?>> key, Component name) {
        this.add(key.get(), name);
    }

    public void add(TagKey<?> tagKey, Component name) {
        this.add(Tags.getTagTranslationKey(tagKey), name);
    }

    public void add(String key, String value) {
        this.add(key, (Component)Component.literal((String)value));
    }

    public void add(String key, Component value) {
        if (this.data.put(key, value) != null) {
            throw new IllegalStateException("Duplicate translation key " + key);
        }
    }

    public void addDimension(ResourceKey<Level> dimension, Component value) {
        this.add(dimension.location().toLanguageKey("dimension"), value);
    }
}

