/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.client.tooltip;

import com.mojang.blaze3d.systems.RenderSystem;
import ky.someone.mods.gag.entity.TimeAcceleratorEntity;
import ky.someone.mods.gag.util.GAGUtil;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.resources.ResourceLocation;

public class TimeArrowClientTooltip
implements ClientTooltipComponent {
    static final ResourceLocation ARROW = GAGUtil.id("textures/gui/time_arrow.png");
    private final TimeAcceleratorEntity accelerator;

    public TimeArrowClientTooltip(TimeAcceleratorEntity accelerator) {
        this.accelerator = accelerator;
    }

    public int getHeight() {
        return 18;
    }

    public int getWidth(Font font) {
        return 24;
    }

    public void renderImage(Font font, int x, int y, GuiGraphics graphics) {
        int time = 3000 / (int)Math.pow(this.accelerator.getTimesAccelerated(), 1.25);
        int entityTicks = this.accelerator.tickCount;
        int width = 24;
        int regionWidth = 24;
        int height = 18;
        int regionHeight = 18;
        int subTime = (int)((float)entityTicks * 50.0f % (float)time);
        RenderSystem.enableBlend();
        graphics.blit(ARROW, x, y, width, height, 0.0f, 18.0f, regionWidth, regionHeight, 24, 36);
        graphics.blit(ARROW, x, y, width * subTime / time, height, 0.0f, 0.0f, regionWidth * subTime / time, regionHeight, 24, 36);
        RenderSystem.disableBlend();
    }
}

