/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.texture.types.random;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.texture.DefaultTextureTypes;
import com.supermartijn642.fusion.api.texture.SpriteCreationContext;
import com.supermartijn642.fusion.api.texture.SpritePreparationContext;
import com.supermartijn642.fusion.api.texture.TextureErrorException;
import com.supermartijn642.fusion.api.texture.TextureType;
import com.supermartijn642.fusion.api.texture.data.BaseTextureData;
import com.supermartijn642.fusion.api.texture.data.RandomTextureData;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.model.MutableQuad;
import com.supermartijn642.fusion.texture.types.random.RandomTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;

public class RandomTextureType
implements TextureType<RandomTextureData> {
    @Override
    public RandomTextureData deserialize(JsonObject json) throws JsonParseException {
        BaseTextureData base = (BaseTextureData)DefaultTextureTypes.BASE.deserialize(json);
        RandomTextureData.Builder builder = RandomTextureData.builder();
        builder.renderType(base.getRenderType());
        builder.emissive(base.isEmissive());
        builder.tinting(base.getTinting());
        int rows = 1;
        if (json.has("rows")) {
            if (!json.get("rows").isJsonPrimitive() || !json.getAsJsonPrimitive("rows").isNumber()) {
                throw new JsonParseException("Property 'rows' must be a number!");
            }
            rows = json.get("rows").getAsInt();
            if (rows < 1 || rows > 10) {
                throw new JsonParseException("Property 'rows' must be a number between 1 and 10!");
            }
            builder.rows(rows);
        }
        int columns = 1;
        if (json.has("columns")) {
            if (!json.get("columns").isJsonPrimitive() || !json.getAsJsonPrimitive("columns").isNumber()) {
                throw new JsonParseException("Property 'columns' must be a number!");
            }
            columns = json.get("columns").getAsInt();
            if (columns < 1 || columns > 10) {
                throw new JsonParseException("Property 'columns' must be a number between 1 and 10!");
            }
            builder.columns(columns);
        }
        if (json.has("count")) {
            if (!json.get("count").isJsonPrimitive() || !json.getAsJsonPrimitive("count").isNumber()) {
                throw new JsonParseException("Property 'count' must be a number!");
            }
            int count = json.get("count").getAsInt();
            if (count < 1 || count > 100) {
                throw new JsonParseException("Property 'count' must be a number between 1 and 100!");
            }
            if (count > rows * columns) {
                throw new IllegalArgumentException("Count cannot be greater than rows * columns!");
            }
            builder.count(count);
        }
        if (json.has("seed")) {
            if (!json.get("seed").isJsonPrimitive() || !json.getAsJsonPrimitive("seed").isNumber()) {
                throw new JsonParseException("Property 'seed' must be a number!");
            }
            builder.seed(json.get("seed").getAsLong());
        }
        return (RandomTextureData)builder.build();
    }

    @Override
    public JsonObject serialize(RandomTextureData data) {
        JsonObject json = DefaultTextureTypes.BASE.serialize(data);
        if (data.getRows() != 1) {
            json.addProperty("rows", (Number)data.getRows());
        }
        if (data.getColumns() != 1) {
            json.addProperty("columns", (Number)data.getColumns());
        }
        if (data.getCount() != data.getRows() * data.getColumns()) {
            json.addProperty("count", (Number)data.getCount());
        }
        if (data.getSeed() != null) {
            json.addProperty("seed", (Number)data.getSeed());
        }
        return json;
    }

    @Override
    public Pair<Integer, Integer> getFrameSize(SpritePreparationContext context, RandomTextureData data) {
        if (context.getAnimationMetadata() != null) {
            Pair<Integer, Integer> frameSize;
            AnimationMetadataSection animation = context.getAnimationMetadata();
            if (animation.frameWidth != -1 && animation.frameHeight != -1) {
                frameSize = Pair.of(animation.frameWidth, animation.frameHeight);
            } else if (animation.frameWidth != -1) {
                frameSize = Pair.of(animation.frameWidth, context.getTextureHeight());
            } else if (animation.frameHeight != -1) {
                frameSize = Pair.of(context.getTextureWidth(), animation.frameHeight);
            } else {
                int height = Math.min(context.getTextureWidth() * data.getRows() / data.getColumns(), context.getTextureHeight());
                frameSize = Pair.of(context.getTextureWidth(), height);
            }
            if (!Mth.isMultipleOf((int)context.getTextureWidth(), (int)frameSize.left()) || !Mth.isMultipleOf((int)context.getTextureHeight(), (int)frameSize.right())) {
                throw new TextureErrorException("Image size " + context.getTextureWidth() + "x" + context.getTextureHeight() + " is not a multiple of frame size " + String.valueOf(frameSize.left()) + "x" + String.valueOf(frameSize.right()) + "!");
            }
            return frameSize;
        }
        int width = context.getTextureWidth();
        int height = context.getTextureHeight();
        if (width * data.getRows() / data.getColumns() != height) {
            throw new TextureErrorException("Image aspect ratio does not match row/column aspect ratio!");
        }
        return Pair.of(width, height);
    }

    @Override
    public TextureAtlasSprite createSprite(SpriteCreationContext context, RandomTextureData data) {
        TextureAtlasSprite sprite = context.createOriginalSprite();
        sprite.u1 = sprite.u0 + (sprite.u1 - sprite.u0) / (float)data.getColumns();
        sprite.v1 = sprite.v0 + (sprite.v1 - sprite.v0) / (float)data.getRows();
        return new RandomTextureSprite(sprite, data);
    }

    public static void processQuad(MutableQuad quad, BlockPos pos, Direction side, RandomSource random, RandomTextureSprite sprite) {
        if (side == null) {
            return;
        }
        RandomTextureData data = sprite.data();
        if (data.getSeed() != null) {
            random.setSeed(data.getSeed() ^ (pos.asLong() + 1L) * (long)(side.ordinal() + 1));
        } else {
            random.setSeed((pos.asLong() + 1L) * (long)(side.ordinal() + 1));
        }
        random.nextLong();
        int x = random.nextInt(data.getColumns());
        int y = random.nextInt(data.getRows());
        if (x > 0 || y > 0) {
            float width = sprite.getU1() - sprite.getU0();
            float height = sprite.getV1() - sprite.getV0();
            for (int i = 0; i < 4; ++i) {
                quad.uv(i, quad.u(i) + (float)x * width, quad.v(i) + (float)y * height);
            }
        }
    }
}

