/*
 * Decompiled with CFR 0.152.
 */
package dev.satherov.ftbxaerocompat;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftbchunks.client.map.MapDimension;
import dev.ftb.mods.ftbchunks.net.RequestChunkChangePacket;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftbteams.api.client.KnownClientPlayer;
import dev.ftb.mods.ftbteams.data.ClientTeamManagerImpl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import xaero.map.MapProcessor;
import xaero.map.gui.GuiMap;
import xaero.map.gui.IRightClickableElement;
import xaero.map.gui.MapTileSelection;
import xaero.map.gui.dropdown.rightclick.RightClickOption;

public class FTBClaimMenu {
    public static void addRightClickOptions(GuiMap screen, ArrayList<RightClickOption> options, MapTileSelection mapTileSelection, MapProcessor mapProcessor) {
        if (mapTileSelection != null) {
            boolean admin;
            int maxRequestLength;
            if (mapProcessor.getMapWorld().isUsingCustomDimension()) {
                options.add(new RightClickOption("gui.xaero_pac_claim_selection_out_of_dimension", options.size(), (IRightClickableElement)screen){

                    public void onAction(Screen screen) {
                    }
                });
                return;
            }
            Optional optionalMap = MapDimension.getCurrent();
            if (optionalMap.isEmpty()) {
                return;
            }
            MapDimension dim = (MapDimension)optionalMap.get();
            Minecraft mc = Minecraft.getInstance();
            int fromX = mc.player.chunkPosition().x;
            int fromZ = mc.player.chunkPosition().z;
            int left = mapTileSelection.getLeft();
            int top = mapTileSelection.getTop();
            int right = mapTileSelection.getRight();
            int bottom = mapTileSelection.getBottom();
            int checkLeft = left;
            int checkTop = top;
            int checkRight = right;
            int checkBottom = bottom;
            int maxClaimDistance = 7;
            if (left < fromX - 7) {
                checkLeft = fromX - 7;
            }
            if (top < fromZ - 7) {
                checkTop = fromZ - 7;
            }
            if (right > fromX + 7) {
                checkRight = fromX + 7;
            }
            if (bottom > fromZ + 7) {
                checkBottom = fromZ + 7;
            }
            if (checkRight - checkLeft >= (maxRequestLength = 32)) {
                checkRight = checkLeft + maxRequestLength - 1;
            }
            if (checkBottom - checkTop >= maxRequestLength) {
                checkBottom = checkTop + maxRequestLength - 1;
            }
            if (left < checkLeft) {
                left = checkLeft - 1;
            }
            if (top < checkTop) {
                top = checkTop - 1;
            }
            if (right > checkRight) {
                right = checkRight + 1;
            }
            if (bottom > checkBottom) {
                bottom = checkBottom + 1;
            }
            final HashSet<XZ> chunks = new HashSet<XZ>();
            for (int cx = left; cx <= right; ++cx) {
                for (int cz = top; cz <= bottom; ++cz) {
                    chunks.add(XZ.of((int)cx, (int)cz));
                }
            }
            Set mapChunks = chunks.stream().map(xz -> dim.getRegion(XZ.regionFromChunk((int)xz.x(), (int)xz.z())).getChunkForAbsoluteChunkPos(xz)).collect(Collectors.toSet());
            final KnownClientPlayer player = ClientTeamManagerImpl.getInstance().self();
            Optional optionalTeam = ClientTeamManagerImpl.getInstance().getTeamByID(player.teamId());
            boolean bl = admin = Minecraft.getInstance().isSingleplayer() || Minecraft.getInstance().player.hasPermissions(2) && optionalTeam.isPresent() && player.extraData().getBoolean("BypassFTBChunksProtection");
            if (mapChunks.stream().anyMatch(chunk -> chunk.getClaimedDate().isEmpty())) {
                options.add(new RightClickOption("gui.xaero_pac_claim_chunks", options.size(), (IRightClickableElement)screen){

                    public void onAction(Screen screen) {
                        NetworkManager.sendToServer((CustomPacketPayload)new RequestChunkChangePacket(RequestChunkChangePacket.ChunkChangeOp.create((boolean)true, (boolean)false), chunks, admin, Optional.ofNullable(player.teamId())));
                    }
                });
            }
            if (mapChunks.stream().anyMatch(chunk -> chunk.getClaimedDate().isPresent())) {
                options.add(new RightClickOption("gui.xaero_pac_unclaim_chunks", options.size(), (IRightClickableElement)screen){

                    public void onAction(Screen screen) {
                        NetworkManager.sendToServer((CustomPacketPayload)new RequestChunkChangePacket(RequestChunkChangePacket.ChunkChangeOp.create((boolean)false, (boolean)false), chunks, admin, Optional.ofNullable(player.teamId())));
                    }
                });
            }
            if (mapChunks.stream().anyMatch(chunk -> chunk.getClaimedDate().isPresent() && chunk.getForceLoadedDate().isEmpty())) {
                options.add(new RightClickOption("gui.xaero_pac_forceload_chunks", options.size(), (IRightClickableElement)screen){

                    public void onAction(Screen screen) {
                        NetworkManager.sendToServer((CustomPacketPayload)new RequestChunkChangePacket(RequestChunkChangePacket.ChunkChangeOp.create((boolean)true, (boolean)true), chunks, admin, Optional.ofNullable(player.teamId())));
                    }
                });
            }
            if (mapChunks.stream().anyMatch(chunk -> chunk.getClaimedDate().isPresent() && chunk.getForceLoadedDate().isPresent())) {
                options.add(new RightClickOption("gui.xaero_pac_unforceload_chunks", options.size(), (IRightClickableElement)screen){

                    public void onAction(Screen screen) {
                        NetworkManager.sendToServer((CustomPacketPayload)new RequestChunkChangePacket(RequestChunkChangePacket.ChunkChangeOp.create((boolean)false, (boolean)true), chunks, admin, Optional.ofNullable(player.teamId())));
                    }
                });
            }
            if (mapChunks.isEmpty()) {
                options.add(new RightClickOption("gui.xaero_pac_claim_selection_out_of_range", options.size(), (IRightClickableElement)screen){

                    public void onAction(Screen screen) {
                    }
                });
            }
        }
    }
}

