/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbxmodcompat.neoforge.ftbchunks.waystones;

import com.mojang.logging.LogUtils;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import dev.ftb.mods.ftbxmodcompat.ClientUtil;
import dev.ftb.mods.ftbxmodcompat.config.FTBXModConfig;
import dev.ftb.mods.ftbxmodcompat.ftbchunks.waystones.WaystoneData;
import dev.ftb.mods.ftbxmodcompat.ftbchunks.waystones.WaystoneMapIcon;
import dev.ftb.mods.ftbxmodcompat.ftbchunks.waystones.WaystonesCommon;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.blay09.mods.waystones.api.WaystonesAPI;
import net.blay09.mods.waystones.api.event.WaystoneRemoveReceivedEvent;
import net.blay09.mods.waystones.api.event.WaystoneUpdatedEvent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;

public class WaystonesCompat {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void init() {
        Balm.getEvents().onEvent(WaystoneUpdatedEvent.class, WaystonesCompat::updateWaystone);
        Balm.getEvents().onEvent(WaystoneRemoveReceivedEvent.class, WaystonesCompat::removeWaystone);
    }

    private static void removeWaystone(WaystoneRemoveReceivedEvent event) {
        LOGGER.trace("Waystone removed: {}", (Object)event.getWaystoneId());
        WaystonesCommon.removeWaystone(event.getWaystoneId());
    }

    private static void updateWaystone(WaystoneUpdatedEvent event) {
        LOGGER.trace("waystone updated: {} {}", (Object)event.getWaystone().getWaystoneUid(), (Object)event.getWaystone().getVisibility());
        Waystone w = event.getWaystone();
        if (Platform.getEnvironment() == Env.CLIENT && (!((Boolean)FTBXModConfig.ONLY_SHOW_KNOWN_WAYSTONES.get()).booleanValue() || WaystonesAPI.isWaystoneActivated((Player)ClientUtil.getClientPlayer(), (Waystone)w))) {
            WaystonesCommon.updateWaystone(w.getWaystoneUid(), new WaystoneData((ResourceKey<Level>)w.getDimension(), new WaystoneMapIcon(w.getPos(), w.getName(), w.getVisibility() == WaystoneVisibility.GLOBAL)));
        }
    }
}

