/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.api.property;

import com.google.gson.JsonObject;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.ftb.mods.ftbteams.api.event.TeamCollectPropertiesEvent;
import dev.ftb.mods.ftbteams.api.event.TeamEvent;
import dev.ftb.mods.ftbteams.api.property.TeamProperty;
import java.util.LinkedHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class TeamPropertyArgument
implements ArgumentType<TeamProperty<?>> {
    private static final SimpleCommandExceptionType PROPERTY_NOT_FOUND = new SimpleCommandExceptionType((Message)Component.translatable((String)"ftbteams.property_not_found"));

    public static TeamPropertyArgument create() {
        return new TeamPropertyArgument();
    }

    public static TeamProperty<?> get(CommandContext<CommandSourceStack> context, String name) {
        return (TeamProperty)context.getArgument(name, TeamProperty.class);
    }

    private TeamPropertyArgument() {
    }

    public TeamProperty<?> parse(StringReader reader) throws CommandSyntaxException {
        ResourceLocation id = ResourceLocation.read((StringReader)reader);
        LinkedHashMap map = new LinkedHashMap();
        ((Consumer)TeamEvent.COLLECT_PROPERTIES.invoker()).accept(new TeamCollectPropertiesEvent(property -> map.put(property.id, property)));
        TeamProperty property2 = (TeamProperty)map.get(id);
        if (property2 != null) {
            return property2;
        }
        throw PROPERTY_NOT_FOUND.create();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        try {
            LinkedHashMap map = new LinkedHashMap();
            ((Consumer)TeamEvent.COLLECT_PROPERTIES.invoker()).accept(new TeamCollectPropertiesEvent(property -> map.put(property.id.toString(), property)));
            return SharedSuggestionProvider.suggest(map.keySet(), (SuggestionsBuilder)builder);
        }
        catch (Exception ex) {
            return Suggestions.empty();
        }
    }

    public static class Info
    implements ArgumentTypeInfo<TeamPropertyArgument, Template> {
        public void serializeToNetwork(Template template, FriendlyByteBuf friendlyByteBuf) {
        }

        public Template deserializeFromNetwork(FriendlyByteBuf friendlyByteBuf) {
            return new Template();
        }

        public void serializeToJson(Template template, JsonObject jsonObject) {
        }

        public Template unpack(TeamPropertyArgument argumentType) {
            return new Template();
        }

        public final class Template
        implements ArgumentTypeInfo.Template<TeamPropertyArgument> {
            public TeamPropertyArgument instantiate(CommandBuildContext commandBuildContext) {
                return TeamPropertyArgument.create();
            }

            public ArgumentTypeInfo<TeamPropertyArgument, ?> type() {
                return Info.this;
            }
        }
    }
}

