/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.util.neoforge;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class InventoryUtilImpl {
    public static NonNullList<ItemStack> getItemsInInventory(Level level, BlockPos pos, Direction side) {
        IItemHandler handler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)side);
        NonNullList items = NonNullList.create();
        if (handler != null) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                items.add((Object)stack);
            }
        }
        return items;
    }

    public static boolean putItemsInInventory(List<ItemStack> items, Level level, BlockPos pos, Direction side, boolean clearFirst) {
        IItemHandler handler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)side);
        if (handler == null) {
            throw new IllegalArgumentException("No item handler at that blockpos & side");
        }
        if (clearFirst) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                handler.extractItem(i, Integer.MAX_VALUE, false);
            }
        }
        for (ItemStack stack : items) {
            ItemStack excess = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack.copy(), (boolean)false);
            if (excess.isEmpty()) continue;
            return false;
        }
        return true;
    }
}

