/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.manager.ConfigManager;
import dev.ftb.mods.ftblibrary.snbt.config.BaseValue;
import dev.ftb.mods.ftblibrary.snbt.config.BooleanValue;
import dev.ftb.mods.ftblibrary.snbt.config.DoubleValue;
import dev.ftb.mods.ftblibrary.snbt.config.EnumValue;
import dev.ftb.mods.ftblibrary.snbt.config.IntValue;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;
import dev.ftb.mods.ftblibrary.snbt.config.StringValue;
import dev.ftb.mods.ftblibrary.util.PanelPositioning;
import dev.ftb.mods.ftbquests.client.AutoPinTarget;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.NotificationStyle;
import dev.ftb.mods.ftbquests.client.config.LocaleValue;
import dev.ftb.mods.ftbquests.client.gui.QuestsClientConfigScreen;

public interface FTBQuestsClientConfig {
    public static final String KEY = "ftbquests-client";
    public static final SNBTConfig CONFIG = SNBTConfig.create((String)"ftbquests-client");
    public static final SNBTConfig UI = CONFIG.addGroup("ui", 0);
    public static final BooleanValue OLD_SCROLL_WHEEL = UI.addBoolean("old_scroll_wheel", false);
    public static final BooleanValue SHOW_LOCK_ICON = UI.addBoolean("show_lock_icon", true);
    public static final BooleanValue BACKSPACE_HISTORY = UI.addBoolean("backspace_history", true);
    public static final BooleanValue CHAPTER_PANEL_PINNED = UI.addBoolean("chapter_panel_pinned", false);
    public static final SNBTConfig NOTIFICATIONS = CONFIG.addGroup("notifications", 1);
    public static final EnumValue<NotificationStyle> COMPLETION_STYLE = NOTIFICATIONS.addEnum("completion_style", NotificationStyle.NAME_MAP);
    public static final EnumValue<NotificationStyle> REWARD_STYLE = NOTIFICATIONS.addEnum("reward_style", NotificationStyle.NAME_MAP);
    public static final BooleanValue COMPLETION_SOUNDS = NOTIFICATIONS.addBoolean("completion_sounds", true);
    public static final SNBTConfig PINNED = CONFIG.addGroup("pinned", 2);
    public static final EnumValue<AutoPinTarget> AUTO_PIN_FOLLOWS = PINNED.addEnum("auto_pin_follows", AutoPinTarget.NAME_MAP, (Object)AutoPinTarget.CHAPTER);
    public static final EnumValue<PanelPositioning> PINNED_QUESTS_POS = PINNED.addEnum("pinned_quests_pos", PanelPositioning.NAME_MAP, (Object)PanelPositioning.RIGHT);
    public static final IntValue PINNED_QUESTS_INSET_X = PINNED.addInt("pinned_quests_inset_x", 2);
    public static final IntValue PINNED_QUESTS_INSET_Y = PINNED.addInt("pinned_quests_inset_y", 2);
    public static final DoubleValue PINNED_QUESTS_SCALE = PINNED.addDouble("pinned_quests_scale", 0.75, 0.25, 2.0);
    public static final SNBTConfig XLATE = CONFIG.addGroup("xlate", 3);
    public static final StringValue EDITING_LOCALE = (StringValue)XLATE.add((BaseValue)new LocaleValue(XLATE, "editing_locale", ""));
    public static final StringValue FALLBACK_LOCALE = (StringValue)XLATE.add((BaseValue)new LocaleValue(XLATE, "fallback_locale", ""));
    public static final BooleanValue HILITE_MISSING = XLATE.addBoolean("hilite_missing", true);

    public static void openSettings(boolean pauseGame) {
        ConfigManager.getInstance().createConfigGroup(KEY).ifPresent(group -> new QuestsClientConfigScreen((ConfigGroup)group, pauseGame).openGui());
    }

    public static void setChapterPanelPinned(boolean pinned) {
        if (pinned != (Boolean)CHAPTER_PANEL_PINNED.get()) {
            CHAPTER_PANEL_PINNED.set((Object)pinned);
            ConfigManager.getInstance().save(KEY);
        }
    }

    public static void onEdited(boolean ignoredClientSide) {
        ClientQuestFile.INSTANCE.clearCachedData();
    }
}

