/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbfiltersystem.api.filter;

import dev.ftb.mods.ftbfiltersystem.api.FTBFilterSystemAPI;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public interface SmartFilter
extends Predicate<ItemStack> {
    public ResourceLocation getId();

    @Nullable
    public Compound getParent();

    public Component getDisplayName();

    default public String asString(HolderLookup.Provider registryAccess) {
        return FTBFilterSystemAPI.modDefaultedString(this.getId()) + "(" + this.getStringArg(registryAccess) + ")";
    }

    public String getStringArg(HolderLookup.Provider var1);

    default public Component getDisplayArg(HolderLookup.Provider registryAccess) {
        return Component.literal((String)this.getStringArg(registryAccess));
    }

    default public boolean isConfigurable() {
        return true;
    }

    @FunctionalInterface
    public static interface DefaultFactory<T extends SmartFilter> {
        public T create(Compound var1);
    }

    @FunctionalInterface
    public static interface Factory<T extends SmartFilter> {
        public T create(Compound var1, String var2, HolderLookup.Provider var3);
    }

    public static interface Compound
    extends SmartFilter {
        public List<SmartFilter> getChildren();

        default public int maxChildren() {
            return Integer.MAX_VALUE;
        }
    }
}

