/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.commands.impl.teleporting;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.ftb.mods.ftbessentials.commands.CommandUtils;
import dev.ftb.mods.ftbessentials.commands.FTBCommand;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.FTBEWorldData;
import dev.ftb.mods.ftbessentials.util.TeleportPos;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class WarpCommand
implements FTBCommand {
    @Override
    public boolean enabled() {
        return FTBEConfig.WARP.isEnabled();
    }

    @Override
    public List<LiteralArgumentBuilder<CommandSourceStack>> register() {
        return List.of((LiteralArgumentBuilder)Commands.literal((String)"warp").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> SharedSuggestionProvider.suggest(this.getWarpSuggestions(), (SuggestionsBuilder)builder)).executes(context -> this.warp(((CommandSourceStack)context.getSource()).getPlayerOrException(), StringArgumentType.getString((CommandContext)context, (String)"name")))), (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"setwarp").requires(CommandUtils.isGamemaster())).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(context -> this.setWarp(((CommandSourceStack)context.getSource()).getPlayerOrException(), StringArgumentType.getString((CommandContext)context, (String)"name")))), (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"delwarp").requires(CommandUtils.isGamemaster())).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> SharedSuggestionProvider.suggest(this.getWarpSuggestions(), (SuggestionsBuilder)builder)).executes(context -> this.deleteWarp(((CommandSourceStack)context.getSource()).getPlayerOrException(), StringArgumentType.getString((CommandContext)context, (String)"name")))), (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"listwarps").requires((Predicate)FTBEConfig.WARP)).executes(context -> this.listWarps((CommandSourceStack)context.getSource())));
    }

    private Set<String> getWarpSuggestions() {
        return FTBEWorldData.instance.warpManager().getNames();
    }

    private int warp(ServerPlayer player, String name) {
        return FTBEPlayerData.getOrCreate((Player)player).map(data -> FTBEWorldData.instance.warpManager().teleportTo(name, player, data.warpTeleporter).runCommand(player)).orElse(0);
    }

    private int setWarp(ServerPlayer player, String name) {
        FTBEWorldData.instance.warpManager().addDestination(name, new TeleportPos((Entity)player), player);
        player.displayClientMessage((Component)Component.translatable((String)"ftbessentials.warp.set"), false);
        return 1;
    }

    private int deleteWarp(ServerPlayer player, String name) {
        if (FTBEWorldData.instance.warpManager().deleteDestination(name.toLowerCase())) {
            player.displayClientMessage((Component)Component.translatable((String)"ftbessentials.warp.deleted"), false);
            return 1;
        }
        player.displayClientMessage((Component)Component.translatable((String)"ftbessentials.warp.not_found"), false);
        return 0;
    }

    private int listWarps(CommandSourceStack source) {
        if (FTBEWorldData.instance.warpManager().getNames().isEmpty()) {
            source.sendSuccess(() -> Component.translatable((String)"ftbessentials.none"), false);
        } else {
            TeleportPos origin = new TeleportPos((ResourceKey<Level>)source.getLevel().dimension(), BlockPos.containing((Position)source.getPosition()));
            FTBEWorldData.instance.warpManager().destinations().forEach(entry -> {
                MutableComponent line = Component.translatable((String)"ftbessentials.home.show_home", (Object[])new Object[]{Component.literal((String)entry.name()).withStyle(ChatFormatting.AQUA), entry.destination().distanceString(origin)});
                if (source.hasPermission(2)) {
                    line.withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tp @s " + entry.destination().posAsString())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"ftbessentials.click_to_teleport"))));
                }
                source.sendSuccess(() -> line, false);
            });
        }
        return 1;
    }
}

