/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.commands.impl.kit;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.ftb.mods.ftbessentials.commands.CommandUtils;
import dev.ftb.mods.ftbessentials.commands.FTBCommand;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.kit.Kit;
import dev.ftb.mods.ftbessentials.kit.KitManager;
import dev.ftb.mods.ftbessentials.util.BlockUtil;
import dev.ftb.mods.ftbessentials.util.DurationInfo;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.InventoryUtil;
import dev.ftb.mods.ftblibrary.util.TimeUtils;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import joptsimple.internal.Strings;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class KitCommand
implements FTBCommand {
    public static final SimpleCommandExceptionType NOT_LOOKING_AT_BLOCK = new SimpleCommandExceptionType((Message)Component.translatable((String)"ftbessentials.kit.not_looking_at_block"));
    public static final SimpleCommandExceptionType NO_ITEMS_TO_ADD = new SimpleCommandExceptionType((Message)Component.translatable((String)"ftbessentials.kit.no_items"));
    public static final SimpleCommandExceptionType NOT_ENOUGH_SPACE = new SimpleCommandExceptionType((Message)Component.translatable((String)"ftbessentials.kit.not_enough_space"));
    public static final DynamicCommandExceptionType NO_SUCH_KIT = new DynamicCommandExceptionType(kitName -> Component.translatable((String)"ftbessentials.kit.no_such_kit", (Object[])new Object[]{kitName}));
    public static final DynamicCommandExceptionType NO_KIT_PERMISSION = new DynamicCommandExceptionType(kitName -> Component.translatable((String)"ftbessentials.kit.no_permission", (Object[])new Object[]{kitName}));
    public static final DynamicCommandExceptionType UNKNOWN_PLAYER_ID = new DynamicCommandExceptionType(playerId -> Component.translatable((String)"ftbessentials.unknown_player_id", (Object[])new Object[]{playerId}));
    public static final Dynamic2CommandExceptionType ONE_TIME_ONLY = new Dynamic2CommandExceptionType((kitName, playerName) -> Component.translatable((String)"ftbessentials.kit.one_time_only", (Object[])new Object[]{kitName, playerName}));
    public static final Dynamic2CommandExceptionType ON_COOLDOWN = new Dynamic2CommandExceptionType((kitName, remaining) -> Component.translatable((String)"ftbessentials.kit.on_cooldown", (Object[])new Object[]{kitName, remaining}));
    public static final DynamicCommandExceptionType ALREADY_EXISTS = new DynamicCommandExceptionType(kitName -> Component.translatable((String)"ftbessentials.kit.already_exists", (Object[])new Object[]{kitName}));

    @Override
    public boolean enabled() {
        return FTBEConfig.KIT.isEnabled();
    }

    @Override
    public List<LiteralArgumentBuilder<CommandSourceStack>> register() {
        return List.of((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"kit").requires(CommandUtils.isGamemaster())).then(Commands.literal((String)"create_from_player_inv").then(((RequiredArgumentBuilder)Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> KitCommand.createKitFromPlayer((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), "", false))).then(Commands.argument((String)"cooldown", (ArgumentType)StringArgumentType.greedyString()).suggests((ctx, builder) -> CommandUtils.suggestCooldowns(builder)).executes(ctx -> KitCommand.createKitFromPlayer((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), StringArgumentType.getString((CommandContext)ctx, (String)"cooldown"), false)))))).then(Commands.literal((String)"create_from_player_hotbar").then(((RequiredArgumentBuilder)Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> KitCommand.createKitFromPlayer((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), "", true))).then(Commands.argument((String)"cooldown", (ArgumentType)StringArgumentType.greedyString()).suggests((ctx, builder) -> CommandUtils.suggestCooldowns(builder)).executes(ctx -> KitCommand.createKitFromPlayer((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), StringArgumentType.getString((CommandContext)ctx, (String)"cooldown"), true)))))).then(Commands.literal((String)"create_from_block_inv").then(((RequiredArgumentBuilder)Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> KitCommand.createKitFromBlock((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), ""))).then(Commands.argument((String)"cooldown", (ArgumentType)StringArgumentType.greedyString()).suggests((ctx, builder) -> CommandUtils.suggestCooldowns(builder)).executes(ctx -> KitCommand.createKitFromBlock((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), StringArgumentType.getString((CommandContext)ctx, (String)"cooldown"))))))).then(Commands.literal((String)"delete").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> KitCommand.suggestKits(builder)).executes(ctx -> KitCommand.deleteKit((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name")))))).then(Commands.literal((String)"list").executes(ctx -> KitCommand.listKits((CommandSourceStack)ctx.getSource())))).then(Commands.literal((String)"show").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> KitCommand.suggestKits(builder)).executes(ctx -> KitCommand.showKit((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name")))))).then(Commands.literal((String)"give").then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> KitCommand.suggestKits(builder)).executes(ctx -> KitCommand.giveKit((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), EntityArgument.getPlayers((CommandContext)ctx, (String)"players"))))))).then(Commands.literal((String)"put_in_block_inv").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> KitCommand.suggestKits(builder)).executes(ctx -> KitCommand.putKitInBlockInv((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name")))))).then(Commands.literal((String)"cooldown").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> KitCommand.suggestKits(builder)).then(Commands.argument((String)"cooldown", (ArgumentType)StringArgumentType.greedyString()).suggests((ctx, builder) -> CommandUtils.suggestCooldowns(builder)).executes(ctx -> KitCommand.modifyCooldown((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), StringArgumentType.getString((CommandContext)ctx, (String)"cooldown"))))))).then(Commands.literal((String)"reset_cooldown").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> KitCommand.suggestKits(builder)).executes(ctx -> KitCommand.resetCooldowns((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name")))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(ctx -> KitCommand.resetCooldowns((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), EntityArgument.getPlayer((CommandContext)ctx, (String)"player"))))).then(Commands.argument((String)"id", (ArgumentType)UuidArgument.uuid()).executes(ctx -> KitCommand.resetCooldowns((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), UuidArgument.getUuid((CommandContext)ctx, (String)"id"))))))).then(Commands.literal((String)"set_autogrant").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> KitCommand.suggestKits(builder)).then(Commands.argument((String)"grant", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> KitCommand.modifyAutogrant((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), BoolArgumentType.getBool((CommandContext)ctx, (String)"grant")))))));
    }

    private static int putKitInBlockInv(CommandSourceStack source, String kitName) throws CommandSyntaxException {
        ServerPlayer player = source.getPlayerOrException();
        BlockHitResult res = BlockUtil.getFocusedBlock(player, 5.5).orElseThrow(() -> ((SimpleCommandExceptionType)NOT_LOOKING_AT_BLOCK).create());
        Kit kit = KitManager.getInstance().get(kitName).orElseThrow(() -> NO_SUCH_KIT.create((Object)kitName));
        if (!InventoryUtil.putItemsInInventory(kit.getItems(), player.level(), res.getBlockPos(), res.getDirection())) {
            throw NOT_ENOUGH_SPACE.create();
        }
        source.sendSuccess(() -> Component.translatable((String)"ftbessentials.kit.added_items", (Object[])new Object[]{kitName}).withStyle(ChatFormatting.YELLOW), false);
        return 1;
    }

    private static CompletableFuture<Suggestions> suggestKits(SuggestionsBuilder builder) {
        return KitCommand.suggestKits(null, builder);
    }

    static CompletableFuture<Suggestions> suggestKits(@Nullable ServerPlayer player, SuggestionsBuilder builder) {
        List<String> list = KitManager.getInstance().allKits().stream().filter(kit -> kit.playerCanGetKit(player)).map(Kit::getKitName).toList();
        return SharedSuggestionProvider.suggest(list, (SuggestionsBuilder)builder);
    }

    private static int createKitFromPlayer(CommandSourceStack source, String name, String cooldown, boolean hotbarOnly) throws CommandSyntaxException {
        long secs = DurationInfo.getSeconds(cooldown);
        KitManager.getInstance().createFromPlayerInv(name, source.getPlayerOrException(), secs, hotbarOnly);
        source.sendSuccess(() -> Component.translatable((String)"ftbessentials.kit.created", (Object[])new Object[]{name}).withStyle(ChatFormatting.YELLOW), false);
        return 1;
    }

    private static int createKitFromBlock(CommandSourceStack source, String name, String cooldown) throws CommandSyntaxException {
        long secs = DurationInfo.getSeconds(cooldown);
        ServerPlayer player = source.getPlayerOrException();
        BlockHitResult res = BlockUtil.getFocusedBlock(player, 5.5).orElseThrow(() -> ((SimpleCommandExceptionType)NOT_LOOKING_AT_BLOCK).create());
        KitManager.getInstance().createFromBlockInv(name, player.level(), res.getBlockPos(), res.getDirection(), secs);
        source.sendSuccess(() -> Component.translatable((String)"ftbessentials.kit.created", (Object[])new Object[]{name}).withStyle(ChatFormatting.YELLOW), false);
        return 1;
    }

    static int giveKit(CommandSourceStack source, String name, Collection<ServerPlayer> players) throws CommandSyntaxException {
        if (!source.hasPermission(2) && players.size() == 1 && source.getPlayer() != null && players.contains(source.getPlayer()) && !Kit.checkPermissionNode(source.getPlayer(), name)) {
            throw NO_KIT_PERMISSION.create((Object)name);
        }
        for (ServerPlayer player : players) {
            KitManager.getInstance().giveKitToPlayer(name, player);
        }
        source.sendSuccess(() -> Component.translatable((String)"ftbessentials.kit.gave_to_players", (Object[])new Object[]{name, players.size()}).withStyle(ChatFormatting.YELLOW), false);
        return 1;
    }

    private static int listKits(CommandSourceStack source) {
        Collection<Kit> kits = KitManager.getInstance().allKits();
        source.sendSuccess(() -> Component.translatable((String)"ftbessentials.kit.count", (Object[])new Object[]{kits.size()}).withStyle(ChatFormatting.AQUA), false);
        kits.stream().sorted(Comparator.comparing(Kit::getKitName)).forEach(kit -> source.sendSuccess(() -> Component.literal((String)("\u2022 " + kit.getKitName())).withStyle(Style.EMPTY.withColor(ChatFormatting.YELLOW).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/kit show " + kit.getKitName()))), false));
        return 1;
    }

    private static int showKit(CommandSourceStack source, String kitName) throws CommandSyntaxException {
        Kit kit = KitManager.getInstance().get(kitName).orElseThrow(() -> NO_SUCH_KIT.create((Object)kitName));
        source.sendSuccess(() -> Component.literal((String)Strings.repeat((char)'-', (int)40)).withStyle(ChatFormatting.GREEN), false);
        source.sendSuccess(() -> Component.translatable((String)"ftbessentials.kit_name", (Object[])new Object[]{Component.literal((String)kit.getKitName()).withStyle(ChatFormatting.YELLOW)}).withStyle(ChatFormatting.AQUA), false);
        if (kit.getCooldown() > 0L) {
            source.sendSuccess(() -> Component.literal((String)"  ").append((Component)Component.translatable((String)"ftbessentials.kit.cooldown", (Object[])new Object[]{Component.literal((String)TimeUtils.prettyTimeString((long)kit.getCooldown())).withStyle(ChatFormatting.YELLOW)})).withStyle(ChatFormatting.AQUA), false);
        } else if (kit.getCooldown() == 0L) {
            source.sendSuccess(() -> Component.literal((String)"  ").append((Component)Component.translatable((String)"ftbessentials.kit.cooldown.none")).withStyle(ChatFormatting.AQUA), false);
        } else {
            source.sendSuccess(() -> Component.literal((String)"  ").append((Component)Component.translatable((String)"ftbessentials.kit.one_time")).withStyle(ChatFormatting.AQUA), false);
        }
        if (kit.isAutoGrant()) {
            source.sendSuccess(() -> Component.literal((String)"  ").append((Component)Component.translatable((String)"ftbessentials.kit.autogranted")).withStyle(ChatFormatting.AQUA), false);
        }
        source.sendSuccess(() -> Component.literal((String)"  ").append((Component)Component.translatable((String)"ftbessentials.kit.items")).withStyle(ChatFormatting.AQUA), false);
        for (ItemStack stack : kit.getItems()) {
            source.sendSuccess(() -> Component.literal((String)"  \u2022 ").withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)(stack.getCount() + " x ")).withStyle(ChatFormatting.WHITE)).append(stack.getDisplayName()), false);
        }
        return 1;
    }

    private static int deleteKit(CommandSourceStack source, String kitName) throws CommandSyntaxException {
        KitManager.getInstance().get(kitName).orElseThrow(() -> NO_SUCH_KIT.create((Object)kitName));
        KitManager.getInstance().deleteKit(kitName);
        source.sendSuccess(() -> Component.translatable((String)"ftbessentials.kit.deleted", (Object[])new Object[]{kitName}).withStyle(ChatFormatting.YELLOW), false);
        return 1;
    }

    private static int modifyAutogrant(CommandSourceStack source, String kitName, boolean grant) throws CommandSyntaxException {
        Kit kit = KitManager.getInstance().get(kitName).orElseThrow(() -> NO_SUCH_KIT.create((Object)kitName));
        KitManager.getInstance().addKit(kit.withAutoGrant(grant), true);
        source.sendSuccess(() -> Component.translatable((String)"ftbessentials.kit.autogrant_modified", (Object[])new Object[]{kitName, grant}).withStyle(ChatFormatting.YELLOW), false);
        return 1;
    }

    private static int modifyCooldown(CommandSourceStack source, String kitName, String cooldown) throws CommandSyntaxException {
        Kit kit = KitManager.getInstance().get(kitName).orElseThrow(() -> NO_SUCH_KIT.create((Object)kitName));
        long secs = DurationInfo.getSeconds(cooldown);
        KitManager.getInstance().addKit(kit.withCooldown(secs), true);
        MutableComponent newTime = secs < 0L ? Component.translatable((String)"ftbessentials.kit.one_time") : Component.literal((String)TimeUtils.prettyTimeString((long)secs));
        source.sendSuccess(() -> KitCommand.lambda$modifyCooldown$56(kitName, (Component)newTime), false);
        return 1;
    }

    private static int resetCooldowns(CommandSourceStack source, String name, ServerPlayer player) throws CommandSyntaxException {
        return KitCommand.resetCooldowns(source, name, player.getUUID());
    }

    private static int resetCooldowns(CommandSourceStack source, String kitName, UUID playerId) throws CommandSyntaxException {
        KitManager.getInstance().get(kitName).orElseThrow(() -> NO_SUCH_KIT.create((Object)kitName));
        if (!FTBEPlayerData.playerExists(playerId)) {
            throw UNKNOWN_PLAYER_ID.create((Object)playerId);
        }
        return FTBEPlayerData.getOrCreate(source.getServer(), playerId).map(data -> {
            data.setLastKitUseTime(kitName, 0L);
            source.sendSuccess(() -> Component.translatable((String)"ftbessentials.kit.cooldown_reset", (Object[])new Object[]{kitName, playerId}).withStyle(ChatFormatting.YELLOW), false);
            return 1;
        }).orElse(0);
    }

    private static int resetCooldowns(CommandSourceStack source, String kitName) throws CommandSyntaxException {
        KitManager.getInstance().get(kitName).orElseThrow(() -> NO_SUCH_KIT.create((Object)kitName));
        if (KitManager.getInstance().get(kitName).isPresent()) {
            FTBEPlayerData.cleanupKitCooldowns(kitName);
            source.sendSuccess(() -> Component.translatable((String)"ftbessentials.kit.cooldown_reset_all", (Object[])new Object[]{kitName}).withStyle(ChatFormatting.YELLOW), false);
            return 1;
        }
        return 0;
    }

    private static /* synthetic */ Component lambda$modifyCooldown$56(String kitName, Component newTime) {
        return Component.translatable((String)"ftbessentials.kit.cooldown_modified", (Object[])new Object[]{kitName, newTime}).withStyle(ChatFormatting.YELLOW);
    }
}

