/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.api.client.icon;

import dev.ftb.mods.ftbchunks.api.client.icon.MapType;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.math.MathUtils;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public interface MapIcon {
    public Vec3 getPos(float var1);

    default public boolean isVisible(MapType mapType, double distanceToPlayer, boolean outsideVisibleArea) {
        return !mapType.isWorldIcon();
    }

    default public double getIconScale(MapType mapType) {
        return 1.0;
    }

    default public boolean isIconOnEdge(MapType mapType, boolean outsideVisibleArea) {
        return false;
    }

    default public boolean isZoomDependant(MapType mapType) {
        return false;
    }

    default public int getPriority() {
        return 0;
    }

    default public void addTooltip(TooltipList list) {
        LocalPlayer player = Minecraft.getInstance().player;
        Vec3 pos = this.getPos(1.0f);
        list.styledString(String.format("%,d m", Mth.ceil((double)MathUtils.dist((double)player.getX(), (double)player.getZ(), (double)pos.x, (double)pos.z))), ChatFormatting.GRAY);
    }

    public boolean onMousePressed(BaseScreen var1, MouseButton var2);

    public boolean onKeyPressed(BaseScreen var1, Key var2);

    public void draw(MapType var1, GuiGraphics var2, int var3, int var4, int var5, int var6, boolean var7, int var8);

    public static class SimpleMapIcon
    implements MapIcon {
        protected final Vec3 pos;
        protected Icon icon;

        public SimpleMapIcon(Vec3 pos, Icon icon) {
            this.pos = pos;
            this.icon = icon;
        }

        public SimpleMapIcon(Vec3 pos) {
            this(pos, (Icon)Color4I.empty());
        }

        @Override
        public Vec3 getPos(float partialTick) {
            return this.pos;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public void setIcon(Icon icon) {
            this.icon = icon;
        }

        @Override
        public void draw(MapType mapType, GuiGraphics graphics, int x, int y, int w, int h, boolean outsideVisibleArea, int iconAlpha) {
            if (!this.icon.isEmpty()) {
                this.icon.draw(graphics, x, y, w, h);
            }
        }

        @Override
        public boolean onMousePressed(BaseScreen screen, MouseButton button) {
            return false;
        }

        @Override
        public boolean onKeyPressed(BaseScreen screen, Key key) {
            return false;
        }
    }
}

