/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks;

import dev.architectury.platform.Platform;
import dev.ftb.mods.ftbchunks.api.ChunkTeamData;
import dev.ftb.mods.ftbchunks.api.ProtectionPolicy;
import dev.ftb.mods.ftbchunks.data.AllyMode;
import dev.ftb.mods.ftbchunks.data.ClaimedChunkManagerImpl;
import dev.ftb.mods.ftbchunks.data.ForceLoadMode;
import dev.ftb.mods.ftbchunks.data.PartyLimitMode;
import dev.ftb.mods.ftbchunks.data.PvPMode;
import dev.ftb.mods.ftbchunks.integration.PermissionsHelper;
import dev.ftb.mods.ftbchunks.util.ChunkPosCustomYSetValue;
import dev.ftb.mods.ftbchunks.util.DimensionFilter;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.integration.stages.StageHelper;
import dev.ftb.mods.ftblibrary.snbt.config.BaseValue;
import dev.ftb.mods.ftblibrary.snbt.config.BooleanValue;
import dev.ftb.mods.ftblibrary.snbt.config.DoubleValue;
import dev.ftb.mods.ftblibrary.snbt.config.EnumValue;
import dev.ftb.mods.ftblibrary.snbt.config.IntValue;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;
import dev.ftb.mods.ftblibrary.snbt.config.StringListValue;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.property.PrivacyMode;
import java.util.Collections;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public interface FTBChunksWorldConfig {
    public static final String KEY = "ftbchunks-world";
    public static final SNBTConfig CONFIG = (SNBTConfig)SNBTConfig.create((String)"ftbchunks-world").comment(new String[]{"Server-specific configuration for FTB Chunks", "Modpack defaults should be defined in <instance>/config/ftbchunks-world.snbt", "  (may be overwritten on modpack update)", "Server admins may locally override this by copying into <instance>/world/serverconfig/ftbchunks-world.snbt", "  (will NOT be overwritten on modpack update)"});
    public static final BooleanValue DISABLE_PROTECTION = (BooleanValue)CONFIG.addBoolean("disable_protection", false).comment(new String[]{"Disables all land protection. Useful for private servers where everyone is trusted and claims are only used for force-loading"});
    public static final EnumValue<AllyMode> ALLY_MODE = (EnumValue)CONFIG.addEnum("ally_mode", AllyMode.NAME_MAP).comment(new String[]{"Forced modes won't let players change their ally settings"});
    public static final EnumValue<PvPMode> PVP_MODE = (EnumValue)CONFIG.addEnum("pvp_mode", PvPMode.NAME_MAP).comment(new String[]{"Should PvP combat be allowed in claimed chunks? Default is ALWAYS; NEVER prevents it in all claimed chunks; PER_TEAM allows teams to decide if PvP is allowed in their claims"});
    public static final BooleanValue NO_WILDERNESS = (BooleanValue)CONFIG.addBoolean("no_wilderness", false).comment(new String[]{"Requires you to claim chunks in order to edit and interact with blocks"});
    public static final StringListValue NO_WILDERNESS_DIMENSIONS = (StringListValue)CONFIG.addStringList("no_wilderness_dimensions", Collections.emptyList()).comment(new String[]{"Dimension ID's where the no_wilderness rule is enforced - building is only allowed in claimed chunks. If this is non-empty, it overrides the 'no_wilderness' setting."});
    public static final BooleanValue FORCE_DISABLE_MINIMAP = (BooleanValue)CONFIG.addBoolean("force_disable_minimap", false).comment(new String[]{"Minimap for clients connecting to this server will be disabled"});
    public static final IntValue LONG_RANGE_TRACKER_INTERVAL = (IntValue)CONFIG.addInt("long_range_tracker_interval", 20, 0, Integer.MAX_VALUE).comment(new String[]{"Interval in ticks to send updates to clients with long-range player tracking data.", "Lower values mean more frequent updates but more server load and network traffic; be careful with this, especially on busy servers.", "Setting this to 0 disables long-range tracking."});
    public static final BooleanValue PROTECT_UNKNOWN_EXPLOSIONS = (BooleanValue)CONFIG.addBoolean("protect_unknown_explosions", true).comment(new String[]{"When true, standard FTB Chunk explosion protection is applied in protected chunks when the source of the explosion cannot be determined", "(Ghast fireballs are a common case - vanilla supplies a null entity source)"});
    public static final BooleanValue REQUIRE_GAME_STAGE = (BooleanValue)CONFIG.addBoolean("require_game_stage", false).comment(new String[]{"If true, the player must have the 'ftbchunks_mapping' Game stage to be able to use the map and minimap.\nRequires KubeJS and/or Gamestages to be installed."});
    public static final BooleanValue LOCATION_MODE_OVERRIDE = (BooleanValue)CONFIG.addBoolean("location_mode_override", false).comment(new String[]{"If true, \"Location Visibility\" team settings are ignored, and all players can see each other anywhere on the map."});
    public static final BooleanValue PISTON_PROTECTION = (BooleanValue)CONFIG.addBoolean("piston_protection", true).comment(new String[]{"If true, pistons are prevented from pushing/pulling blocks across claims owned by different teams (unless the target claim has public 'edit block' permissions defined). If 'disable_protection' is set to true, this setting is ignored."});
    public static final SNBTConfig FAKE_PLAYERS = CONFIG.addGroup("fake_players");
    public static final EnumValue<ProtectionPolicy> ALLOW_FAKE_PLAYERS = (EnumValue)FAKE_PLAYERS.addEnum("fake_players", NameMap.of((Object)((Object)ProtectionPolicy.CHECK), (Object[])ProtectionPolicy.values()).create()).comment(new String[]{"Override to disable/enable fake players like miners and auto-clickers globally.", "Default will check this setting for each team"});
    public static final IntValue MAX_PREVENTED_LOG_AGE = (IntValue)FAKE_PLAYERS.addInt("max_prevented_log_age", 7, 1, Integer.MAX_VALUE).comment(new String[]{"Maximum time in days to keep logs of prevented fakeplayer access to a team's claims."});
    public static final SNBTConfig CLAIMING = CONFIG.addGroup("claiming");
    public static final IntValue MAX_CLAIMED_CHUNKS = (IntValue)CLAIMING.addInt("max_claimed_chunks", 500).comment(new String[]{"Max claimed chunks.", "You can override this with FTB Ranks 'ftbchunks.max_claimed' permission"});
    public static final StringListValue CLAIM_DIMENSION_BLACKLIST = (StringListValue)CLAIMING.addStringList("claim_dimension_blacklist", Collections.emptyList()).comment(new String[]{"Dimension ID's where chunks may not be claimed. Add \"minecraft:the_end\" to this list if you want to disable chunk claiming in The End, or \"othermod:*\" to disable chunk claiming in *all* dimensions added by \"othermod\""});
    public static final StringListValue CLAIM_DIMENSION_WHITELIST = (StringListValue)CLAIMING.addStringList("claim_dimension_whitelist", Collections.emptyList()).comment(new String[]{"Dimension ID's where chunks may be claimed. If non-empty, chunks may be claimed *only* in these dimensions (and the dimension is not in \"claim_dimension_blacklist\"). Same syntax as for \"claim_dimension_blacklist\"."});
    public static final DoubleValue MAX_IDLE_DAYS_BEFORE_UNCLAIM = (DoubleValue)CLAIMING.addDouble("max_idle_days_before_unclaim", 0.0, 0.0, 3650.0).comment(new String[]{"Maximum time (in real-world days) where if no player in a team logs in, the team automatically loses their claims.", "Prevents chunks being claimed indefinitely by teams who no longer play.", "Default of 0 means no automatic loss of claims."});
    public static final IntValue HARD_TEAM_CLAIM_LIMIT = (IntValue)CLAIMING.addInt("hard_team_claim_limit", 0, 0, Integer.MAX_VALUE).comment(new String[]{"Hard limit for the number of chunks a team can claim, regardless of how many members. Default of 0 means no hard limit."});
    public static final EnumValue<PartyLimitMode> PARTY_LIMIT_MODE = (EnumValue)CLAIMING.addEnum("party_limit_mode", PartyLimitMode.NAME_MAP).comment(new String[]{"Method by which party claim & force-load limits are calculated.", "LARGEST: use the limits of the member with the largest limits", "SUM: add up all the members' limits", "OWNER: use the party owner's limits only", "AVERAGE: use the average of all members' limits."});
    public static final SNBTConfig FORCE_LOADING = CONFIG.addGroup("force_loading");
    public static final EnumValue<ForceLoadMode> FORCE_LOAD_MODE = (EnumValue)FORCE_LOADING.addEnum("force_load_mode", ForceLoadMode.NAME_MAP).comment(new String[]{"Control how force-loaded chunks work.", "NEVER: only allow chunk force-loading if the owning team has at least one online player.", "ALWAYS: always allow force-loading, even if no players are online.", "DEFAULT: allow force-loading IF the team has at least one player with the 'ftbchunks.chunk_load_offline' FTB Ranks permission."});
    public static final IntValue MAX_FORCE_LOADED_CHUNKS = (IntValue)FORCE_LOADING.addInt("max_force_loaded_chunks", 25).comment(new String[]{"Max force loaded chunks.", "You can override this with FTB Ranks 'ftbchunks.max_force_loaded' permission"});
    public static final DoubleValue MAX_IDLE_DAYS_BEFORE_UNFORCE = (DoubleValue)FORCE_LOADING.addDouble("max_idle_days_before_unforce", 0.0, 0.0, 3650.0).comment(new String[]{"Maximum time (in real-world days) where if no player in a team logs in, any forceloaded chunks owned by the team are no longer forceloaded.", "Prevents chunks being forceloaded indefinitely by teams who no longer play.", "Default of 0 means no automatic loss of forceloading."});
    public static final IntValue HARD_TEAM_FORCE_LIMIT = (IntValue)FORCE_LOADING.addInt("hard_team_force_limit", 0, 0, Integer.MAX_VALUE).comment(new String[]{"Hard limit for the number of chunks a team can force-load, regardless of how many members. Default of 0 means no hard limit."});
    public static final SNBTConfig WAYPOINT_SHARING = CONFIG.addGroup("waypoint_sharing");
    public static final BooleanValue WAYPOINT_SHARING_SERVER = (BooleanValue)WAYPOINT_SHARING.addBoolean("waypoint_sharing_server", true).comment(new String[]{"Allow players to share waypoints with the entire server."});
    public static final BooleanValue WAYPOINT_SHARING_PARTY = (BooleanValue)WAYPOINT_SHARING.addBoolean("waypoint_sharing_party", true).comment(new String[]{"Allow players to share waypoints with their party."});
    public static final BooleanValue WAYPOINT_SHARING_PLAYERS = (BooleanValue)WAYPOINT_SHARING.addBoolean("waypoint_sharing_players", true).comment(new String[]{"Allow players to share waypoints with other players."});
    public static final SNBTConfig TEAM_PROP_DEFAULTS = CONFIG.addGroup("team_prop_defaults");
    public static final BooleanValue DEF_ALLOW_FAKE_PLAYERS = (BooleanValue)TEAM_PROP_DEFAULTS.addBoolean("def_fake_players", false).comment(new String[]{"Default allow-fake-player setting for team properties"});
    public static final BooleanValue DEF_ALLOW_FAKE_PLAYER_IDS = (BooleanValue)TEAM_PROP_DEFAULTS.addBoolean("def_fake_player_ids", true).comment(new String[]{"Default allow fake player IDs which are the same as real permitted players"});
    public static final StringListValue DEF_ALLOW_NAMED_FAKE_PLAYERS = (StringListValue)TEAM_PROP_DEFAULTS.addStringList("def_named_fake_players", Collections.emptyList()).comment(new String[]{"Default named fake players who should be allowed by default"});
    public static final EnumValue<PrivacyMode> DEF_ENTITY_INTERACT = (EnumValue)TEAM_PROP_DEFAULTS.addEnum("def_entity_interact", PrivacyMode.NAME_MAP, (Object)PrivacyMode.ALLIES).comment(new String[]{"Default mode for entity interaction in claimed chunks"});
    public static final EnumValue<PrivacyMode> DEF_BLOCK_INTERACT = (EnumValue)TEAM_PROP_DEFAULTS.addEnum("def_block_interact", PrivacyMode.NAME_MAP, (Object)PrivacyMode.ALLIES).comment(new String[]{"Default mode for block interaction (right-click) in claimed chunks (NeoForge only)"}).enabled(Platform::isForgeLike);
    public static final EnumValue<PrivacyMode> DEF_BLOCK_EDIT = (EnumValue)TEAM_PROP_DEFAULTS.addEnum("def_block_edit", PrivacyMode.NAME_MAP, (Object)PrivacyMode.ALLIES).comment(new String[]{"Default mode for block breaking and placing in claimed chunks (NeoForge only)"}).enabled(Platform::isForgeLike);
    public static final EnumValue<PrivacyMode> DEF_BLOCK_EDIT_INTERACT = (EnumValue)TEAM_PROP_DEFAULTS.addEnum("def_block_edit_interact", PrivacyMode.NAME_MAP, (Object)PrivacyMode.ALLIES).comment(new String[]{"Default mode for block interaction, breaking and placing in claimed chunks (Fabric only)"}).enabled(Platform::isFabric);
    public static final EnumValue<PrivacyMode> DEF_NONLIVING_ENTITY_ATTACK = (EnumValue)TEAM_PROP_DEFAULTS.addEnum("def_entity_attack", PrivacyMode.NAME_MAP, (Object)PrivacyMode.ALLIES).comment(new String[]{"Default mode for left-clicking non-living entities (armor stands, item frames...) in claimed chunks"});
    public static final BooleanValue DEF_ALLOW_EXPLOSIONS = (BooleanValue)TEAM_PROP_DEFAULTS.addBoolean("def_allow_explosions", false).comment(new String[]{"Default explosion protection for claimed chunks"});
    public static final BooleanValue DEF_MOB_GRIEFING = (BooleanValue)TEAM_PROP_DEFAULTS.addBoolean("def_mob_griefing", false).comment(new String[]{"Default mob griefing protection for claimed chunks"});
    public static final EnumValue<PrivacyMode> DEF_CLAIM_VISIBILITY = (EnumValue)TEAM_PROP_DEFAULTS.addEnum("def_claim_visibility", PrivacyMode.NAME_MAP, (Object)PrivacyMode.PUBLIC).comment(new String[]{"Default claim visibility for claimed chunks"});
    public static final EnumValue<PrivacyMode> DEF_PLAYER_VISIBILITY = (EnumValue)TEAM_PROP_DEFAULTS.addEnum("def_player_visibility", PrivacyMode.NAME_MAP, (Object)PrivacyMode.ALLIES).comment(new String[]{"Default long-range player visibility on map"});
    public static final BooleanValue DEF_PVP = (BooleanValue)TEAM_PROP_DEFAULTS.addBoolean("def_pvp", true).comment(new String[]{"Default PvP setting in claimed chunks"});
    public static final SNBTConfig CUSTOM_BEHAVIOUR = (SNBTConfig)CONFIG.addGroup("custom_behaviour").excluded();
    public static final BooleanValue OVERRIDE_MIN_Y_LEVEL = (BooleanValue)CUSTOM_BEHAVIOUR.addBoolean("use_custom_min_y_level", false).excluded().comment(new String[]{"Override minimum Y level used when rendering map"});
    public static final IntValue OVERRIDE_MIN_Y_LEVEL_VALUE = (IntValue)CUSTOM_BEHAVIOUR.addInt("custom_min_y_level", Short.MIN_VALUE, Short.MIN_VALUE, Short.MAX_VALUE).excluded().comment(new String[]{"Custom minimum Y level to scan when rendering map, used if use_custom_min_y_level is true"});
    public static final ChunkPosCustomYSetValue CHUNKS_WITH_CUSTOM_Y = (ChunkPosCustomYSetValue)((ChunkPosCustomYSetValue)CUSTOM_BEHAVIOUR.add((BaseValue)new ChunkPosCustomYSetValue(CUSTOM_BEHAVIOUR, "chunks_with_custom_y", Collections.emptySet()))).excluded().comment(new String[]{"Set of chunks with custom minimum Y levels, used if use_custom_min_y_level is true"});
    public static final SNBTConfig DEV = CONFIG.addGroup("dev");
    public static final BooleanValue DEV_COMMANDS = (BooleanValue)DEV.addBoolean("commands", false).excluded().comment(new String[]{"Enable dev commands"});

    public static int getMaxClaimedChunks(ChunkTeamData playerData, ServerPlayer player) {
        if (player != null) {
            return PermissionsHelper.getMaxClaimedChunks(player, (Integer)MAX_CLAIMED_CHUNKS.get()) + playerData.getExtraClaimChunks();
        }
        return (Integer)MAX_CLAIMED_CHUNKS.get() + playerData.getExtraClaimChunks();
    }

    public static int getMaxForceLoadedChunks(ChunkTeamData playerData, ServerPlayer player) {
        if (player != null) {
            return PermissionsHelper.getMaxForceLoadedChunks(player, (Integer)MAX_FORCE_LOADED_CHUNKS.get()) + playerData.getExtraForceLoadChunks();
        }
        return (Integer)MAX_FORCE_LOADED_CHUNKS.get() + playerData.getExtraForceLoadChunks();
    }

    public static boolean canPlayerOfflineForceload(ServerPlayer player) {
        return player != null && PermissionsHelper.getChunkLoadOffline(player, false);
    }

    public static boolean noWilderness(ServerPlayer player) {
        if (player != null) {
            return DimensionFilter.isNoWildernessDimension((ResourceKey<Level>)player.level().dimension()) || PermissionsHelper.getNoWilderness(player, (Boolean)NO_WILDERNESS.get());
        }
        return (Boolean)NO_WILDERNESS.get();
    }

    public static boolean playerHasMapStage(Player player) {
        return (Boolean)REQUIRE_GAME_STAGE.get() == false || StageHelper.getInstance().getProvider().has(player, "ftbchunks_mapping");
    }

    public static boolean shouldShowMinimap(Player player) {
        return (Boolean)FORCE_DISABLE_MINIMAP.get() == false && FTBChunksWorldConfig.playerHasMapStage(player);
    }

    public static void onConfigChanged(boolean isServerConfig) {
        if (isServerConfig) {
            DimensionFilter.clearMatcherCaches();
            FTBTeamsAPI.api().getManager().getTeams().forEach(team -> ClaimedChunkManagerImpl.getInstance().getOrCreateData((Team)team).updateLimits());
        }
    }
}

