/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.content.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.common.CommonHooks;

public abstract class DoubleBushBlock
extends DoublePlantBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = BlockStateProperties.AGE_4;
    public static final int MAX_AGE = 4;

    public DoubleBushBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
        super.createBlockStateDefinition(builder);
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 4;
    }

    public boolean isBonemealSuccess(Level level, RandomSource rand, BlockPos pos, BlockState state) {
        return true;
    }

    public abstract int getDoubleBlockStart();

    public boolean isRandomlyTicking(BlockState state) {
        return state.getValue((Property)HALF) == DoubleBlockHalf.LOWER && (Integer)state.getValue((Property)AGE) < 4;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        int i = (Integer)state.getValue((Property)AGE);
        if (i < 4 && level.getRawBrightness(pos.above(), 0) >= 9 && CommonHooks.canCropGrow((Level)level, (BlockPos)pos, (BlockState)state, (rand.nextInt(5) == 0 ? 1 : 0) != 0)) {
            this.setGrowth((Level)level, pos, i + 1, 2);
            CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public void performBonemeal(ServerLevel level, RandomSource rand, BlockPos pos, BlockState state) {
        if (state.getValue((Property)HALF) == DoubleBlockHalf.UPPER) {
            BlockState lower = level.getBlockState(pos.below());
            if (lower.is((Block)this) && lower.getValue((Property)HALF) == DoubleBlockHalf.LOWER) {
                pos = pos.below();
                state = lower;
            } else {
                return;
            }
        }
        int i = Math.min(4, (Integer)state.getValue((Property)AGE) + 1);
        this.setGrowth((Level)level, pos, i, 2);
    }

    public void setGrowth(Level level, BlockPos pos, int age, int flag) {
        BlockState above;
        if (age >= this.getDoubleBlockStart()) {
            boolean fail = level.isOutsideBuildHeight(pos.above());
            if (!fail) {
                above = level.getBlockState(pos.above());
                boolean bl = fail = !above.is((Block)this) && !above.canBeReplaced();
            }
            if (fail && (age = this.getDoubleBlockStart() - 1) < 0) {
                return;
            }
        }
        BlockState state = (BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(age));
        level.setBlock(pos, state, flag);
        if (age >= this.getDoubleBlockStart()) {
            level.setBlock(pos.above(), (BlockState)state.setValue((Property)HALF, (Comparable)DoubleBlockHalf.UPPER), flag);
        } else {
            above = level.getBlockState(pos.above());
            if (above.is((Block)this) && above.getValue((Property)HALF) == DoubleBlockHalf.UPPER) {
                level.removeBlock(pos.above(), false);
            }
        }
        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)state));
    }

    public BlockState updateShape(BlockState state, Direction dir, BlockState sourceState, LevelAccessor level, BlockPos pos, BlockPos sourcePos) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.getValue((Property)HALF);
        if (half == DoubleBlockHalf.LOWER && dir == Direction.DOWN && !state.canSurvive((LevelReader)level, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (dir.getAxis() == Direction.Axis.Y) {
            boolean illegal;
            boolean bl = illegal = !sourceState.is((Block)this) || sourceState.getValue((Property)HALF) == half;
            if (half == DoubleBlockHalf.UPPER && dir == Direction.DOWN && illegal) {
                return Blocks.AIR.defaultBlockState();
            }
            if (half == DoubleBlockHalf.LOWER && dir == Direction.UP && illegal && (Integer)state.getValue((Property)AGE) >= this.getDoubleBlockStart()) {
                return Blocks.AIR.defaultBlockState();
            }
        }
        return super.updateShape(state, dir, sourceState, level, pos, sourcePos);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockPos blockpos = ctx.getClickedPos();
        Level level = ctx.getLevel();
        return blockpos.getY() < level.getMaxBuildHeight() - 1 && level.getBlockState(blockpos.above()).canBeReplaced(ctx) ? super.getStateForPlacement(ctx) : null;
    }

    public void setPlacedBy(Level pLevel, BlockPos pPos, BlockState state, LivingEntity pPlacer, ItemStack pStack) {
        if ((Integer)state.getValue((Property)AGE) >= this.getDoubleBlockStart()) {
            super.setPlacedBy(pLevel, pPos, state, pPlacer, pStack);
        }
    }
}

