/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.content.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.common.CommonHooks;

public class BaseBushBlock
extends BushBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = BlockStateProperties.AGE_4;
    public static final int MAX_AGE = 4;

    public BaseBushBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 4;
    }

    @Deprecated
    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        int i = (Integer)state.getValue((Property)AGE);
        if (i < 4 && level.getRawBrightness(pos.above(), 0) >= 9 && CommonHooks.canCropGrow((Level)level, (BlockPos)pos, (BlockState)state, (rand.nextInt(5) == 0 ? 1 : 0) != 0)) {
            BlockState blockstate = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(i + 1));
            level.setBlock(pos, blockstate, 2);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)blockstate));
            CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
        super.createBlockStateDefinition(builder);
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 4;
    }

    public boolean isBonemealSuccess(Level level, RandomSource rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource rand, BlockPos pos, BlockState state) {
        int i = Math.min(4, (Integer)state.getValue((Property)AGE) + 1);
        level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(i)), 2);
    }

    protected MapCodec<? extends BushBlock> codec() {
        return null;
    }
}

