/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fruitsdelight.compat.sereneseasons;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.tterrag.registrate.providers.RegistrateItemTagsProvider;
import com.tterrag.registrate.providers.RegistrateTagsProvider;
import dev.xkmc.fruitsdelight.compat.sereneseasons.Seasons;
import dev.xkmc.fruitsdelight.init.plants.FDBushes;
import dev.xkmc.fruitsdelight.init.plants.FDMelons;
import dev.xkmc.fruitsdelight.init.plants.FDPineapple;
import dev.xkmc.fruitsdelight.init.plants.FDTrees;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;

public class SeasonCompat {
    private static final Multimap<Seasons, FDTrees> TREE = new ImmutableMultimap.Builder().putAll((Object)Seasons.SPRING, (Object[])new FDTrees[]{FDTrees.PEAR, FDTrees.PEACH}).putAll((Object)Seasons.SUMMER, (Object[])new FDTrees[]{FDTrees.LYCHEE, FDTrees.MANGO, FDTrees.MANGOSTEEN, FDTrees.BAYBERRY, FDTrees.DURIAN}).putAll((Object)Seasons.AUTUMN, (Object[])new FDTrees[]{FDTrees.ORANGE, FDTrees.APPLE, FDTrees.FIG}).putAll((Object)Seasons.WINTER, (Object[])new FDTrees[]{FDTrees.HAWBERRY, FDTrees.PERSIMMON, FDTrees.KIWI}).build();
    private static final Multimap<Seasons, FDBushes> BUSH = new ImmutableMultimap.Builder().putAll((Object)Seasons.SPRING, (Object[])new FDBushes[]{FDBushes.BLUEBERRY}).putAll((Object)Seasons.SUMMER, (Object[])new FDBushes[]{FDBushes.LEMON}).putAll((Object)Seasons.AUTUMN, (Object[])new FDBushes[]{FDBushes.CRANBERRY}).build();
    private static final Multimap<Seasons, FDMelons> MELON = new ImmutableMultimap.Builder().putAll((Object)Seasons.SUMMER, (Object[])new FDMelons[]{FDMelons.HAMIMELON}).build();
    private static final Multimap<Seasons, FDPineapple> PINEAPPLE = new ImmutableMultimap.Builder().putAll((Object)Seasons.SUMMER, (Object[])new FDPineapple[]{FDPineapple.PINEAPPLE}).build();

    public static void genItem(RegistrateItemTagsProvider pvd) {
        for (Seasons s : Seasons.values()) {
            IntrinsicHolderTagsProvider.IntrinsicTagAppender item = pvd.addTag(s.item);
            for (Enum t : TREE.get((Object)s)) {
                item.add((Object)((FDTrees)t).getSapling().asItem());
            }
            for (Enum t : BUSH.get((Object)s)) {
                item.add((Object)((FDBushes)t).getSeed());
            }
            for (Enum t : MELON.get((Object)s)) {
                item.add((Object)((FDMelons)t).getSeed());
            }
            for (Enum t : PINEAPPLE.get((Object)s)) {
                item.add((Object)((FDPineapple)t).getSapling());
            }
        }
    }

    public static void genBlock(RegistrateTagsProvider.IntrinsicImpl<Block> pvd) {
        for (Seasons s : Seasons.values()) {
            IntrinsicHolderTagsProvider.IntrinsicTagAppender intrinsicTagAppender = pvd.addTag(s.block);
            for (Enum t : TREE.get((Object)s)) {
                intrinsicTagAppender.add((Object)((FDTrees)t).getSapling());
                intrinsicTagAppender.add((Object)((FDTrees)t).getLeaves());
            }
            for (Enum t : BUSH.get((Object)s)) {
                intrinsicTagAppender.add((Object)((FDBushes)t).getBush());
            }
            for (Enum t : MELON.get((Object)s)) {
                intrinsicTagAppender.add((Object)((FDMelons)t).getStem());
            }
            for (Enum t : PINEAPPLE.get((Object)s)) {
                intrinsicTagAppender.add((Object)((FDPineapple)t).getPlant());
            }
        }
        IntrinsicHolderTagsProvider.IntrinsicTagAppender tag = pvd.addTag(BlockTags.create((ResourceLocation)ResourceLocation.parse((String)"sereneseasons:unbreakable_infertile_crops")));
        for (FDTrees fDTrees : FDTrees.values()) {
            tag.add((Object)fDTrees.getLeaves());
            tag.add((Object)fDTrees.getSapling());
        }
        for (Enum enum_ : FDBushes.values()) {
            tag.add((Object)((FDBushes)enum_).getBush());
        }
    }
}

