/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.api.client.screen.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.framework.api.client.screen.widget.element.Icon;
import com.mrcrayfish.framework.api.client.screen.widget.element.Label;
import com.mrcrayfish.framework.api.client.screen.widget.element.Sound;
import com.mrcrayfish.framework.api.client.screen.widget.input.Action;
import com.mrcrayfish.framework.api.client.screen.widget.input.MouseInput;
import java.time.Duration;
import java.util.EnumMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.Nullable;

public final class FrameworkButton
extends AbstractButton {
    public static final WidgetSprites DEFAULT_SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"widget/button"), ResourceLocation.withDefaultNamespace((String)"widget/button_disabled"), ResourceLocation.withDefaultNamespace((String)"widget/button_highlighted"));
    public static final int DEFAULT_TOOLTIP_DELAY = 350;
    public static final ContentRenderer<FrameworkButton> DEFAULT_CONTENT_RENDERER = new DefaultContentRenderer();
    private final Label label;
    @Nullable
    private final Icon icon;
    private final int spacing;
    @Nullable
    private final EnumMap<MouseInput, Action<FrameworkButton>> actions;
    @Nullable
    private final Supplier<WidgetSprites> texture;
    @Nullable
    private final Supplier<Boolean> activeSupplier;
    @Nullable
    private final Function<FrameworkButton, Tooltip> tooltip;
    private final int tooltipOptions;
    @Nullable
    private Tooltip currentTooltip;
    private boolean shiftWasDown;
    private boolean mouseIsHovering;
    @Nullable
    private final ContentRenderer<FrameworkButton> contentRenderer;

    private FrameworkButton(int x, int y, int width, int height, Label label, Function<FrameworkButton, Icon> icon, int spacing, @Nullable EnumMap<MouseInput, Action<FrameworkButton>> actions, @Nullable Supplier<WidgetSprites> texture, @Nullable Supplier<Boolean> activeSupplier, @Nullable Function<FrameworkButton, Tooltip> tooltip, int tooltipDelay, int tooltipOptions, @Nullable ContentRenderer<FrameworkButton> contentRenderer) {
        super(x, y, width, height, CommonComponents.EMPTY);
        this.label = label;
        this.icon = icon.apply(this);
        this.spacing = spacing;
        this.actions = actions;
        this.texture = texture;
        this.activeSupplier = activeSupplier;
        this.tooltip = tooltip;
        this.tooltipOptions = tooltipOptions;
        this.contentRenderer = contentRenderer;
        this.updateActiveState();
        this.rebuildTooltip();
        this.setTooltipDelay(Duration.ofMillis(tooltipDelay));
    }

    public Component getMessage() {
        return this.label.text();
    }

    public Label getLabel() {
        return this.label;
    }

    @Nullable
    public Icon getIcon() {
        return this.icon;
    }

    @Nullable
    public WidgetSprites getTexture() {
        return this.texture != null ? this.texture.get() : null;
    }

    public int getSpacing() {
        return this.spacing;
    }

    private void onAction(int button) {
        Action<FrameworkButton> action;
        Action<FrameworkButton> action2 = action = this.actions != null ? this.actions.get((Object)MouseInput.fromButton(button)) : null;
        if (action != null) {
            action.handler().accept(this);
            Sound sound = action.sound();
            if (sound != null) {
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)sound.value(), (float)sound.pitch(), (float)sound.volume()));
            }
        } else {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        }
        this.rebuildTooltip();
    }

    private void updateActiveState() {
        if (this.activeSupplier != null) {
            this.active = this.activeSupplier.get();
        }
    }

    public void rebuildTooltip() {
        if (this.tooltip != null) {
            this.currentTooltip = this.tooltip.apply(this);
        }
    }

    private void updateTooltip() {
        if ((this.tooltipOptions & 2) != 0 && !this.shiftWasDown && Screen.hasShiftDown() && this.isHovered()) {
            this.rebuildTooltip();
            this.shiftWasDown = true;
        }
        if (this.shiftWasDown && !Screen.hasShiftDown()) {
            this.rebuildTooltip();
            this.shiftWasDown = false;
        }
        if ((this.tooltipOptions & 4) != 0) {
            if (this.isHovered()) {
                if (!this.mouseIsHovering) {
                    this.rebuildTooltip();
                    this.mouseIsHovering = true;
                }
            } else {
                this.mouseIsHovering = false;
            }
        }
        if (!this.active && (this.tooltipOptions & 1) != 0) {
            this.setTooltip(null);
        } else {
            this.setTooltip(this.currentTooltip);
        }
    }

    public void onPress() {
        this.onAction(0);
    }

    public void playDownSound(SoundManager manager) {
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.updateActiveState();
        this.updateTooltip();
        if (this.contentRenderer != null) {
            this.contentRenderer.draw(this, graphics, mouseX, mouseY, partialTick);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput output) {
        this.defaultButtonNarrationText(output);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.active && this.visible && this.isValidClickButton(button) && this.clicked(mouseX, mouseY)) {
            this.onAction(button);
            return true;
        }
        return false;
    }

    protected boolean isValidClickButton(int button) {
        return button == 0 || this.actions != null && this.actions.containsKey(button);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static interface ContentRenderer<T> {
        public void draw(T var1, GuiGraphics var2, int var3, int var4, float var5);
    }

    public static final class Builder {
        private int x;
        private int y;
        private int width = 20;
        private int height = 20;
        private Label label = Label.EMPTY;
        private Function<FrameworkButton, Icon> icon = btn -> null;
        private int spacing = 4;
        @Nullable
        private EnumMap<MouseInput, Action<FrameworkButton>> actions;
        @Nullable
        private Supplier<WidgetSprites> texture = () -> DEFAULT_SPRITES;
        @Nullable
        private Supplier<Boolean> active;
        @Nullable
        private Function<FrameworkButton, Tooltip> tooltip;
        private int tooltipDelay = 350;
        private int tooltipOptions;
        @Nullable
        private ContentRenderer<FrameworkButton> contentRenderer = DEFAULT_CONTENT_RENDERER;

        private Builder() {
        }

        public FrameworkButton build() {
            return new FrameworkButton(this.x, this.y, this.width, this.height, this.label, this.icon, this.spacing, this.actions, this.texture, this.active, this.tooltip, this.tooltipDelay, this.tooltipOptions, this.contentRenderer);
        }

        private EnumMap<MouseInput, Action<FrameworkButton>> actions() {
            if (this.actions == null) {
                this.actions = new EnumMap(MouseInput.class);
            }
            return this.actions;
        }

        public Builder setX(int x) {
            this.x = x;
            return this;
        }

        public Builder setY(int y) {
            this.y = y;
            return this;
        }

        public Builder setPosition(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Builder setWidth(int width) {
            this.width = width;
            return this;
        }

        public Builder setHeight(int height) {
            this.height = height;
            return this;
        }

        public Builder setSize(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder setLabel(Component text) {
            this.label = Label.constant(text);
            return this;
        }

        public Builder setLabel(Supplier<Component> supplier) {
            this.label = Label.dynamic(supplier);
            return this;
        }

        public Builder setLabel(Label label) {
            this.label = label;
            return this;
        }

        public Builder setIcon(ResourceLocation sprite, int width, int height) {
            this.icon = btn -> Icon.sprite(sprite, width, height);
            return this;
        }

        public Builder setIcon(Supplier<ResourceLocation> sprite, int width, int height) {
            this.icon = btn -> Icon.sprite(sprite, width, height);
            return this;
        }

        public Builder setIcon(Function<FrameworkButton, Supplier<ResourceLocation>> sprite, int width, int height) {
            this.icon = btn -> Icon.sprite((Supplier)sprite.apply((FrameworkButton)((Object)btn)), width, height);
            return this;
        }

        public Builder setIcon(Icon icon) {
            this.icon = btn -> icon;
            return this;
        }

        public Builder setIcon(Function<FrameworkButton, Icon> icon) {
            this.icon = icon;
            return this;
        }

        public Builder setSpacing(int spacing) {
            this.spacing = spacing;
            return this;
        }

        public Builder setAction(Consumer<FrameworkButton> action) {
            this.actions().put(MouseInput.LEFT_CLICK, Action.create(action));
            return this;
        }

        public Builder setPrimaryAction(Consumer<FrameworkButton> action) {
            this.actions().put(MouseInput.LEFT_CLICK, Action.create(action));
            return this;
        }

        public Builder setPrimaryAction(Action<FrameworkButton> action) {
            this.actions().put(MouseInput.LEFT_CLICK, action);
            return this;
        }

        public Builder setSecondaryAction(Consumer<FrameworkButton> action) {
            this.actions().put(MouseInput.RIGHT_CLICK, Action.create(action));
            return this;
        }

        public Builder setSecondaryAction(Action<FrameworkButton> action) {
            this.actions().put(MouseInput.RIGHT_CLICK, action);
            return this;
        }

        public Builder setTertiaryAction(Consumer<FrameworkButton> action) {
            this.actions().put(MouseInput.MIDDLE_CLICK, Action.create(action));
            return this;
        }

        public Builder setTertiaryAction(Action<FrameworkButton> action) {
            this.actions().put(MouseInput.MIDDLE_CLICK, action);
            return this;
        }

        public Builder setAction(MouseInput input, Action<FrameworkButton> action) {
            this.actions().put(input, action);
            return this;
        }

        public Builder setTexture(WidgetSprites texture) {
            this.texture = () -> texture;
            return this;
        }

        public Builder setTexture(Supplier<WidgetSprites> texture) {
            this.texture = texture;
            return this;
        }

        public Builder noTexture() {
            this.texture = null;
            return this;
        }

        public Builder setDependent(Supplier<Boolean> active) {
            this.active = active;
            return this;
        }

        public Builder setTooltip(Tooltip tooltip) {
            this.tooltip = btn -> tooltip;
            return this;
        }

        public Builder setTooltip(Function<FrameworkButton, Tooltip> tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public Builder setTooltipDelay(int delay) {
            this.tooltipDelay = delay;
            return this;
        }

        public Builder setTooltipOptions(int options) {
            this.tooltipOptions = options;
            return this;
        }

        public Builder setContentRenderer(@Nullable ContentRenderer<FrameworkButton> renderer) {
            this.contentRenderer = renderer;
            return this;
        }
    }

    public static class DefaultContentRenderer
    implements ContentRenderer<FrameworkButton> {
        @Override
        public void draw(FrameworkButton button, GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            Label label;
            int contentWidth;
            int contentHeight;
            WidgetSprites texture = button.getTexture();
            if (texture != null) {
                RenderSystem.enableBlend();
                RenderSystem.enableDepthTest();
                graphics.setColor(1.0f, 1.0f, 1.0f, button.active ? 1.0f : 0.5f);
                graphics.blitSprite(texture.get(button.active, button.isHoveredOrFocused() && button.active), button.getX(), button.getY(), button.getWidth(), button.getHeight());
                graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
                RenderSystem.disableBlend();
            }
            int n = contentHeight = (contentWidth = (label = button.getLabel()).width()) > 0 ? label.height() + 1 : 0;
            if (button.icon != null) {
                if (contentWidth > 0) {
                    contentWidth += button.spacing;
                }
                contentWidth += button.icon.width();
                contentHeight = Math.max(contentHeight, button.icon.height());
            }
            int contentLeft = button.getX() + (button.getWidth() - contentWidth) / 2;
            int contentTop = button.getY() + (button.getHeight() - contentHeight) / 2;
            int textX = contentLeft + (button.icon != null ? button.spacing + button.icon.width() : 0);
            int textY = contentTop + (contentHeight - label.height()) / 2 + 1;
            int textColour = button.active ? -1 : -10066330;
            boolean textShadow = button.active;
            label.draw(graphics, textX, textY, textColour, textShadow);
            if (button.icon != null) {
                int iconX = contentLeft;
                int iconY = contentTop + (contentHeight - button.icon.height()) / 2;
                RenderSystem.enableBlend();
                graphics.setColor(1.0f, 1.0f, 1.0f, button.active ? 1.0f : 0.5f);
                button.icon.draw(graphics, iconX, iconY, partialTick);
                graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
                RenderSystem.disableBlend();
            }
        }
    }

    public static class ToggleContentRenderer
    implements ContentRenderer<FrameworkButton> {
        private static final int TOGGLE_SIZE = 6;
        private static final WidgetSprites TOGGLE_SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"framework", (String)"widget/button/toggle_on"), ResourceLocation.fromNamespaceAndPath((String)"framework", (String)"widget/button/toggle_off"), ResourceLocation.fromNamespaceAndPath((String)"framework", (String)"widget/button/toggle_on"));
        private final Supplier<Boolean> state;

        public ToggleContentRenderer(Supplier<Boolean> state) {
            this.state = state;
        }

        @Override
        public void draw(FrameworkButton button, GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            WidgetSprites texture = button.getTexture();
            if (texture != null) {
                RenderSystem.enableBlend();
                RenderSystem.enableDepthTest();
                graphics.setColor(1.0f, 1.0f, 1.0f, button.active ? 1.0f : 0.5f);
                graphics.blitSprite(texture.get(button.active, button.isHoveredOrFocused() && button.active), button.getX(), button.getY(), button.getWidth(), button.getHeight());
                graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
                RenderSystem.disableBlend();
            }
            Label label = button.getLabel();
            int contentLeft = button.getX() + 6;
            int textX = contentLeft + (button.icon != null ? button.spacing + button.icon.width() : 0);
            int textY = button.getY() + (button.getHeight() - label.height()) / 2 + 1;
            int textColour = button.active ? -1 : -10066330;
            boolean textShadow = button.active;
            label.draw(graphics, textX, textY, textColour, textShadow);
            if (button.icon != null) {
                int iconX = contentLeft;
                int iconY = button.getY() + (button.getHeight() - button.icon.height()) / 2;
                RenderSystem.enableBlend();
                graphics.setColor(1.0f, 1.0f, 1.0f, button.active ? 1.0f : 0.5f);
                button.icon.draw(graphics, iconX, iconY, partialTick);
                graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
                RenderSystem.disableBlend();
            }
            int yOffset = (button.getHeight() - 6) / 2;
            int stateIconY = button.getY() + yOffset;
            int stateIconX = button.getX() + button.getWidth() - 6 - yOffset;
            RenderSystem.enableBlend();
            graphics.setColor(1.0f, 1.0f, 1.0f, button.active ? 1.0f : 0.5f);
            graphics.blitSprite(TOGGLE_SPRITES.get(this.state.get().booleanValue(), button.isHovered()), stateIconX, stateIconY, 6, 6);
            graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            RenderSystem.disableBlend();
        }
    }
}

