/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.api.client;

import com.mrcrayfish.framework.api.serialize.DataObject;
import com.mrcrayfish.framework.client.JsonDataManager;
import com.mrcrayfish.framework.client.StandaloneModelManager;
import com.mrcrayfish.framework.client.model.OpenModelHelper;
import com.mrcrayfish.framework.client.resources.IDataLoader;
import com.mrcrayfish.framework.platform.ClientServices;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class FrameworkClientAPI {
    public static synchronized void registerDataLoader(IDataLoader<?> loader) {
        JsonDataManager.getInstance().addLoader(loader);
    }

    public static DataObject getOpenModelData(ModelResourceLocation location) {
        return OpenModelHelper.getData(location);
    }

    public static DataObject getOpenModelData(BlockState state) {
        return OpenModelHelper.getData(state);
    }

    public static DataObject getOpenModelData(Item item) {
        return OpenModelHelper.getData(item);
    }

    public static DataObject getOpenModelData(ItemStack stack, @Nullable Level level, @Nullable LivingEntity entity, int seed) {
        return OpenModelHelper.getData(stack, level, entity, seed);
    }

    public static BakedModel getBakedModel(ModelResourceLocation location) {
        return ClientServices.CLIENT.getBakedModel(location);
    }

    public static Supplier<BakedModel> registerStandaloneModel(ModelResourceLocation location) {
        StandaloneModelManager.getInstance().register(location);
        return () -> {
            if (Minecraft.getInstance().getModelManager().getMissingModel() == null) {
                throw new IllegalStateException("Models have not loaded yet");
            }
            return ClientServices.CLIENT.getBakedModel(location);
        };
    }

    public static ModelResourceLocation createModelResourceLocation(String namespace, String path) {
        return FrameworkClientAPI.createModelResourceLocation(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path));
    }

    public static ModelResourceLocation createModelResourceLocation(ResourceLocation location) {
        String variant = ClientServices.CLIENT.getStandaloneModelVariant();
        return new ModelResourceLocation(location, variant);
    }
}

