/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.findme.network;

import com.buuz135.findme.FindMeMod;
import com.buuz135.findme.client.ClientTickHandler;
import com.buuz135.findme.client.ParticlePosition;
import com.buuz135.findme.tracking.TrackingList;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class PositionResponseMessage
implements CustomPacketPayload {
    public static CustomPacketPayload.Type<PositionResponseMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"findme", (String)"position_response"));
    public static StreamCodec<? super RegistryFriendlyByteBuf, PositionResponseMessage> CODEC = new StreamCodec<RegistryFriendlyByteBuf, PositionResponseMessage>(){

        public PositionResponseMessage decode(RegistryFriendlyByteBuf object) {
            ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
            for (int amount = object.readInt(); amount > 0; --amount) {
                positions.add(object.readBlockPos());
            }
            return new PositionResponseMessage(positions);
        }

        public void encode(RegistryFriendlyByteBuf registryFriendlyByteBuf, PositionResponseMessage positionRequestMessage) {
            registryFriendlyByteBuf.writeInt(positionRequestMessage.positions.size());
            for (BlockPos position : positionRequestMessage.positions) {
                registryFriendlyByteBuf.writeBlockPos(position);
            }
        }
    };
    private List<BlockPos> positions;

    public PositionResponseMessage(List<BlockPos> positions) {
        this.positions = positions;
    }

    public PositionResponseMessage() {
    }

    public void handle(NetworkManager.PacketContext context) {
        Minecraft.getInstance().execute(() -> {
            if (this.positions.size() > 0) {
                Minecraft.getInstance().player.closeContainer();
                Minecraft.getInstance().player.playSound(SoundEvents.EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                if (FindMeMod.CONFIG.CLIENT.CONTAINER_TRACKING) {
                    TrackingList.beginTracking();
                    ClientTickHandler.addRunnable(TrackingList::clear, FindMeMod.CONFIG.CLIENT.CONTAINER_TRACK_TIME);
                }
                for (BlockPos position : this.positions) {
                    for (int i = 0; i < 2; ++i) {
                        this.addParticle(position);
                    }
                }
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addParticle(BlockPos position) {
        Minecraft.getInstance().particleEngine.add((Particle)new ParticlePosition(Minecraft.getInstance().level, (double)position.getX() + 0.75 - Minecraft.getInstance().player.level().random.nextDouble() / 2.0, (double)position.getY() + 0.75 - Minecraft.getInstance().player.level().random.nextDouble() / 2.0, (double)position.getZ() + 0.75 - Minecraft.getInstance().player.level().random.nextDouble() / 2.0, 0.0, 0.0, 0.0));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

