/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.client.gui.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import java.util.List;
import net.blay09.mods.balm.mixin.ScreenAccessor;
import net.blay09.mods.farmingforblockheads.FarmingForBlockheads;
import net.blay09.mods.farmingforblockheads.api.MarketCategory;
import net.blay09.mods.farmingforblockheads.api.Payment;
import net.blay09.mods.farmingforblockheads.client.gui.widget.MarketFilterButton;
import net.blay09.mods.farmingforblockheads.menu.MarketMenu;
import net.blay09.mods.farmingforblockheads.recipe.MarketRecipe;
import net.blay09.mods.farmingforblockheads.registry.SimpleHolder;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.RecipeHolder;

public class MarketScreen
extends AbstractContainerScreen<MarketMenu> {
    private static final int SCROLLBAR_COLOR = -5592406;
    private static final int SCROLLBAR_Y = 8;
    private static final int SCROLLBAR_WIDTH = 7;
    private static final int SCROLLBAR_HEIGHT = 77;
    private static final int VISIBLE_ROWS = 4;
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"farmingforblockheads", (String)"textures/gui/market.png");
    private final List<MarketFilterButton> filterButtons = Lists.newArrayList();
    private int scrollBarScaledHeight;
    private int scrollBarXPos;
    private int scrollBarYPos;
    private int currentOffset;
    private int mouseClickY = -1;
    private int indexWhenClicked;
    private int lastNumberOfMoves;
    private EditBox searchBar;

    public MarketScreen(MarketMenu container, Inventory playerInventory, Component displayName) {
        super((AbstractContainerMenu)container, playerInventory, displayName);
    }

    public void init() {
        this.imageHeight = 174;
        super.init();
        Font font = Minecraft.getInstance().font;
        this.searchBar = new EditBox(font, this.leftPos + this.imageWidth - 78, this.topPos - 5, 70, 10, this.searchBar, (Component)Component.empty());
        this.setInitialFocus((GuiEventListener)this.searchBar);
        this.addRenderableWidget((GuiEventListener)this.searchBar);
        this.updateCategoryFilters();
        this.recalculateScrollBar();
    }

    private void updateCategoryFilters() {
        for (MarketFilterButton filterButton : this.filterButtons) {
            ((ScreenAccessor)this).balm_getChildren().remove((Object)filterButton);
            ((ScreenAccessor)this).balm_getRenderables().remove((Object)filterButton);
            ((ScreenAccessor)this).balm_getNarratables().remove((Object)filterButton);
        }
        this.filterButtons.clear();
        int curY = -80;
        List<SimpleHolder<MarketCategory>> categories = ((MarketMenu)this.menu).getCategories();
        for (SimpleHolder<MarketCategory> category : categories) {
            MarketFilterButton filterButton = new MarketFilterButton(this.width / 2 + 87, this.height / 2 + curY, (MarketMenu)this.menu, category, button -> {
                if (((MarketMenu)this.menu).getCurrentCategory().map(it -> it.equals(category)).orElse(false).booleanValue()) {
                    ((MarketMenu)this.menu).setCategory(null);
                } else {
                    ((MarketMenu)this.menu).setCategory(category);
                }
                ((MarketMenu)this.menu).updateListingSlots();
                this.setCurrentOffset(this.currentOffset);
            });
            this.addRenderableWidget((GuiEventListener)filterButton);
            this.filterButtons.add(filterButton);
            curY += 20;
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (Math.abs(deltaY) > 0.0) {
            this.setCurrentOffset(deltaY > 0.0 ? this.currentOffset - 1 : this.currentOffset + 1);
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button != -1 && this.mouseClickY != -1) {
            this.mouseClickY = -1;
            this.indexWhenClicked = 0;
            this.lastNumberOfMoves = 0;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 1 && mouseX >= (double)this.searchBar.getX() && mouseX < (double)(this.searchBar.getX() + this.searchBar.getWidth()) && mouseY >= (double)this.searchBar.getY() && mouseY < (double)(this.searchBar.getY() + this.searchBar.getHeight())) {
            this.searchBar.setValue("");
            ((MarketMenu)this.menu).setSearch(null);
            ((MarketMenu)this.menu).updateListingSlots();
            this.setCurrentOffset(this.currentOffset);
            return true;
        }
        if (mouseX >= (double)this.scrollBarXPos && mouseX <= (double)(this.scrollBarXPos + 7) && mouseY >= (double)this.scrollBarYPos && mouseY <= (double)(this.scrollBarYPos + this.scrollBarScaledHeight)) {
            this.mouseClickY = (int)mouseY;
            this.indexWhenClicked = this.currentOffset;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean charTyped(char c, int keyCode) {
        boolean result = super.charTyped(c, keyCode);
        ((MarketMenu)this.menu).setSearch(this.searchBar.getValue());
        ((MarketMenu)this.menu).updateListingSlots();
        this.setCurrentOffset(this.currentOffset);
        return result;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.searchBar.keyPressed(keyCode, scanCode, modifiers) || this.searchBar.isFocused()) {
            if (keyCode == 256) {
                this.minecraft.player.closeContainer();
            } else {
                ((MarketMenu)this.menu).setSearch(this.searchBar.getValue());
                ((MarketMenu)this.menu).updateListingSlots();
                this.setCurrentOffset(this.currentOffset);
            }
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int numberOfFiltersMoved;
        float pixelsPerFilter;
        if (((MarketMenu)this.menu).isScrollOffsetDirty()) {
            this.updateCategoryFilters();
            this.recalculateScrollBar();
            ((MarketMenu)this.menu).setScrollOffsetDirty(false);
        }
        Font font = this.minecraft.font;
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos - 10, 0, 0, this.imageWidth, this.imageHeight + 10);
        if (((MarketMenu)this.menu).getSelectedRecipe() != null && !((MarketMenu)this.menu).isReadyToBuy()) {
            guiGraphics.blit(TEXTURE, this.leftPos + 43, this.topPos + 40, 176, 0, 14, 14);
        }
        if (this.mouseClickY != -1 && (pixelsPerFilter = (float)(77 - this.scrollBarScaledHeight) / (float)Math.max(1, (int)Math.ceil((float)((MarketMenu)this.menu).getFilteredListCount() / 3.0f) - 4)) != 0.0f && (numberOfFiltersMoved = (int)((float)(mouseY - this.mouseClickY) / pixelsPerFilter)) != this.lastNumberOfMoves) {
            this.setCurrentOffset(this.indexWhenClicked + numberOfFiltersMoved);
            this.lastNumberOfMoves = numberOfFiltersMoved;
        }
        guiGraphics.drawString(font, I18n.get((String)"container.farmingforblockheads.market", (Object[])new Object[0]), this.leftPos + 10, this.topPos + 10, 0xFFFFFF, true);
        RecipeHolder<MarketRecipe> selectedRecipe = ((MarketMenu)this.menu).getSelectedRecipe();
        if (selectedRecipe == null) {
            guiGraphics.drawCenteredString(font, I18n.get((String)"gui.farmingforblockheads.market.no_selection", (Object[])new Object[0]), this.leftPos + 49, this.topPos + 65, 0xFFFFFF);
        } else {
            Payment payment = ((MarketRecipe)selectedRecipe.value()).getPaymentOrDefault();
            Component paymentComponent = payment.tooltip().orElseGet(() -> FarmingForBlockheads.getDefaultPaymentComponent(payment));
            MutableComponent component = Component.translatable((String)"gui.farmingforblockheads.market.cost", (Object[])new Object[]{paymentComponent}).withStyle(ChatFormatting.GREEN);
            int width = font.width((FormattedText)component);
            guiGraphics.fillGradient((int)((float)(this.leftPos + 49) - (float)width / 2.0f - 2.0f), this.topPos + 65 - 2, (int)((float)(this.leftPos + 49) + (float)width / 2.0f + 2.0f), this.topPos + 65 + 9, -2013265920, -1728053248);
            guiGraphics.drawCenteredString(font, (Component)component, this.leftPos + 49, this.topPos + 65, 0xFFFFFF);
        }
        guiGraphics.fill(this.scrollBarXPos, this.scrollBarYPos, this.scrollBarXPos + 7, this.scrollBarYPos + this.scrollBarScaledHeight, -5592406);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int x, int y) {
    }

    public Collection<MarketFilterButton> getFilterButtons() {
        return this.filterButtons;
    }

    private void recalculateScrollBar() {
        int scrollBarTotalHeight = 76;
        this.scrollBarScaledHeight = (int)((double)scrollBarTotalHeight * Math.min(1.0, 4.0 / Math.ceil((float)((MarketMenu)this.menu).getFilteredListCount() / 3.0f)));
        this.scrollBarXPos = this.leftPos + this.imageWidth - 7 - 9;
        this.scrollBarYPos = this.topPos + 8 + (scrollBarTotalHeight - this.scrollBarScaledHeight) * this.currentOffset / Math.max(1, (int)Math.ceil((float)((MarketMenu)this.menu).getFilteredListCount() / 3.0f) - 4);
    }

    private void setCurrentOffset(int currentOffset) {
        this.currentOffset = Math.max(0, Math.min(currentOffset, (int)Math.ceil((float)((MarketMenu)this.menu).getFilteredListCount() / 3.0f) - 4));
        ((MarketMenu)this.menu).setScrollOffset(this.currentOffset);
        this.recalculateScrollBar();
    }
}

