/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.platform.utility;

import net.bivrik.fancytoasts.client.config.data.ToastsFilteringData;
import net.bivrik.fancytoasts.client.toast.IAdvancementAccessor;
import net.bivrik.fancytoasts.core.manager.ToastManager;
import net.bivrik.fancytoasts.platform.Services;
import net.bivrik.fancytoasts.platform.utility.ToastDisplayInfo;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.client.gui.components.toasts.AdvancementToast;
import net.minecraft.client.gui.components.toasts.Toast;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public record ToastsHandler(ToastsFilteringData filteringData, ToastManager toastManager, CallbackInfo info) {
    public void handleAdvancementToasts(AdvancementToast advancementToast) {
        if (!this.filteringData.isAdvancementToastsEnabled()) {
            this.info.cancel();
            return;
        }
        AdvancementHolder advancementHolder = ((IAdvancementAccessor)advancementToast).getAdvancementHolder();
        DisplayInfo oldDisplayInfo = advancementHolder.value().display().orElse(null);
        if (oldDisplayInfo == null) {
            this.info.cancel();
            return;
        }
        ToastDisplayInfo displayInfo = new ToastDisplayInfo(oldDisplayInfo);
        if (this.filteringData.isTypeIgnored(displayInfo.getAdvancementType()) || this.filteringData.isToastIgnored(advancementHolder.id())) {
            this.info.cancel();
            return;
        }
        if (this.filteringData.isFancyAdvancementToastsEnabled()) {
            this.info.cancel();
            this.toastManager.addToast(displayInfo);
        }
    }

    public void handleFTBQuestsToasts(Toast toast) {
        if (this.filteringData.isFancyQuestToastsEnabled()) {
            this.info.cancel();
            ToastDisplayInfo displayInfo = Services.FTB_QUESTS.getDisplayInfo(toast);
            this.toastManager.addToast(displayInfo);
        }
    }

    public void handleRecipeToasts() {
        if (!this.filteringData.isRecipeToastsEnabled()) {
            this.info.cancel();
        }
    }

    public void handleSystemToasts() {
        if (!this.filteringData.isSystemToastsEnabled()) {
            this.info.cancel();
        }
    }

    public void handleTutorialToasts() {
        if (!this.filteringData.isTutorialToastsEnabled()) {
            this.info.cancel();
        }
    }
}

