/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.toast.animation;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.bivrik.fancytoasts.client.config.ToastScreenBehavior;
import net.bivrik.fancytoasts.client.config.data.GeneralConfigData;
import net.bivrik.fancytoasts.client.toast.AnimationSetup;
import net.bivrik.fancytoasts.core.Managers;
import net.bivrik.fancytoasts.core.event.GeneralConfigDataEvent;
import net.bivrik.fancytoasts.platform.utility.Colors;
import net.bivrik.fancytoasts.platform.utility.GuiContext;
import net.bivrik.fancytoasts.platform.utility.ToastDisplayInfo;
import net.bivrik.fancytoasts.utility.TextureUV;
import net.bivrik.fancytoasts.utility.TypeBasedUVs;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public abstract class FancyToastAnimation {
    private final Consumer<GeneralConfigDataEvent> generalConfigDataEventConsumer = this::onGeneralConfigDataChanged;
    private List<FormattedCharSequence> titleLines;
    private List<FormattedCharSequence> descriptionLines;
    protected ToastDisplayInfo displayInfo;
    protected Minecraft minecraft;
    protected int toastWidth;
    protected int toastHeight;
    private ResourceLocation textureLocation;
    private TypeBasedUVs typeBasedUVs;
    private TextureUV backgroundUV;
    private TextureUV plaqueUV;
    private float guiAlpha = 1.0f;
    private boolean shouldTransparentToast;
    private float loopsStrength;
    private float loopsSpeed;
    private static final float TIME_SCALE = 0.00125f;

    FancyToastAnimation() {
        Managers.getEventManager().subscribeToEvent(GeneralConfigDataEvent.class, this.generalConfigDataEventConsumer);
    }

    public void setup(AnimationSetup setup, Minecraft minecraft, int toastWidth, int toastHeight) {
        GeneralConfigData data = Managers.getConfigManager().getGeneralConfigData();
        this.shouldTransparentToast = data.getToastScreenBehavior().equals((Object)ToastScreenBehavior.TRANSPARENT);
        this.loopsStrength = data.getLoopsStrength();
        this.loopsSpeed = data.getLoopsSpeed();
        this.minecraft = minecraft;
        this.toastWidth = toastWidth;
        this.toastHeight = toastHeight;
        this.textureLocation = setup.textureLocation();
        this.displayInfo = setup.displayInfo();
        this.typeBasedUVs = setup.typeBasedUVs();
        this.backgroundUV = setup.backgroundUV();
        this.plaqueUV = setup.plaqueUV();
    }

    public void unsubscribeFromGeneralConfigDataEvent() {
        Managers.getEventManager().unsubscribeFromEvent(GeneralConfigDataEvent.class, this.generalConfigDataEventConsumer);
    }

    private void onGeneralConfigDataChanged(GeneralConfigDataEvent event) {
        GeneralConfigData data = event.generalConfigData();
        this.shouldTransparentToast = data.getToastScreenBehavior().equals((Object)ToastScreenBehavior.TRANSPARENT);
        this.loopsStrength = data.getLoopsStrength();
        this.loopsSpeed = data.getLoopsSpeed();
    }

    protected void setLines(Component title, Component description) {
        this.titleLines = this.minecraft.font.split((FormattedText)title, 142);
        this.descriptionLines = this.minecraft.font.split((FormattedText)description, 142);
    }

    protected List<FormattedCharSequence> getTitleLines() {
        return this.titleLines;
    }

    protected List<FormattedCharSequence> getDescriptionLines() {
        return this.descriptionLines;
    }

    public void draw(GuiGraphics guiGraphics, long time) {
        if (this.shouldTransparentToast && Objects.requireNonNull(Managers.getToastManager()).isScreenOpened()) {
            this.guiAlpha = 0.5f;
        } else if (this.guiAlpha != 1.0f) {
            this.guiAlpha = 1.0f;
        }
    }

    public abstract int getDuration();

    public abstract int getToastSoundTiming();

    protected void drawIcon(GuiContext guiContext, float alpha) {
        guiContext.drawGUITexture(this.textureLocation, 68, 0, 26, 26, this.typeBasedUVs.frame(), this.getColor(alpha));
        guiContext.guiGraphics().renderFakeItem(this.displayInfo.getIcon(), 73, 5);
    }

    protected void drawIcon(GuiContext guiContext) {
        this.drawIcon(guiContext, 1.0f);
    }

    protected void drawBanner(GuiContext guiContext, float alpha) {
        guiContext.drawGUITexture(this.textureLocation, 0, 5, 162, 14, this.typeBasedUVs.banner(), this.getColor(alpha));
    }

    protected void drawBanner(GuiContext guiContext) {
        this.drawBanner(guiContext, 1.0f);
    }

    protected void drawBackground(GuiContext guiContext, float alpha) {
        int color = this.getColor(alpha);
        guiContext.drawGUITexture(this.textureLocation, 0, 20, 162, 40, this.backgroundUV, color);
        guiContext.drawGUITexture(this.textureLocation, 144, 56, 9, 14, this.plaqueUV, color);
    }

    protected void drawBackground(GuiContext guiContext) {
        this.drawBackground(guiContext, 1.0f);
    }

    protected void drawTitle(GuiGraphics guiGraphics, float alpha) {
        if (this.titleLines.isEmpty()) {
            return;
        }
        int toastCenterX = this.toastWidth / 2;
        int titleColor = Colors.alpha(alpha, this.displayInfo.getAdvancementType().getMainColor());
        FormattedCharSequence titleLine = this.titleLines.getFirst();
        if (this.titleLines.size() == 1) {
            guiGraphics.drawCenteredString(this.minecraft.font, titleLine, toastCenterX, 25, titleColor);
        } else {
            guiGraphics.drawCenteredString(this.minecraft.font, titleLine, toastCenterX - this.minecraft.font.width("...") / 2, 25, titleColor);
            guiGraphics.drawCenteredString(this.minecraft.font, "...", toastCenterX + 1 + this.minecraft.font.width(titleLine) / 2, 25, titleColor);
        }
    }

    protected void drawTitle(GuiGraphics guiGraphics) {
        this.drawTitle(guiGraphics, 1.0f);
    }

    protected void drawDescription(GuiGraphics guiGraphics, float alpha) {
        if (this.descriptionLines.isEmpty()) {
            return;
        }
        int descriptionColor = Colors.alpha(alpha, this.displayInfo.getAdvancementType().getSecondaryColor());
        guiGraphics.drawString(this.minecraft.font, this.descriptionLines.get(0), 8, 38, descriptionColor);
        if (this.descriptionLines.size() > 1) {
            FormattedCharSequence descriptionSecondLine = this.descriptionLines.get(1);
            guiGraphics.drawString(this.minecraft.font, descriptionSecondLine, 8, 47, descriptionColor);
            if (this.descriptionLines.size() > 2) {
                guiGraphics.drawString(this.minecraft.font, "...", 8 + this.minecraft.font.width(descriptionSecondLine), 47, descriptionColor);
            }
        }
    }

    protected void drawDescription(GuiGraphics guiGraphics) {
        this.drawDescription(guiGraphics, 1.0f);
    }

    protected float sinusoidLoop(long time, float speed, float strength) {
        float scaledTime = (float)time * 0.00125f * speed * this.loopsSpeed;
        return (float)Math.sin(scaledTime) * strength * this.loopsStrength;
    }

    protected float cosineLoop(long time, float speed, float strength) {
        float scaledTime = (float)time * 0.00125f * speed * this.loopsSpeed;
        return (float)Math.cos(scaledTime) * strength * this.loopsStrength;
    }

    protected int getColor(float alpha) {
        return Colors.alpha(this.guiAlpha * alpha, -1);
    }
}

