/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.gui.screen;

import net.bivrik.fancytoasts.client.config.ConfigHandler;
import net.bivrik.fancytoasts.client.config.data.ToastConfigData;
import net.bivrik.fancytoasts.client.gui.InformationList;
import net.bivrik.fancytoasts.client.gui.ResourceLocationFilter;
import net.bivrik.fancytoasts.client.gui.ResourceLocationList;
import net.bivrik.fancytoasts.client.gui.SettingType;
import net.bivrik.fancytoasts.client.gui.screen.UniversalScreen;
import net.bivrik.fancytoasts.client.toast.Appearance;
import net.bivrik.fancytoasts.client.toast.DisplayData;
import net.bivrik.fancytoasts.core.Managers;
import net.bivrik.fancytoasts.core.event.ToastConfigDataEvent;
import net.bivrik.fancytoasts.core.manager.CustomTextureManager;
import net.bivrik.fancytoasts.platform.utility.Colors;
import net.bivrik.fancytoasts.platform.utility.Components;
import net.bivrik.fancytoasts.platform.utility.FancyToastType;
import net.bivrik.fancytoasts.utility.MathEasing;
import net.bivrik.fancytoasts.utility.file.Paths;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ToastConfigScreen
extends UniversalScreen {
    private static final Component TITLE = Components.of("title.visual_settings");
    private static final Component SAVED_LABEL = Components.of("label.saved");
    private static final Component CONFIG_FOLDER = Components.of("gui.config_folder");
    private static final Component RELOAD_CUSTOMS = Components.of("gui.reload_customs");
    private static final Component RELOAD_CUSTOMS_TOOLTIP = Components.of("tooltip.reload_customs");
    private final ToastConfigData toastConfigData;
    private final CustomTextureManager customTextureManager;
    private ResourceLocationFilter filter = ResourceLocationFilter.A_Z;
    private SettingType settingType = SettingType.TEXTURES;
    private FancyToastType advancementType = FancyToastType.TASK;
    private DisplayData selectedDisplayData;
    private boolean isSaved;
    private long savedFeedbackStartTime;
    private Button doneButton;
    private Button backButton;
    private Button configsFolderButton;
    private Button reloadConfigsButton;
    private CycleButton<SettingType> settingTypeButton;
    private CycleButton<ResourceLocationFilter> locationsFilterButton;
    private CycleButton<FancyToastType> advancementTypeButton;
    private EditBox editBox;
    private ResourceLocationList locationsList;
    private InformationList informationList;

    public ToastConfigScreen(Screen parent) {
        super(TITLE, parent);
        this.toastConfigData = Managers.getConfigManager().getToastConfigData();
        this.customTextureManager = Managers.getCustomTextureManager();
        this.customTextureManager.reload();
        this.selectedDisplayData = this.settingType.getDisplayData(this.toastConfigData.getTextureId());
    }

    public FancyToastType getAdvancementType() {
        return this.advancementType;
    }

    public ToastConfigData getConfigData() {
        return this.toastConfigData;
    }

    protected void init() {
        int xCenter = this.width / 2;
        int yFirstRowBottom = this.height - 26;
        int ySecondRowBottom = yFirstRowBottom - 20 - 8;
        this.backButton = this.addFWidget(this.createButton(CommonComponents.GUI_BACK, button -> this.toParentScreen(), xCenter - 100 - 25 - 4, yFirstRowBottom, 100, 20));
        this.doneButton = this.addFWidget(this.createButton(CommonComponents.GUI_DONE, button -> this.done(), xCenter - 25 + 4, yFirstRowBottom));
        this.locationsList = this.addFWidget(new ResourceLocationList(this.minecraft, xCenter + 60 - 8, this.height - 20 - 8 - 64 - 2 - 20 - 8, xCenter - 60, 60, 18, this.settingType));
        this.locationsList.setSelectResponder(this::onSelectedEntry).setFocusResponder(this::onFocusedEntry);
        this.editBox = this.addFWidget(new EditBox(this.font, xCenter - 60, 32, xCenter - 40 - 30 - 32, 20, this.editBox, (Component)Component.empty()));
        this.editBox.setResponder(this.locationsList::setSearch);
        this.locationsFilterButton = this.addFWidget(CycleButton.builder(ResourceLocationFilter::getDisplayName).displayOnlyValue().withValues((Object[])ResourceLocationFilter.values()).create(this.width - 80 - 16 - 60, 32, 60, 20, (Component)Component.empty(), (button, value) -> this.setFilter((ResourceLocationFilter)((Object)value), (GuiEventListener)button)));
        this.informationList = this.addFWidget(new InformationList(this.minecraft, xCenter - 60 - 16, this.height - 64 - 2 - 20 - 8, 8, 32, this.selectedDisplayData, this.settingType.getCurrentId(this).getPath().contains("config")));
        this.settingTypeButton = this.addFWidget(CycleButton.builder(SettingType::getDisplayName).displayOnlyValue().withValues((Object[])SettingType.values()).withTooltip(settingType -> this.getTooltip(settingType.getName())).create(this.width - 88, 32, 80, 20, (Component)Component.empty(), (button, value) -> this.setSettingType((SettingType)((Object)value))));
        this.configsFolderButton = this.addFWidget(this.createButton(CONFIG_FOLDER, button -> this.openConfigsFolder(), xCenter - 43 - 8, ySecondRowBottom, 86, 20));
        this.reloadConfigsButton = this.addFWidget(this.createButton(RELOAD_CUSTOMS, button -> this.reloadCustomTextures(), xCenter + 129 - 86, ySecondRowBottom, 86, 20, Tooltip.create((Component)RELOAD_CUSTOMS_TOOLTIP)));
        this.advancementTypeButton = this.addFWidget(CycleButton.builder(FancyToastType::getDisplayName).displayOnlyValue().withValues((Object[])FancyToastType.values()).withTooltip(advancementType -> this.getTooltip(advancementType.getName())).create(xCenter - 129, ySecondRowBottom, 70, 20, (Component)Component.empty(), (button, value) -> this.setAdvancementType((FancyToastType)((Object)value))));
        this.tryToggleAdvancementTypeButton();
    }

    private Tooltip getTooltip(String valueName) {
        return Tooltip.create((Component)Components.of("tooltip." + valueName));
    }

    private void openConfigsFolder() {
        Util.getPlatform().openPath(Paths.actualPath("./config/fancytoasts/"));
    }

    private void reloadCustomTextures() {
        this.customTextureManager.reload();
        this.locationsList.setResourceLocations(this.settingType);
    }

    private void done() {
        ToastConfigData data = this.toastConfigData.copy();
        if (!data.equals(Managers.getConfigManager().getToastConfigData())) {
            this.save(data);
        } else {
            this.toParentScreen();
        }
    }

    private void save(ToastConfigData data) {
        ResourceLocation textureId = data.getTextureId();
        this.customTextureManager.releaseUnusedTexturesFromMinecraft();
        if (textureId.toLanguageKey().contains("config")) {
            this.customTextureManager.registerInMinecraft(textureId);
        }
        ConfigHandler.save(data);
        Managers.getEventManager().sendEvent(new ToastConfigDataEvent(data));
        this.isSaved = true;
        this.savedFeedbackStartTime = Util.getMillis();
    }

    @Override
    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.drawSavedFeedback(guiGraphics, this.width / 2 + 8 - 25 + 150, this.height - 20);
    }

    private void drawSavedFeedback(GuiGraphics guiGraphics, int x, int y) {
        if (!this.isSaved) {
            return;
        }
        long time = Util.getMillis() - this.savedFeedbackStartTime;
        float appearanceLerp = MathEasing.easeOutLerp(0.0f, 1.0f, Appearance.getProgress(time, 500, 0));
        float disappearanceLerp = Appearance.getProgress(time, 500, 400);
        int color = Colors.alpha(appearanceLerp - disappearanceLerp, -256);
        guiGraphics.drawString(this.font, SAVED_LABEL, x, y, color);
        if (time > 850L) {
            this.isSaved = false;
        }
    }

    private <T extends GuiEventListener> void setFilter(ResourceLocationFilter filter, T button) {
        this.filter = filter;
        if (button == null) {
            this.locationsFilterButton.setValue((Object)this.filter);
        }
        this.locationsList.setFilter(this.filter);
    }

    private void setSettingType(SettingType settingType) {
        this.settingType = settingType;
        this.locationsList.setResourceLocations(this.settingType);
        this.resetFiltering();
    }

    public void resize(@NotNull Minecraft minecraft, int width, int height) {
        super.resize(minecraft, width, height);
        this.resetFiltering();
    }

    private void resetFiltering() {
        this.editBox.setValue("");
        this.setFilter(ResourceLocationFilter.A_Z, null);
        this.tryToggleAdvancementTypeButton();
    }

    private void tryToggleAdvancementTypeButton() {
        this.advancementTypeButton.active = this.settingType == SettingType.SOUNDS;
        this.informationList$updateOnReload();
    }

    private void setAdvancementType(FancyToastType type) {
        this.advancementType = type;
        this.informationList$updateOnReload();
    }

    private void informationList$updateOnReload() {
        this.informationList.update(this.settingType.getDisplayData(this.getCurrentId()), this.getCurrentId().getPath().contains("config"), true);
    }

    private void onSelectedEntry(ResourceLocation location) {
        this.settingType.apply(this, location);
        this.informationList$updateSelected(location, true);
    }

    private void onFocusedEntry(ResourceLocation location) {
        this.selectedDisplayData = this.settingType.getDisplayData(location);
        boolean isSelected = this.getCurrentId().equals((Object)location);
        this.informationList$updateSelected(location, isSelected);
    }

    private void informationList$updateSelected(ResourceLocation location, boolean isSelected) {
        this.informationList.update(this.selectedDisplayData, location.getPath().contains("config"), isSelected);
    }

    private ResourceLocation getCurrentId() {
        return this.settingType.getCurrentId(this);
    }
}

