/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import net.bivrik.fancytoasts.client.gui.ResourceLocationFilter;
import net.bivrik.fancytoasts.client.gui.SettingType;
import net.bivrik.fancytoasts.core.Debug;
import net.bivrik.fancytoasts.platform.utility.Colors;
import net.bivrik.fancytoasts.platform.utility.GuiContext;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.navigation.CommonInputs;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;

public class ResourceLocationList
extends ObjectSelectionList<Entry> {
    private final Map<ResourceLocation, String> displayNames = new HashMap<ResourceLocation, String>();
    private ResourceLocation[] resourceLocations;
    private SettingType settingType;
    private Consumer<ResourceLocation> selectResponder;
    private Consumer<ResourceLocation> focusResponder;
    private ResourceLocationFilter filter = ResourceLocationFilter.A_Z;
    private String search = "";

    public ResourceLocationList(Minecraft minecraft, int width, int height, int x, int y, int itemHeight, SettingType settingType) {
        super(minecraft, width, height, y, itemHeight);
        this.setX(x);
        this.setResourceLocations(settingType);
    }

    public int getRowWidth() {
        return this.width - 6 - 16;
    }

    public int getRowLeft() {
        return this.getX() + this.width / 2 - this.getRowWidth() / 2 - 3;
    }

    protected int getScrollbarPosition() {
        return this.getX() + this.width - 8;
    }

    public void setResourceLocations(SettingType settingType) {
        this.settingType = settingType;
        this.resourceLocations = this.settingType.getKeySet();
        this.displayNames.clear();
        for (ResourceLocation location : this.resourceLocations) {
            this.displayNames.computeIfAbsent(location, location1 -> this.settingType.getDisplayData((ResourceLocation)location1).getDisplayName().getString().toLowerCase(Locale.ROOT));
        }
        this.sortAZ();
        this.refillList();
    }

    private void refillList() {
        this.clearList();
        if (this.search.isEmpty()) {
            for (ResourceLocation location : this.resourceLocations) {
                this.addEntry((AbstractSelectionList.Entry)new ResourceLocationListEntry(this, location, this.settingType.getDisplayData(location).getDisplayName()));
            }
        } else {
            for (ResourceLocation location : this.resourceLocations) {
                if (!this.displayNames.get(location).contains(this.search)) continue;
                this.addEntry((AbstractSelectionList.Entry)new ResourceLocationListEntry(this, location, this.settingType.getDisplayData(location).getDisplayName()));
            }
        }
    }

    private void clearList() {
        this.clearEntries();
        this.setScrollAmount(0.0);
    }

    public void setSearch(String search) {
        String lowercaseSearch;
        if (search == null) {
            search = "";
        }
        if (this.search.equals(lowercaseSearch = search.toLowerCase(Locale.ROOT))) {
            return;
        }
        this.search = lowercaseSearch;
        this.refillList();
    }

    public void setFilter(ResourceLocationFilter filter) {
        if (this.filter == filter || filter == null) {
            return;
        }
        this.filter = filter;
        this.onFilterUpdate();
    }

    private void onFilterUpdate() {
        switch (this.filter) {
            case A_Z: {
                this.sortAZ();
                break;
            }
            case Z_A: {
                this.sortAZ(Comparator.reverseOrder());
                break;
            }
            case BUILT_IN: {
                this.typeSort(true);
                break;
            }
            case CUSTOM: {
                this.typeSort(false);
            }
        }
        this.refillList();
    }

    private void sortAZ(Comparator<String> comparator) {
        Arrays.sort(this.resourceLocations, (loc1, loc2) -> comparator.compare(this.displayNames.get(loc1), this.displayNames.get(loc2)));
    }

    private void sortAZ() {
        this.sortAZ(Comparator.naturalOrder());
    }

    private void typeSort(boolean isBuiltInFilterType) {
        this.sortAZ();
        ArrayList<Object> builtInLocations = new ArrayList<Object>(this.resourceLocations.length * 2 / 3);
        ArrayList<ResourceLocation> configLocations = new ArrayList<ResourceLocation>();
        for (ResourceLocation location : this.resourceLocations) {
            String namespace = location.getNamespace();
            boolean isBuiltIn = namespace.equals("fancytoasts") || namespace.equals("minecraft");
            boolean isConfig = location.getPath().contains("config") || !isBuiltIn;
            if (isBuiltInFilterType == !isConfig) {
                builtInLocations.add(location);
                continue;
            }
            configLocations.add(location);
        }
        builtInLocations.addAll(configLocations);
        this.resourceLocations = builtInLocations.toArray(new ResourceLocation[0]);
    }

    public ResourceLocationList setSelectResponder(Consumer<ResourceLocation> selectResponder) {
        this.selectResponder = selectResponder;
        return this;
    }

    public ResourceLocationList setFocusResponder(Consumer<ResourceLocation> focusResponder) {
        this.focusResponder = focusResponder;
        return this;
    }

    private static final class ResourceLocationListEntry
    extends Entry {
        private final ResourceLocationList parentList;
        private final ResourceLocation id;
        private final boolean isConfig;
        private final Font font;
        private final SoundManager soundManager;
        private List<FormattedCharSequence> nameLines = new ArrayList<FormattedCharSequence>();
        private long lastClickTime;

        public ResourceLocationListEntry(ResourceLocationList parentList, ResourceLocation id, Component name) {
            this.parentList = parentList;
            Minecraft minecraft = this.parentList.minecraft;
            this.soundManager = minecraft.getSoundManager();
            this.font = minecraft.font;
            this.id = id;
            this.isConfig = this.id.getPath().contains("config");
            if (name != null) {
                this.nameLines = this.font.split((FormattedText)name, this.parentList.getRowWidth() - 8 - 2);
            }
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (Util.getMillis() - this.lastClickTime >= 250L) {
                this.lastClickTime = Util.getMillis();
                this.focus();
            } else {
                this.select();
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }

        public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
            if (CommonInputs.selected((int)keyCode)) {
                this.select();
            }
            return super.keyPressed(keyCode, scanCode, modifiers);
        }

        private void focus() {
            if (this.parentList.focusResponder != null) {
                this.parentList.focusResponder.accept(this.id);
            } else {
                Debug.error("There is no select responder for Resource Location List. Could not select location: " + String.valueOf(this.id));
            }
        }

        private void select() {
            if (this.parentList.selectResponder != null) {
                this.parentList.selectResponder.accept(this.id);
                this.soundManager.play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            } else {
                Debug.error("There is no accept responder for Resource Location List. Could not accept location: " + String.valueOf(this.id));
            }
        }

        public void render(@NotNull GuiGraphics guiGraphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean isHovering, float partialTick) {
            x += 3;
            int mainColor = -1;
            int secondColor = -6250336;
            if (this.isFocused()) {
                mainColor = -256;
                secondColor = -377606;
            } else if (isHovering) {
                GuiContext context = new GuiContext(guiGraphics);
                context.fill(x, y - 2, width, height + 4, Colors.alpha(16, -1));
                context.fill(x + 1, y - 1, width - 2, height + 2, Colors.alpha(64, 0));
            }
            int nameX = x + 3;
            int nameY = y + 3;
            FormattedCharSequence nameFirstLine = this.nameLines.getFirst();
            if (this.nameLines.size() == 1) {
                guiGraphics.drawString(this.font, nameFirstLine, nameX, nameY, mainColor);
            } else {
                guiGraphics.drawString(this.font, this.nameLines.get(1), nameX, nameY + 3, secondColor);
                guiGraphics.drawString(this.font, nameFirstLine, nameX, nameY - 3, mainColor);
            }
            if (this.isConfig) {
                guiGraphics.drawString(this.font, (Component)Component.literal((String)"c"), width - 10, nameY, -6250336);
            }
        }
    }

    protected static abstract class Entry
    extends ObjectSelectionList.Entry<Entry> {
        protected Entry() {
        }

        @NotNull
        public Component getNarration() {
            return Component.empty();
        }
    }
}

