/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.config.data;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.bivrik.fancytoasts.client.config.data.ConfigData;
import net.bivrik.fancytoasts.platform.utility.FancyToastType;
import net.minecraft.resources.ResourceLocation;

public class ToastsFilteringData
extends ConfigData {
    private static final int VERSION = 1;
    private boolean fancyAdvancementToastsEnabled;
    private boolean fancyQuestToastsEnabled;
    private boolean advancementToastsEnabled;
    private boolean recipeToastsEnabled;
    private boolean systemToastsEnabled;
    private boolean tutorialToastsEnabled;
    private final Map<FancyToastType, Boolean> typesToIgnore = new EnumMap<FancyToastType, Boolean>(FancyToastType.class);
    private final List<String> toastsToIgnore = new ArrayList<String>();
    private final transient Set<String> exactMatches = new HashSet<String>();
    private final transient Set<String> prefixMatches = new HashSet<String>();

    private ToastsFilteringData(boolean fancyAdvancementToastsEnabled, boolean fancyQuestToastsEnabled, boolean advancementToastsEnabled, boolean recipeToastsEnabled, boolean systemToastsEnabled, boolean tutorialToastsEnabled, Map<FancyToastType, Boolean> typesToIgnore, List<String> toastsToIgnore) {
        super("./config/fancytoasts/toast_filtering.json");
        this.fancyAdvancementToastsEnabled = fancyAdvancementToastsEnabled;
        this.fancyQuestToastsEnabled = fancyQuestToastsEnabled;
        this.advancementToastsEnabled = advancementToastsEnabled;
        this.recipeToastsEnabled = recipeToastsEnabled;
        this.systemToastsEnabled = systemToastsEnabled;
        this.tutorialToastsEnabled = tutorialToastsEnabled;
        this.typesToIgnore.putAll(typesToIgnore);
        this.toastsToIgnore.addAll(toastsToIgnore);
        for (String toastToIgnore : this.toastsToIgnore) {
            if (toastToIgnore.endsWith("/...")) {
                this.prefixMatches.add(toastToIgnore.replace("/...", ""));
                continue;
            }
            this.exactMatches.add(toastToIgnore);
        }
    }

    public ToastsFilteringData() {
        this(true, true, true, true, true, true, Map.of(FancyToastType.TASK, false, FancyToastType.GOAL, false, FancyToastType.CHALLENGE, false), new ArrayList<String>());
    }

    public boolean isTypeIgnored(FancyToastType type) {
        return this.typesToIgnore.get((Object)type);
    }

    public boolean isToastIgnored(ResourceLocation toastLocation) {
        String toast = toastLocation.toString();
        if (this.exactMatches.contains(toast)) {
            return true;
        }
        for (String prefix : this.prefixMatches) {
            if (!toast.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public boolean isFancyAdvancementToastsEnabled() {
        return this.fancyAdvancementToastsEnabled;
    }

    public void setFancyAdvancementToastsEnabled(boolean fancyAdvancementToastsEnabled) {
        this.fancyAdvancementToastsEnabled = fancyAdvancementToastsEnabled;
    }

    public boolean isFancyQuestToastsEnabled() {
        return this.fancyQuestToastsEnabled;
    }

    public void setFancyQuestToastsEnabled(boolean fancyQuestToastsEnabled) {
        this.fancyQuestToastsEnabled = fancyQuestToastsEnabled;
    }

    public boolean isAdvancementToastsEnabled() {
        return this.advancementToastsEnabled;
    }

    public void setAdvancementToastsEnabled(boolean advancementToastsEnabled) {
        this.advancementToastsEnabled = advancementToastsEnabled;
    }

    public boolean isRecipeToastsEnabled() {
        return this.recipeToastsEnabled;
    }

    public void setRecipeToastsEnabled(boolean recipeToastsEnabled) {
        this.recipeToastsEnabled = recipeToastsEnabled;
    }

    public boolean isSystemToastsEnabled() {
        return this.systemToastsEnabled;
    }

    public void setSystemToastsEnabled(boolean systemToastsEnabled) {
        this.systemToastsEnabled = systemToastsEnabled;
    }

    public boolean isTutorialToastsEnabled() {
        return this.tutorialToastsEnabled;
    }

    public void setTutorialToastsEnabled(boolean tutorialToastsEnabled) {
        this.tutorialToastsEnabled = tutorialToastsEnabled;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ToastsFilteringData)) {
            return false;
        }
        ToastsFilteringData that = (ToastsFilteringData)o;
        return this.fancyAdvancementToastsEnabled == that.fancyAdvancementToastsEnabled && this.fancyQuestToastsEnabled == that.fancyQuestToastsEnabled && this.advancementToastsEnabled == that.advancementToastsEnabled && this.recipeToastsEnabled == that.recipeToastsEnabled && this.systemToastsEnabled == that.systemToastsEnabled && this.tutorialToastsEnabled == that.tutorialToastsEnabled && Objects.equals(this.typesToIgnore, that.typesToIgnore) && Objects.equals(this.toastsToIgnore, that.toastsToIgnore);
    }

    public int hashCode() {
        return Objects.hash(this.fancyAdvancementToastsEnabled, this.fancyQuestToastsEnabled, this.advancementToastsEnabled, this.recipeToastsEnabled, this.systemToastsEnabled, this.tutorialToastsEnabled, this.typesToIgnore, this.toastsToIgnore);
    }

    @Override
    public int getLatestVersion() {
        return 1;
    }

    @Override
    public ToastsFilteringData copy() {
        return (ToastsFilteringData)new ToastsFilteringData(this.fancyAdvancementToastsEnabled, this.fancyQuestToastsEnabled, this.advancementToastsEnabled, this.recipeToastsEnabled, this.systemToastsEnabled, this.tutorialToastsEnabled, this.typesToIgnore, this.toastsToIgnore).withLatestVersion();
    }

    @Override
    public String toString() {
        return super.toString().replace("}", ", ") + String.format("fancyAdvancementToastsEnabled='%s', fancyQuestsToastsEnabled='%s', advancementToastsEnabled='%s', recipeToastsEnabled='%s', systemToastsEnabled='%s', tutorialToastsEnabled='%s', typesToIgnore='%s', toastsToIgnore='%s'}", this.fancyAdvancementToastsEnabled, this.fancyQuestToastsEnabled, this.advancementToastsEnabled, this.recipeToastsEnabled, this.systemToastsEnabled, this.tutorialToastsEnabled, this.typesToIgnore, this.toastsToIgnore);
    }
}

