/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.config;

import java.io.File;
import java.util.Optional;
import net.bivrik.fancytoasts.client.config.JsonHelper;
import net.bivrik.fancytoasts.client.config.data.ConfigData;
import net.bivrik.fancytoasts.core.Debug;
import net.bivrik.fancytoasts.core.Managers;
import net.bivrik.fancytoasts.utility.file.FileHelper;

public class ConfigHandler {
    private static final File CONFIG_DIR = new File("./config/fancytoasts/");

    private static <T extends ConfigData> T tryGetCopy(Class<T> configDataClass) {
        try {
            ConfigData result = ((ConfigData)configDataClass.getConstructor(new Class[0]).newInstance(new Object[0])).copy();
            return (T)result;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create an instance of " + configDataClass.getSimpleName() + " to get standard data", e);
        }
    }

    public static <T extends ConfigData> T load(Class<T> configDataClass) {
        FileHelper.tryCreateDir(CONFIG_DIR);
        T standardConfigData = ConfigHandler.tryGetCopy(configDataClass);
        String className = configDataClass.getSimpleName();
        String configPath = ((ConfigData)standardConfigData).getPath();
        File configFile = new File(configPath);
        if (!JsonHelper.isValid(configFile)) {
            Debug.error("Config file {} is not found in '{}'", className, configPath);
            return ConfigHandler.loadFallback(standardConfigData, className);
        }
        Optional<T> optionalData = JsonHelper.tryToRead(configFile, configDataClass);
        if (optionalData.isEmpty()) {
            Debug.error("Config file {} is not present", className);
            return ConfigHandler.loadFallback(standardConfigData, className);
        }
        ConfigData data = (ConfigData)optionalData.get();
        if (data.isOutdated()) {
            Debug.error("Config file {} is outdated, version: {}/{}", className, data.getVersion(), data.getLatestVersion());
            return ConfigHandler.loadFallback(standardConfigData, className);
        }
        if (!data.isValid()) {
            Debug.error("Config file {} is not valid", className);
            return ConfigHandler.loadFallback(standardConfigData, className);
        }
        Debug.info("Successfully read config file with following content:");
        Debug.info(data.toString());
        return (T)data;
    }

    private static <T extends ConfigData> T loadFallback(T standardConfigData, String className) {
        Debug.warn("Loaded standard data for config: {}", className);
        ConfigHandler.save(standardConfigData);
        return standardConfigData;
    }

    public static <T extends ConfigData> void save(T configData) {
        FileHelper.tryCreateDir(CONFIG_DIR);
        File configFile = new File(configData.getPath());
        if (JsonHelper.tryToWrite(configFile, configData)) {
            Debug.info("Config file saved with following content:");
            Debug.info(configData.toString());
            Managers.getConfigManager().updateConfig(configData);
        } else {
            Debug.error("Config file {} could not be saved", configData.getClass().getSimpleName());
        }
    }
}

