/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.text;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class TextFormattingUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String FORMATTING_CODE_BLACK = "0";
    private static final String FORMATTING_CODE_DARK_BLUE = "1";
    private static final String FORMATTING_CODE_DARK_GREEN = "2";
    private static final String FORMATTING_CODE_DARK_AQUA = "3";
    private static final String FORMATTING_CODE_DARK_RED = "4";
    private static final String FORMATTING_CODE_DARK_PURPLE = "5";
    private static final String FORMATTING_CODE_ORANGE = "6";
    private static final String FORMATTING_CODE_GREY = "7";
    private static final String FORMATTING_CODE_DARK_GREY = "8";
    private static final String FORMATTING_CODE_BLUE = "9";
    private static final String FORMATTING_CODE_GREEN = "a";
    private static final String FORMATTING_CODE_AQUA = "b";
    private static final String FORMATTING_CODE_RED = "c";
    private static final String FORMATTING_CODE_PURPLE = "d";
    private static final String FORMATTING_CODE_YELLOW = "e";
    private static final String FORMATTING_CODE_WHITE = "f";
    private static final String FORMATTING_CODE_BOLD = "l";
    private static final String FORMATTING_CODE_STRIKE = "m";
    private static final String FORMATTING_CODE_UNDERLINE = "n";
    private static final String FORMATTING_CODE_ITALIC = "o";
    private static final String FORMATTING_CODE_MAGIC = "k";
    private static final String FORMATTING_CODE_RESET = "r";

    @NotNull
    public static String replaceFormattingCodes(@NotNull String in, @NotNull String oldPrefix, @NotNull String newPrefix) {
        Objects.requireNonNull(in);
        in = StringUtils.replace((String)in, (String)(oldPrefix + FORMATTING_CODE_BLACK), (String)(newPrefix + FORMATTING_CODE_BLACK));
        in = StringUtils.replace((String)in, (String)(oldPrefix + FORMATTING_CODE_DARK_BLUE), (String)(newPrefix + FORMATTING_CODE_DARK_BLUE));
        in = StringUtils.replace((String)in, (String)(oldPrefix + FORMATTING_CODE_DARK_GREEN), (String)(newPrefix + FORMATTING_CODE_DARK_GREEN));
        in = StringUtils.replace((String)in, (String)(oldPrefix + FORMATTING_CODE_DARK_AQUA), (String)(newPrefix + FORMATTING_CODE_DARK_AQUA));
        in = StringUtils.replace((String)in, (String)(oldPrefix + FORMATTING_CODE_DARK_RED), (String)(newPrefix + FORMATTING_CODE_DARK_RED));
        in = StringUtils.replace((String)in, (String)(oldPrefix + FORMATTING_CODE_DARK_PURPLE), (String)(newPrefix + FORMATTING_CODE_DARK_PURPLE));
        in = StringUtils.replace((String)in, (String)(oldPrefix + FORMATTING_CODE_ORANGE), (String)(newPrefix + FORMATTING_CODE_ORANGE));
        in = StringUtils.replace((String)in, (String)(oldPrefix + FORMATTING_CODE_GREY), (String)(newPrefix + FORMATTING_CODE_GREY));
        in = StringUtils.replace((String)in, (String)(oldPrefix + FORMATTING_CODE_DARK_GREY), (String)(newPrefix + FORMATTING_CODE_DARK_GREY));
        in = StringUtils.replace((String)in, (String)(oldPrefix + FORMATTING_CODE_BLUE), (String)(newPrefix + FORMATTING_CODE_BLUE));
        in = StringUtils.replace((String)in, (String)(oldPrefix + FORMATTING_CODE_GREEN), (String)(newPrefix + FORMATTING_CODE_GREEN));
        in = StringUtils.replace((String)in, (String)(oldPrefix + FORMATTING_CODE_AQUA), (String)(newPrefix + FORMATTING_CODE_AQUA));
        in = StringUtils.replace((String)in, (String)(oldPrefix + FORMATTING_CODE_RED), (String)(newPrefix + FORMATTING_CODE_RED));
        in = StringUtils.replace((String)in, (String)(oldPrefix + FORMATTING_CODE_PURPLE), (String)(newPrefix + FORMATTING_CODE_PURPLE));
        in = StringUtils.replace((String)in, (String)(oldPrefix + FORMATTING_CODE_YELLOW), (String)(newPrefix + FORMATTING_CODE_YELLOW));
        in = StringUtils.replace((String)in, (String)(oldPrefix + FORMATTING_CODE_WHITE), (String)(newPrefix + FORMATTING_CODE_WHITE));
        in = StringUtils.replace((String)in, (String)(oldPrefix + FORMATTING_CODE_BOLD), (String)(newPrefix + FORMATTING_CODE_BOLD));
        in = StringUtils.replace((String)in, (String)(oldPrefix + FORMATTING_CODE_STRIKE), (String)(newPrefix + FORMATTING_CODE_STRIKE));
        in = StringUtils.replace((String)in, (String)(oldPrefix + FORMATTING_CODE_UNDERLINE), (String)(newPrefix + FORMATTING_CODE_UNDERLINE));
        in = StringUtils.replace((String)in, (String)(oldPrefix + FORMATTING_CODE_ITALIC), (String)(newPrefix + FORMATTING_CODE_ITALIC));
        in = StringUtils.replace((String)in, (String)(oldPrefix + FORMATTING_CODE_MAGIC), (String)(newPrefix + FORMATTING_CODE_MAGIC));
        in = StringUtils.replace((String)in, (String)(oldPrefix + FORMATTING_CODE_RESET), (String)(newPrefix + FORMATTING_CODE_RESET));
        return in;
    }

    public static String convertComponentToString(@NotNull Component textComponent) {
        StringBuilder sb = new StringBuilder();
        TextFormattingUtils.appendComponent(sb, textComponent, textComponent.getStyle());
        return sb.toString();
    }

    private static void appendComponent(@NotNull StringBuilder sb, @NotNull Component component, @NotNull Style parentStyle) {
        Style style = component.getStyle().applyTo(parentStyle);
        if (style.isBold()) {
            sb.append(ChatFormatting.BOLD);
        }
        if (style.isItalic()) {
            sb.append(ChatFormatting.ITALIC);
        }
        if (style.isUnderlined()) {
            sb.append(ChatFormatting.UNDERLINE);
        }
        if (style.isStrikethrough()) {
            sb.append(ChatFormatting.STRIKETHROUGH);
        }
        if (style.isObfuscated()) {
            sb.append(ChatFormatting.OBFUSCATED);
        }
        if (style.getColor() != null) {
            sb.append(style.getColor().toString());
        }
        sb.append(component.getContents());
        sb.append(ChatFormatting.RESET);
        for (Component sibling : component.getSiblings()) {
            TextFormattingUtils.appendComponent(sb, sibling, style);
        }
    }

    @NotNull
    public static MutableComponent convertFormattedTextToComponent(@NotNull FormattedText text) {
        MutableComponent component = Component.literal((String)"");
        text.visit((style, string) -> {
            component.append((Component)Component.literal((String)string).withStyle(style));
            return Optional.empty();
        }, Style.EMPTY);
        return component;
    }

    @NotNull
    public static <C extends Component> List<MutableComponent> lineWrapComponents(@NotNull List<C> lines, int maxLength) {
        ArrayList<MutableComponent> wrappedLines = new ArrayList<MutableComponent>();
        for (Component line : lines) {
            if (line.getString().isBlank()) {
                line = Component.literal((String)" ");
            }
            for (FormattedText text : Minecraft.getInstance().font.getSplitter().splitLines((FormattedText)line, maxLength, Style.EMPTY)) {
                wrappedLines.add(TextFormattingUtils.convertFormattedTextToComponent(text));
            }
        }
        return wrappedLines;
    }

    @NotNull
    public static <C extends Component> List<MutableComponent> lineWrapComponents(@NotNull C lines, int maxLength) {
        return TextFormattingUtils.lineWrapComponents(List.of(lines), maxLength);
    }
}

