/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.loadingrequirement.requirements.gui;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.elements.button.custombutton.ButtonElement;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayerHandler;
import de.keksuccino.fancymenu.customization.loadingrequirement.LoadingRequirement;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorFormattingRule;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IsElementFocusedRequirement
extends LoadingRequirement {
    private static final Logger LOGGER = LogManager.getLogger();

    public IsElementFocusedRequirement() {
        super("is_element_focused");
    }

    @Override
    public boolean canRunAsync() {
        return false;
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isRequirementMet(@Nullable String value) {
        ScreenCustomizationLayer handler;
        Screen s;
        if (value != null && (s = Minecraft.getInstance().screen) != null && (handler = ScreenCustomizationLayerHandler.getLayerOfScreen(s)) != null) {
            AbstractElement i = handler.getElementByInstanceIdentifier(value);
            if (i instanceof ButtonElement) {
                ButtonElement w = (ButtonElement)i;
                if (w.getWidget() != null) {
                    return w.getWidget().isFocused();
                }
            } else if (i != null) {
                List<GuiEventListener> listeners = i.getWidgetsToRegister();
                if (listeners == null) {
                    return false;
                }
                for (GuiEventListener l : listeners) {
                    if (!l.isFocused()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return I18n.get((String)"fancymenu.requirements.is_element_focused", (Object[])new Object[0]);
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.is_element_fucsed.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return I18n.get((String)"fancymenu.requirements.categories.gui", (Object[])new Object[0]);
    }

    @Override
    public String getValueDisplayName() {
        return I18n.get((String)"fancymenu.requirements.is_element_hovered.value_name", (Object[])new Object[0]);
    }

    @Override
    public String getValuePreset() {
        return "element_id_of_vanilla_widget";
    }

    @Override
    public List<TextEditorFormattingRule> getValueFormattingRules() {
        return null;
    }
}

