/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.editor;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.anchor.ElementAnchorPoint;
import de.keksuccino.fancymenu.customization.element.anchor.ElementAnchorPoints;
import de.keksuccino.fancymenu.customization.element.editor.EditorElementBorderDisplay;
import de.keksuccino.fancymenu.customization.element.editor.EditorElementSettings;
import de.keksuccino.fancymenu.customization.layout.editor.AnchorPointOverlay;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorHistory;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementContainer;
import de.keksuccino.fancymenu.customization.loadingrequirement.ui.ManageRequirementsScreen;
import de.keksuccino.fancymenu.util.ConsumingSupplier;
import de.keksuccino.fancymenu.util.ListUtils;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.MathUtils;
import de.keksuccino.fancymenu.util.ObjectUtils;
import de.keksuccino.fancymenu.util.cycle.ValueCycle;
import de.keksuccino.fancymenu.util.enums.LocalizedCycleEnum;
import de.keksuccino.fancymenu.util.file.FileFilter;
import de.keksuccino.fancymenu.util.file.GameDirectoryUtils;
import de.keksuccino.fancymenu.util.file.type.FileType;
import de.keksuccino.fancymenu.util.file.type.groups.FileTypeGroup;
import de.keksuccino.fancymenu.util.file.type.groups.FileTypeGroups;
import de.keksuccino.fancymenu.util.input.CharacterFilter;
import de.keksuccino.fancymenu.util.input.TextValidators;
import de.keksuccino.fancymenu.util.rendering.AspectRatio;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.contextmenu.v2.ContextMenu;
import de.keksuccino.fancymenu.util.rendering.ui.cursor.CursorHandler;
import de.keksuccino.fancymenu.util.rendering.ui.screen.ConfirmationScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.NotificationScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.TextInputScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.resource.ResourceChooserScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorScreen;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.resource.Resource;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.resources.audio.IAudio;
import de.keksuccino.fancymenu.util.resource.resources.text.IText;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import de.keksuccino.fancymenu.util.resource.resources.video.IVideo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEditorElement
implements Renderable,
GuiEventListener {
    private static final Logger LOGGER = LogManager.getLogger();
    protected static final ResourceLocation DRAGGING_NOT_ALLOWED_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"fancymenu", (String)"textures/not_allowed.png");
    protected static final ResourceLocation DEPRECATED_WARNING_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"fancymenu", (String)"textures/warning_20x20.png");
    protected static final ConsumingSupplier<AbstractEditorElement, Integer> BORDER_COLOR = editorElement -> {
        if (editorElement.isSelected()) {
            return UIBase.getUIColorTheme().layout_editor_element_border_color_selected.getColorInt();
        }
        return UIBase.getUIColorTheme().layout_editor_element_border_color_normal.getColorInt();
    };
    protected static final ConsumingSupplier<AbstractEditorElement, Float> HORIZONTAL_TILT_CONTROLS_ALPHA = consumes -> {
        if (consumes.horizontalTiltGrabber.hovered || consumes.isGettingHorizontalTilted()) {
            return Float.valueOf(1.0f);
        }
        return Float.valueOf(0.7f);
    };
    protected static final ConsumingSupplier<AbstractEditorElement, Float> VERTICAL_TILT_CONTROLS_ALPHA = consumes -> {
        if (consumes.verticalTiltGrabber.hovered || consumes.isGettingVerticalTilted()) {
            return Float.valueOf(1.0f);
        }
        return Float.valueOf(0.7f);
    };
    protected static final ConsumingSupplier<AbstractEditorElement, Float> ROTATION_CONTROLS_ALPHA = consumes -> {
        if (consumes.rotationGrabber.hovered || consumes.isGettingRotated()) {
            return Float.valueOf(1.0f);
        }
        return Float.valueOf(0.7f);
    };
    public AbstractElement element;
    public final EditorElementSettings settings;
    public ContextMenu rightClickMenu;
    public EditorElementBorderDisplay topLeftDisplay = new EditorElementBorderDisplay(this, EditorElementBorderDisplay.DisplayPosition.TOP_LEFT, EditorElementBorderDisplay.DisplayPosition.LEFT_TOP, EditorElementBorderDisplay.DisplayPosition.BOTTOM_LEFT);
    public EditorElementBorderDisplay bottomRightDisplay = new EditorElementBorderDisplay(this, EditorElementBorderDisplay.DisplayPosition.BOTTOM_RIGHT, EditorElementBorderDisplay.DisplayPosition.RIGHT_BOTTOM, EditorElementBorderDisplay.DisplayPosition.TOP_RIGHT);
    public LayoutEditorScreen editor;
    protected boolean selected = false;
    protected boolean multiSelected = false;
    protected boolean hovered = false;
    protected boolean leftMouseDown = false;
    protected double leftMouseDownMouseX = 0.0;
    protected double leftMouseDownMouseY = 0.0;
    protected int leftMouseDownBaseX = 0;
    protected int leftMouseDownBaseY = 0;
    protected int leftMouseDownBaseWidth = 0;
    protected int leftMouseDownBaseHeight = 0;
    protected int movingStartPosX = 0;
    protected int movingStartPosY = 0;
    protected int resizingStartPosX = 0;
    protected int resizingStartPosY = 0;
    protected ResizeGrabber[] resizeGrabbers = new ResizeGrabber[]{new ResizeGrabber(ResizeGrabberType.TOP), new ResizeGrabber(ResizeGrabberType.RIGHT), new ResizeGrabber(ResizeGrabberType.BOTTOM), new ResizeGrabber(ResizeGrabberType.LEFT)};
    protected ResizeGrabber activeResizeGrabber = null;
    protected RotationGrabber rotationGrabber = new RotationGrabber();
    protected boolean rotationGrabberActive = false;
    protected float rotationStartAngle = 0.0f;
    protected double rotationStartMouseAngle = 0.0;
    protected LayoutEditorHistory.Snapshot preRotationSnapshot;
    protected VerticalTiltGrabber verticalTiltGrabber = new VerticalTiltGrabber();
    protected boolean verticalTiltGrabberActive = false;
    protected float verticalTiltStartAngle = 0.0f;
    protected double verticalTiltStartMouseY = 0.0;
    protected HorizontalTiltGrabber horizontalTiltGrabber = new HorizontalTiltGrabber();
    protected boolean horizontalTiltGrabberActive = false;
    protected float horizontalTiltStartAngle = 0.0f;
    protected double horizontalTiltStartMouseX = 0.0;
    protected LayoutEditorHistory.Snapshot preTiltSnapshot;
    protected AspectRatio resizeAspectRatio = new AspectRatio(10, 10);
    public long renderMovingNotAllowedTime = -1L;
    public boolean recentlyMovedByDragging = false;
    public boolean recentlyLeftClickSelected = false;
    public boolean recentlyResized = false;
    public boolean movingCrumpleZonePassed = false;
    private final List<AbstractEditorElement> cachedHoveredElementsOnRightClickMenuOpen = new ArrayList<AbstractEditorElement>();

    public AbstractEditorElement(@NotNull AbstractElement element, final @NotNull LayoutEditorScreen editor, @Nullable EditorElementSettings settings) {
        this.settings = settings != null ? settings : new EditorElementSettings();
        this.settings.editorElement = this;
        this.editor = editor;
        this.element = element;
        this.rightClickMenu = new ContextMenu(){

            @Override
            public ContextMenu openMenuAt(float x, float y, @Nullable List<String> entryPath) {
                AbstractEditorElement.this.cachedHoveredElementsOnRightClickMenuOpen.clear();
                AbstractEditorElement.this.cachedHoveredElementsOnRightClickMenuOpen.addAll(editor.getHoveredElements());
                return super.openMenuAt(x, y, entryPath);
            }
        };
        this.init();
    }

    public AbstractEditorElement(@Nonnull AbstractElement element, @Nonnull LayoutEditorScreen editor) {
        this(element, editor, new EditorElementSettings());
    }

    public void init() {
        this.rightClickMenu.closeMenu();
        this.rightClickMenu.clearEntries();
        this.topLeftDisplay.clearLines();
        this.bottomRightDisplay.clearLines();
        this.topLeftDisplay.addLine("anchor_point", () -> Component.translatable((String)"fancymenu.element.border_display.anchor_point", (Object[])new Object[]{this.element.anchorPoint.getDisplayName()}));
        this.topLeftDisplay.addLine("pos_x", () -> Component.translatable((String)"fancymenu.element.border_display.pos_x", (Object[])new Object[]{"" + this.getX()}));
        this.topLeftDisplay.addLine("width", () -> Component.translatable((String)"fancymenu.element.border_display.width", (Object[])new Object[]{"" + this.getWidth()}));
        if (this.element.builder.isDeprecated()) {
            this.topLeftDisplay.addLine("deprecated_warning_line0", Component::empty);
            this.topLeftDisplay.addLine("deprecated_warning_line1", () -> Component.translatable((String)"fancymenu.elements.deprecated_warning.line1").setStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().warning_text_color.getColorInt())));
            this.topLeftDisplay.addLine("deprecated_warning_line2", () -> Component.translatable((String)"fancymenu.elements.deprecated_warning.line2").setStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().warning_text_color.getColorInt())));
            this.topLeftDisplay.addLine("deprecated_warning_line3", () -> Component.translatable((String)"fancymenu.elements.deprecated_warning.line3").setStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().warning_text_color.getColorInt())));
        }
        this.bottomRightDisplay.addLine("pos_y", () -> Component.translatable((String)"fancymenu.element.border_display.pos_y", (Object[])new Object[]{"" + this.getY()}));
        this.bottomRightDisplay.addLine("height", () -> Component.translatable((String)"fancymenu.element.border_display.height", (Object[])new Object[]{"" + this.getHeight()}));
        ContextMenu pickElementMenu = new ContextMenu(){

            @Override
            @NotNull
            public ContextMenu openMenuAt(float x, float y) {
                this.clearEntries();
                int i = 0;
                for (AbstractEditorElement e : AbstractEditorElement.this.cachedHoveredElementsOnRightClickMenuOpen) {
                    this.addClickableEntry("element_" + i, e.element.getDisplayName(), (menu, entry) -> {
                        AbstractEditorElement.this.editor.getAllElements().forEach(AbstractEditorElement::resetElementStates);
                        e.setSelected(true);
                    });
                    ++i;
                }
                return super.openMenuAt(x, y);
            }
        };
        this.rightClickMenu.addSubMenuEntry("pick_element", (Component)Component.translatable((String)"fancymenu.element.general.pick_element"), pickElementMenu).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.element.general.pick_element.desc", new String[0])));
        this.rightClickMenu.addSeparatorEntry("separator_1");
        if (this.settings.isIdentifierCopyable()) {
            ((ContextMenu.ClickableContextMenuEntry)this.rightClickMenu.addClickableEntry("copy_id", (Component)Component.translatable((String)"fancymenu.elements.copyid"), (menu, entry) -> {
                Minecraft.getInstance().keyboardHandler.setClipboard(this.element.getInstanceIdentifier());
                menu.closeMenu();
            }).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.elements.copyid.desc", new String[0])))).setIcon(ContextMenu.IconFactory.getIcon("notes"));
        }
        this.rightClickMenu.addSeparatorEntry("separator_2");
        this.addStringInputContextMenuEntryTo(this.rightClickMenu, "set_in_editor_display_name", AbstractEditorElement.class, consumes -> consumes.element.customElementLayerName, (abstractEditorElement, s) -> {
            abstractEditorElement.element.customElementLayerName = s;
        }, null, false, false, (Component)Component.translatable((String)"fancymenu.elements.in_editor_display_name"), true, null, null, null).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.elements.in_editor_display_name.desc", new String[0])));
        if (this.settings.isInEditorColorSupported()) {
            this.addStringInputContextMenuEntryTo(this.rightClickMenu, "set_in_editor_color", AbstractEditorElement.class, consumes -> consumes.element.inEditorColor.getHex(), (element, s) -> {
                element.element.inEditorColor = DrawableColor.of(s);
            }, null, false, false, (Component)Component.translatable((String)"fancymenu.elements.in_editor_color"), false, null, TextValidators.HEX_COLOR_TEXT_VALIDATOR, null).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.elements.in_editor_color.desc", new String[0])));
        }
        this.rightClickMenu.addSeparatorEntry("separator_after_set_in_editor_stuff");
        if (this.settings.isAnchorPointChangeable()) {
            ContextMenu anchorPointMenu = new ContextMenu();
            ((ContextMenu.SubMenuContextMenuEntry)((ContextMenu.SubMenuContextMenuEntry)this.rightClickMenu.addSubMenuEntry("anchor_point", (Component)Component.translatable((String)"fancymenu.elements.anchor_point"), anchorPointMenu).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.elements.anchor_points.desc", new String[0])))).setStackable(true)).setIcon(ContextMenu.IconFactory.getIcon("anchor"));
            if (this.settings.isElementAnchorPointAllowed()) {
                ((ContextMenu.ClickableContextMenuEntry)anchorPointMenu.addClickableEntry("anchor_point_element", ElementAnchorPoints.ELEMENT.getDisplayName(), (menu, entry) -> {
                    if (entry.getStackMeta().isFirstInStack()) {
                        TextInputScreen s = new TextInputScreen((Component)Component.translatable((String)"fancymenu.elements.anchor_points.element.setidentifier"), null, call -> {
                            if (call != null) {
                                AbstractEditorElement editorElement = this.editor.getElementByInstanceIdentifier((String)call);
                                if (editorElement != null) {
                                    this.editor.history.saveSnapshot();
                                    for (AbstractEditorElement e : this.editor.getSelectedElements()) {
                                        if (!e.settings.isAnchorPointChangeable() || !e.settings.isElementAnchorPointAllowed()) continue;
                                        e.element.setAnchorPointElementIdentifier(editorElement.element.getInstanceIdentifier());
                                        e.element.setElementAnchorPointParent(editorElement.element);
                                        e.setAnchorPoint(ElementAnchorPoints.ELEMENT, true);
                                    }
                                    Minecraft.getInstance().setScreen((Screen)this.editor);
                                } else {
                                    Minecraft.getInstance().setScreen((Screen)NotificationScreen.error(b -> Minecraft.getInstance().setScreen((Screen)this.editor), LocalizationUtils.splitLocalizedLines("fancymenu.elements.anchor_points.element.setidentifier.identifiernotfound", new String[0])));
                                }
                            } else {
                                Minecraft.getInstance().setScreen((Screen)this.editor);
                            }
                        });
                        if (!entry.getStackMeta().isPartOfStack()) {
                            s.setText(this.element.getAnchorPointElementIdentifier());
                        }
                        Minecraft.getInstance().setScreen((Screen)s);
                        menu.closeMenu();
                    }
                }).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.elements.anchor_points.element.desc", new String[0])))).setStackable(true);
            }
            anchorPointMenu.addSeparatorEntry("separator_1").setStackable(true);
            for (ElementAnchorPoint p : ElementAnchorPoints.getAnchorPoints()) {
                if (p == ElementAnchorPoints.ELEMENT || !this.settings.isVanillaAnchorPointAllowed() && p == ElementAnchorPoints.VANILLA) continue;
                ((ContextMenu.ClickableContextMenuEntry)anchorPointMenu.addClickableEntry("anchor_point_" + p.getName().replace("-", "_"), p.getDisplayName(), (menu, entry) -> {
                    if (entry.getStackMeta().isFirstInStack()) {
                        this.editor.history.saveSnapshot();
                        for (AbstractEditorElement e : this.editor.getSelectedElements()) {
                            if (!e.settings.isAnchorPointChangeable()) continue;
                            e.setAnchorPoint(p, true);
                        }
                        menu.closeMenu();
                    }
                }).setStackable(true)).setIcon(ContextMenu.IconFactory.getIcon("anchor_" + p.getName().replace("-", "_")));
            }
        }
        if (this.settings.isStayOnScreenAllowed()) {
            ((ContextMenu.ClickableContextMenuEntry)((ContextMenu.ContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)this.addToggleContextMenuEntryTo(this.rightClickMenu, "stay_on_screen", AbstractEditorElement.class, consumes -> consumes.element.stayOnScreen, (element1, aBoolean) -> {
                element1.element.stayOnScreen = aBoolean;
            }, "fancymenu.elements.element.stay_on_screen").setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines(!this.element.stickyAnchor ? "fancymenu.elements.element.stay_on_screen.tooltip" : "fancymenu.elements.element.stay_on_screen.tooltip.disable_sticky", new String[0])))).setIcon(ContextMenu.IconFactory.getIcon("screen"))).setStackable(false)).addIsActiveSupplier((menu, entry) -> !this.element.stickyAnchor);
        }
        if (this.settings.isAdvancedPositioningSupported()) {
            ContextMenu advancedPositioningMenu = new ContextMenu();
            ((ContextMenu.SubMenuContextMenuEntry)((ContextMenu.SubMenuContextMenuEntry)this.rightClickMenu.addSubMenuEntry("advanced_positioning", (Component)Component.translatable((String)"fancymenu.elements.features.advanced_positioning"), advancedPositioningMenu).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.elements.features.advanced_positioning.desc", new String[0])))).setStackable(true)).setIcon(ContextMenu.IconFactory.getIcon("move"));
            this.addGenericStringInputContextMenuEntryTo(advancedPositioningMenu, "advanced_positioning_x", element -> element.settings.isAdvancedPositioningSupported(), consumes -> consumes.element.advancedX, (element, input) -> {
                element.element.advancedX = input;
            }, null, false, true, (Component)Component.translatable((String)"fancymenu.elements.features.advanced_positioning.posx"), true, null, TextValidators.NO_EMPTY_STRING_TEXT_VALIDATOR, null).setStackable(true);
            this.addGenericStringInputContextMenuEntryTo(advancedPositioningMenu, "advanced_positioning_y", element -> element.settings.isAdvancedPositioningSupported(), consumes -> consumes.element.advancedY, (element, input) -> {
                element.element.advancedY = input;
            }, null, false, true, (Component)Component.translatable((String)"fancymenu.elements.features.advanced_positioning.posy"), true, null, TextValidators.NO_EMPTY_STRING_TEXT_VALIDATOR, null).setStackable(true);
        }
        if (this.settings.isAdvancedSizingSupported()) {
            ContextMenu advancedSizingMenu = new ContextMenu();
            ((ContextMenu.SubMenuContextMenuEntry)((ContextMenu.SubMenuContextMenuEntry)this.rightClickMenu.addSubMenuEntry("advanced_sizing", (Component)Component.translatable((String)"fancymenu.elements.features.advanced_sizing"), advancedSizingMenu).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.elements.features.advanced_sizing.desc", new String[0])))).setStackable(true)).setIcon(ContextMenu.IconFactory.getIcon("resize"));
            this.addGenericStringInputContextMenuEntryTo(advancedSizingMenu, "advanced_sizing_width", element -> element.settings.isAdvancedSizingSupported(), consumes -> consumes.element.advancedWidth, (element, input) -> {
                element.element.advancedWidth = input;
                element.element.baseWidth = 50;
            }, null, false, true, (Component)Component.translatable((String)"fancymenu.elements.features.advanced_sizing.width"), true, null, TextValidators.NO_EMPTY_STRING_TEXT_VALIDATOR, null).setStackable(true);
            this.addGenericStringInputContextMenuEntryTo(advancedSizingMenu, "advanced_sizing_height", element -> element.settings.isAdvancedSizingSupported(), consumes -> consumes.element.advancedHeight, (element, input) -> {
                element.element.advancedHeight = input;
                element.element.baseHeight = 50;
            }, null, false, true, (Component)Component.translatable((String)"fancymenu.elements.features.advanced_sizing.height"), true, null, TextValidators.NO_EMPTY_STRING_TEXT_VALIDATOR, null).setStackable(true);
        }
        this.rightClickMenu.addSeparatorEntry("separator_after_advanced_sizing_positioning").setStackable(true);
        if (this.settings.isStretchable()) {
            ((ContextMenu.ClickableContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)this.addToggleContextMenuEntryTo(this.rightClickMenu, "stretch_x", AbstractEditorElement.class, consumes -> consumes.element.stretchX, (element1, aBoolean) -> {
                element1.element.stretchX = aBoolean;
            }, "fancymenu.elements.stretch.x").setStackable(true)).setIsActiveSupplier((menu, entry) -> this.element.advancedWidth == null)).setIcon(ContextMenu.IconFactory.getIcon("arrow_horizontal"));
            ((ContextMenu.ClickableContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)this.addToggleContextMenuEntryTo(this.rightClickMenu, "stretch_y", AbstractEditorElement.class, consumes -> consumes.element.stretchY, (element1, aBoolean) -> {
                element1.element.stretchY = aBoolean;
            }, "fancymenu.elements.stretch.y").setStackable(true)).setIsActiveSupplier((menu, entry) -> this.element.advancedHeight == null)).setIcon(ContextMenu.IconFactory.getIcon("arrow_vertical"));
        }
        this.rightClickMenu.addSeparatorEntry("separator_after_stretch_xy").setStackable(true);
        if (this.settings.isLoadingRequirementsEnabled()) {
            ((ContextMenu.ClickableContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)this.rightClickMenu.addClickableEntry("loading_requirements", (Component)Component.translatable((String)"fancymenu.requirements.elements.loading_requirements"), (menu, entry) -> {
                if (!entry.getStackMeta().isPartOfStack()) {
                    ManageRequirementsScreen s = new ManageRequirementsScreen(this.element.loadingRequirementContainer.copy(false), call -> {
                        if (call != null) {
                            this.editor.history.saveSnapshot();
                            this.element.loadingRequirementContainer = call;
                        }
                        Minecraft.getInstance().setScreen((Screen)this.editor);
                    });
                    Minecraft.getInstance().setScreen((Screen)s);
                } else if (entry.getStackMeta().isFirstInStack()) {
                    List<AbstractEditorElement> selectedElements = this.getFilteredSelectedElementList(element -> element.settings.isLoadingRequirementsEnabled());
                    List<LoadingRequirementContainer> containers = ObjectUtils.getOfAll(LoadingRequirementContainer.class, selectedElements, consumes -> consumes.element.loadingRequirementContainer);
                    LoadingRequirementContainer containerToUseInManager = new LoadingRequirementContainer();
                    boolean allEqual = ListUtils.allInListEqual(containers);
                    if (allEqual) {
                        containerToUseInManager = containers.get(0).copy(true);
                    }
                    ManageRequirementsScreen s = new ManageRequirementsScreen(containerToUseInManager, call -> {
                        if (call != null) {
                            this.editor.history.saveSnapshot();
                            for (AbstractEditorElement e : selectedElements) {
                                e.element.loadingRequirementContainer = call.copy(true);
                            }
                        }
                        Minecraft.getInstance().setScreen((Screen)this.editor);
                    });
                    if (allEqual) {
                        Minecraft.getInstance().setScreen((Screen)s);
                    } else {
                        Minecraft.getInstance().setScreen((Screen)ConfirmationScreen.ofStrings(call -> {
                            if (call.booleanValue()) {
                                Minecraft.getInstance().setScreen((Screen)s);
                            } else {
                                Minecraft.getInstance().setScreen((Screen)this.editor);
                            }
                        }, LocalizationUtils.splitLocalizedStringLines("fancymenu.elements.multiselect.loading_requirements.warning.override", new String[0])));
                    }
                }
            }).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.requirements.elements.loading_requirements.desc", new String[0])))).setStackable(true)).setIcon(ContextMenu.IconFactory.getIcon("check_list"));
        }
        ((ContextMenu.ClickableContextMenuEntry)this.addToggleContextMenuEntryTo(this.rightClickMenu, "load_once_per_session", AbstractEditorElement.class, consumes -> consumes.element.loadOncePerSession, (element1, aBoolean) -> {
            element1.element.loadOncePerSession = aBoolean;
        }, "fancymenu.elements.element.load_once_per_session").setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.elements.element.load_once_per_session.desc", new String[0])))).setStackable(true);
        this.rightClickMenu.addSeparatorEntry("separator_5");
        if (this.settings.isOrderable()) {
            ((ContextMenu.ClickableContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)this.rightClickMenu.addClickableEntry("move_up_element", (Component)Component.translatable((String)"fancymenu.editor.object.moveup"), (menu, entry) -> {
                this.editor.moveLayerUp(this);
                this.editor.layoutEditorWidgets.forEach(widget -> widget.editorElementOrderChanged(this, true));
            }).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.editor.object.moveup.desc", new String[0])))).setIsActiveSupplier((menu, entry) -> this.editor.canMoveLayerUp(this))).setIcon(ContextMenu.IconFactory.getIcon("arrow_up"));
            ((ContextMenu.ClickableContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)this.rightClickMenu.addClickableEntry("move_down_element", (Component)Component.translatable((String)"fancymenu.editor.object.movedown"), (menu, entry) -> {
                this.editor.moveLayerDown(this);
                this.editor.layoutEditorWidgets.forEach(widget -> widget.editorElementOrderChanged(this, false));
            }).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.editor.object.movedown.desc", new String[0])))).setIsActiveSupplier((menu, entry) -> this.editor.canMoveLayerDown(this))).setIcon(ContextMenu.IconFactory.getIcon("arrow_down"));
        }
        this.rightClickMenu.addSeparatorEntry("separator_6").setStackable(true);
        if (this.settings.isCopyable()) {
            ((ContextMenu.ClickableContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)this.rightClickMenu.addClickableEntry("copy_element", (Component)Component.translatable((String)"fancymenu.editor.edit.copy"), (menu, entry) -> {
                if (!entry.getStackMeta().isPartOfStack()) {
                    this.editor.copyElementsToClipboard(this);
                } else {
                    this.editor.copyElementsToClipboard(this.editor.getSelectedElements().toArray(new AbstractEditorElement[0]));
                }
                menu.closeMenu();
            }).setStackable(true)).setShortcutTextSupplier((menu, entry) -> Component.translatable((String)"fancymenu.editor.shortcuts.copy"))).setIcon(ContextMenu.IconFactory.getIcon("copy"));
        }
        if (this.settings.isDestroyable()) {
            ((ContextMenu.ClickableContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)this.rightClickMenu.addClickableEntry("delete_element", (Component)Component.translatable((String)"fancymenu.elements.delete"), (menu, entry) -> {
                this.editor.history.saveSnapshot();
                for (AbstractEditorElement e : this.editor.getSelectedElements()) {
                    e.deleteElement();
                }
                menu.closeMenu();
            }).setStackable(true)).setShortcutTextSupplier((menu, entry) -> Component.translatable((String)"fancymenu.editor.shortcuts.delete"))).setIcon(ContextMenu.IconFactory.getIcon("delete"));
        }
        this.rightClickMenu.addSeparatorEntry("separator_7").setStackable(true);
        if (this.settings.isDelayable()) {
            ContextMenu appearanceDelayMenu = new ContextMenu();
            ((ContextMenu.SubMenuContextMenuEntry)this.rightClickMenu.addSubMenuEntry("appearance_delay", (Component)Component.translatable((String)"fancymenu.element.general.appearance_delay"), appearanceDelayMenu).setStackable(true)).setIcon(ContextMenu.IconFactory.getIcon("timer"));
            this.addGenericCycleContextMenuEntryTo(appearanceDelayMenu, "appearance_delay_type", ListUtils.of(AbstractElement.AppearanceDelay.NO_DELAY, AbstractElement.AppearanceDelay.FIRST_TIME, AbstractElement.AppearanceDelay.EVERY_TIME), consumes -> consumes.settings.isDelayable(), consumes -> consumes.element.appearanceDelay, (element, switcherValue) -> {
                element.element.appearanceDelay = switcherValue;
            }, (menu, entry, switcherValue) -> Component.translatable((String)("fancymenu.element.general.appearance_delay." + switcherValue.name))).setStackable(true);
            Supplier<Boolean> appearanceDelayIsActive = () -> {
                List<AbstractEditorElement> selected = this.editor.getSelectedElements();
                selected.removeIf(e -> !e.settings.isDelayable());
                if (selected.size() > 1) {
                    return true;
                }
                for (AbstractEditorElement e2 : selected) {
                    if (e2.element.appearanceDelay != AbstractElement.AppearanceDelay.NO_DELAY) continue;
                    return false;
                }
                return true;
            };
            ((ContextMenu.ClickableContextMenuEntry)this.addGenericFloatInputContextMenuEntryTo(appearanceDelayMenu, "appearance_delay_seconds", element -> element.settings.isDelayable(), element -> Float.valueOf(element.element.appearanceDelayInSeconds), (element, input) -> {
                element.element.appearanceDelayInSeconds = input.floatValue();
            }, (Component)Component.translatable((String)"fancymenu.element.general.appearance_delay.seconds"), true, 1.0f, null, null).setIsActiveSupplier((menu, entry) -> (Boolean)appearanceDelayIsActive.get())).setStackable(true);
        }
        if (this.settings.isFadeable()) {
            ContextMenu fadingMenu = new ContextMenu();
            this.rightClickMenu.addSubMenuEntry("fading_in_out", (Component)Component.translatable((String)"fancymenu.element.fading"), fadingMenu).setStackable(true);
            this.addGenericCycleContextMenuEntryTo(fadingMenu, "fade_in", List.of(AbstractElement.Fading.NO_FADING, AbstractElement.Fading.FIRST_TIME, AbstractElement.Fading.EVERY_TIME), consumes -> consumes.settings.isFadeable(), consumes -> consumes.element.fadeIn, (abstractEditorElement, fading) -> {
                abstractEditorElement.element.fadeIn = fading;
            }, (menu, entry, switcherValue) -> {
                if (switcherValue == AbstractElement.Fading.FIRST_TIME) {
                    return Component.translatable((String)"fancymenu.element.fading.fade_in", (Object[])new Object[]{Component.translatable((String)"fancymenu.element.fading.values.first_time").setStyle((Style)LocalizedCycleEnum.WARNING_TEXT_STYLE.get())});
                }
                if (switcherValue == AbstractElement.Fading.EVERY_TIME) {
                    return Component.translatable((String)"fancymenu.element.fading.fade_in", (Object[])new Object[]{Component.translatable((String)"fancymenu.element.fading.values.every_time").setStyle((Style)LocalizedCycleEnum.WARNING_TEXT_STYLE.get())});
                }
                return Component.translatable((String)"fancymenu.element.fading.fade_in", (Object[])new Object[]{Component.translatable((String)"fancymenu.element.fading.values.no_fading").setStyle((Style)LocalizedCycleEnum.WARNING_TEXT_STYLE.get())});
            }).setStackable(true);
            this.addGenericFloatInputContextMenuEntryTo(fadingMenu, "fade_in_speed", consumes -> consumes.settings.isFadeable(), consumes -> Float.valueOf(consumes.element.fadeInSpeed), (abstractEditorElement, aFloat) -> {
                abstractEditorElement.element.fadeInSpeed = aFloat.floatValue();
            }, (Component)Component.translatable((String)"fancymenu.element.fading.fade_in.speed"), true, 1.0f, consumes -> {
                if (MathUtils.isFloat((String)consumes)) {
                    float f = Float.parseFloat(consumes);
                    return f > 0.0f;
                }
                return false;
            }, consumes -> {
                float f;
                if (MathUtils.isFloat((String)consumes) && (f = Float.parseFloat(consumes)) <= 0.0f) {
                    return null;
                }
                return Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.element.fading.error.negative_value", new String[0]));
            }).setStackable(true);
            fadingMenu.addSeparatorEntry("separator_after_fade_in_speed").setStackable(true);
            ((ContextMenu.ClickableContextMenuEntry)this.addGenericCycleContextMenuEntryTo(fadingMenu, "fade_out", List.of(AbstractElement.Fading.NO_FADING, AbstractElement.Fading.FIRST_TIME, AbstractElement.Fading.EVERY_TIME), consumes -> consumes.settings.isFadeable(), consumes -> consumes.element.fadeOut, (abstractEditorElement, fading) -> {
                abstractEditorElement.element.fadeOut = fading;
            }, (menu, entry, switcherValue) -> {
                if (switcherValue == AbstractElement.Fading.FIRST_TIME) {
                    return Component.translatable((String)"fancymenu.element.fading.fade_out", (Object[])new Object[]{Component.translatable((String)"fancymenu.element.fading.values.first_time").setStyle((Style)LocalizedCycleEnum.WARNING_TEXT_STYLE.get())});
                }
                if (switcherValue == AbstractElement.Fading.EVERY_TIME) {
                    return Component.translatable((String)"fancymenu.element.fading.fade_out", (Object[])new Object[]{Component.translatable((String)"fancymenu.element.fading.values.every_time").setStyle((Style)LocalizedCycleEnum.WARNING_TEXT_STYLE.get())});
                }
                return Component.translatable((String)"fancymenu.element.fading.fade_out", (Object[])new Object[]{Component.translatable((String)"fancymenu.element.fading.values.no_fading").setStyle((Style)LocalizedCycleEnum.WARNING_TEXT_STYLE.get())});
            }).setStackable(true)).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.element.fading.fade_out.desc", new String[0])));
            this.addGenericFloatInputContextMenuEntryTo(fadingMenu, "fade_out_speed", consumes -> consumes.settings.isFadeable(), consumes -> Float.valueOf(consumes.element.fadeOutSpeed), (abstractEditorElement, aFloat) -> {
                abstractEditorElement.element.fadeOutSpeed = aFloat.floatValue();
            }, (Component)Component.translatable((String)"fancymenu.element.fading.fade_out.speed"), true, 1.0f, consumes -> {
                if (MathUtils.isFloat((String)consumes)) {
                    float f = Float.parseFloat(consumes);
                    return f > 0.0f;
                }
                return false;
            }, consumes -> {
                float f;
                if (MathUtils.isFloat((String)consumes) && (f = Float.parseFloat(consumes)) <= 0.0f) {
                    return null;
                }
                return Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.element.fading.error.negative_value", new String[0]));
            }).setStackable(true);
        }
        if (this.settings.isOpacityChangeable()) {
            ((ContextMenu.ClickableContextMenuEntry)this.addGenericStringInputContextMenuEntryTo(this.rightClickMenu, "base_opacity", consumes -> consumes.settings.isOpacityChangeable(), consumes -> consumes.element.baseOpacity, (abstractEditorElement, s) -> {
                abstractEditorElement.element.baseOpacity = s;
            }, null, false, true, (Component)Component.translatable((String)"fancymenu.element.base_opacity"), true, "1.0", null, null).setStackable(true)).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.element.base_opacity.desc", new String[0])));
        }
        if (this.settings.isAutoSizingAllowed()) {
            ((ContextMenu.ClickableContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)this.addToggleContextMenuEntryTo(this.rightClickMenu, "auto_sizing", AbstractEditorElement.class, consumes -> consumes.element.autoSizing, (abstractEditorElement, aBoolean) -> {
                abstractEditorElement.element.setAutoSizingBaseWidthAndHeight();
                abstractEditorElement.element.autoSizing = aBoolean;
                abstractEditorElement.element.updateAutoSizing(true);
            }, "fancymenu.element.auto_sizing").setStackable(true)).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.element.auto_sizing.desc", new String[0])))).setIcon(ContextMenu.IconFactory.getIcon("measure"));
        }
        if (this.settings.isStickyAnchorAllowed()) {
            ((ContextMenu.ContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)this.addToggleContextMenuEntryTo(this.rightClickMenu, "sticky_anchor", AbstractEditorElement.class, consumes -> consumes.element.stickyAnchor, (abstractEditorElement, aBoolean) -> {
                int oldPosX = abstractEditorElement.element.getAbsoluteX();
                int oldPosY = abstractEditorElement.element.getAbsoluteY();
                abstractEditorElement.element.stickyAnchor = aBoolean;
                int newPosX = abstractEditorElement.element.getAbsoluteX();
                int newPosY = abstractEditorElement.element.getAbsoluteY();
                abstractEditorElement.element.posOffsetX += oldPosX - newPosX;
                abstractEditorElement.element.posOffsetY += oldPosY - newPosY;
            }, "fancymenu.element.sticky_anchor").setStackable(false)).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines(!this.element.stayOnScreen ? "fancymenu.element.sticky_anchor.desc" : "fancymenu.element.sticky_anchor.desc.disable_stay_on_screen", new String[0])))).setIcon(ContextMenu.IconFactory.getIcon("anchor"))).addIsActiveSupplier((menu, entry) -> !this.element.stayOnScreen);
        }
        if (this.element.supportsRotation()) {
            this.rightClickMenu.addSeparatorEntry("separator_before_rotation").setStackable(true);
            ((ContextMenu.ContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)this.addToggleContextMenuEntryTo(this.rightClickMenu, "advanced_rotation_mode", AbstractEditorElement.class, consumes -> consumes.element.advancedRotationMode, (abstractEditorElement, aBoolean) -> {
                abstractEditorElement.element.advancedRotationMode = aBoolean;
            }, "fancymenu.element.rotation.advanced_mode").setStackable(false)).setIcon(ContextMenu.IconFactory.getIcon("reload"))).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.element.rotation.advanced_mode.desc", new String[0])));
            ((ContextMenu.ContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)this.addFloatInputContextMenuEntryTo(this.rightClickMenu, "rotation_degrees", AbstractEditorElement.class, consumes -> Float.valueOf(consumes.element.rotationDegrees), (abstractEditorElement, aFloat) -> {
                abstractEditorElement.element.rotationDegrees = aFloat.floatValue();
            }, (Component)Component.translatable((String)"fancymenu.element.rotation.degrees"), true, 0.0f, null, null).setStackable(false)).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.element.rotation.degrees.desc", new String[0])))).setIcon(ContextMenu.IconFactory.getIcon("reload"))).addIsVisibleSupplier((menu, entry) -> !this.element.advancedRotationMode);
            ((ContextMenu.ContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)this.addStringInputContextMenuEntryTo(this.rightClickMenu, "rotation_degrees_advanced", AbstractEditorElement.class, consumes -> consumes.element.advancedRotationDegrees, (abstractEditorElement, s) -> {
                abstractEditorElement.element.advancedRotationDegrees = s;
            }, null, false, true, (Component)Component.translatable((String)"fancymenu.element.rotation.degrees"), true, null, null, null).setStackable(false)).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.element.rotation.degrees.desc", new String[0])))).setIcon(ContextMenu.IconFactory.getIcon("reload"))).addIsVisibleSupplier((menu, entry) -> this.element.advancedRotationMode);
        }
        if (this.element.supportsTilting()) {
            this.rightClickMenu.addSeparatorEntry("separator_before_tilting").setStackable(true);
            ((ContextMenu.ContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)this.addToggleContextMenuEntryTo(this.rightClickMenu, "advanced_vertical_tilt_mode", AbstractEditorElement.class, consumes -> consumes.element.advancedVerticalTiltMode, (abstractEditorElement, aBoolean) -> {
                abstractEditorElement.element.advancedVerticalTiltMode = aBoolean;
            }, "fancymenu.element.tilt.vertical.advanced_mode").setStackable(false)).setIcon(ContextMenu.IconFactory.getIcon("arrow_vertical"))).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.element.tilt.vertical.advanced_mode.desc", new String[0])));
            ((ContextMenu.ContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)this.addFloatInputContextMenuEntryTo(this.rightClickMenu, "vertical_tilt_degrees", AbstractEditorElement.class, consumes -> Float.valueOf(consumes.element.verticalTiltDegrees), (abstractEditorElement, aFloat) -> {
                abstractEditorElement.element.verticalTiltDegrees = Math.max(-60.0f, Math.min(60.0f, aFloat.floatValue()));
            }, (Component)Component.translatable((String)"fancymenu.element.tilt.vertical.degrees"), true, 0.0f, null, null).setStackable(false)).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.element.tilt.vertical.degrees.desc", new String[0])))).setIcon(ContextMenu.IconFactory.getIcon("arrow_vertical"))).addIsVisibleSupplier((menu, entry) -> !this.element.advancedVerticalTiltMode);
            ((ContextMenu.ContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)this.addStringInputContextMenuEntryTo(this.rightClickMenu, "vertical_tilt_degrees_advanced", AbstractEditorElement.class, consumes -> consumes.element.advancedVerticalTiltDegrees, (abstractEditorElement, s) -> {
                abstractEditorElement.element.advancedVerticalTiltDegrees = s;
            }, null, false, true, (Component)Component.translatable((String)"fancymenu.element.tilt.vertical.degrees"), true, null, null, null).setStackable(false)).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.element.tilt.vertical.degrees.desc", new String[0])))).setIcon(ContextMenu.IconFactory.getIcon("arrow_vertical"))).addIsVisibleSupplier((menu, entry) -> this.element.advancedVerticalTiltMode);
            ((ContextMenu.ContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)this.addToggleContextMenuEntryTo(this.rightClickMenu, "advanced_horizontal_tilt_mode", AbstractEditorElement.class, consumes -> consumes.element.advancedHorizontalTiltMode, (abstractEditorElement, aBoolean) -> {
                abstractEditorElement.element.advancedHorizontalTiltMode = aBoolean;
            }, "fancymenu.element.tilt.horizontal.advanced_mode").setStackable(false)).setIcon(ContextMenu.IconFactory.getIcon("arrow_horizontal"))).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.element.tilt.horizontal.advanced_mode.desc", new String[0])));
            ((ContextMenu.ContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)this.addFloatInputContextMenuEntryTo(this.rightClickMenu, "horizontal_tilt_degrees", AbstractEditorElement.class, consumes -> Float.valueOf(consumes.element.horizontalTiltDegrees), (abstractEditorElement, aFloat) -> {
                abstractEditorElement.element.horizontalTiltDegrees = Math.max(-60.0f, Math.min(60.0f, aFloat.floatValue()));
            }, (Component)Component.translatable((String)"fancymenu.element.tilt.horizontal.degrees"), true, 0.0f, null, null).setStackable(false)).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.element.tilt.horizontal.degrees.desc", new String[0])))).setIcon(ContextMenu.IconFactory.getIcon("arrow_horizontal"))).addIsVisibleSupplier((menu, entry) -> !this.element.advancedHorizontalTiltMode);
            ((ContextMenu.ContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)this.addStringInputContextMenuEntryTo(this.rightClickMenu, "horizontal_tilt_degrees_advanced", AbstractEditorElement.class, consumes -> consumes.element.advancedHorizontalTiltDegrees, (abstractEditorElement, s) -> {
                abstractEditorElement.element.advancedHorizontalTiltDegrees = s;
            }, null, false, true, (Component)Component.translatable((String)"fancymenu.element.tilt.horizontal.degrees"), true, null, null, null).setStackable(false)).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.element.tilt.horizontal.degrees.desc", new String[0])))).setIcon(ContextMenu.IconFactory.getIcon("arrow_horizontal"))).addIsVisibleSupplier((menu, entry) -> this.element.advancedHorizontalTiltMode);
        }
        if (this.settings.isParallaxAllowed()) {
            this.rightClickMenu.addSeparatorEntry("separator_before_parallax").setStackable(true);
            this.addToggleContextMenuEntryTo(this.rightClickMenu, "enable_parallax", AbstractEditorElement.class, consumes -> consumes.element.enableParallax, (abstractEditorElement, aBoolean) -> {
                abstractEditorElement.element.enableParallax = aBoolean;
            }, "fancymenu.elements.parallax").setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.elements.parallax.desc", new String[0])));
            this.addStringInputContextMenuEntryTo(this.rightClickMenu, "parallax_intensity", AbstractEditorElement.class, consumes -> consumes.element.parallaxIntensityString, (element1, s) -> {
                element1.element.parallaxIntensityString = s;
            }, null, false, true, (Component)Component.translatable((String)"fancymenu.elements.parallax.intensity"), true, "0.5", null, null).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.elements.parallax.intensity.desc", new String[0])));
            this.addToggleContextMenuEntryTo(this.rightClickMenu, "invert_parallax", AbstractEditorElement.class, consumes -> consumes.element.invertParallax, (abstractEditorElement, aBoolean) -> {
                abstractEditorElement.element.invertParallax = aBoolean;
            }, "fancymenu.elements.parallax.invert").setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.elements.parallax.invert.desc", new String[0])));
        }
        this.rightClickMenu.addSeparatorEntry("separator_8").setStackable(true);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        HorizontalTiltGrabber hoveredHorizontalTiltGrabber;
        VerticalTiltGrabber hoveredVerticalTiltGrabber;
        RotationGrabber hoveredRotationGrabber;
        if (this.element.layerHiddenInEditor) {
            if (this.rightClickMenu.isOpen()) {
                this.rightClickMenu.closeMenu();
            }
            return;
        }
        this.tick();
        this.hovered = this.isMouseOver(mouseX, mouseY);
        this.element.renderInternal(graphics, mouseX, mouseY, partial);
        this.renderDraggingNotAllowedOverlay(graphics);
        this.renderDeprecatedIndicator(graphics);
        ResizeGrabber hoveredGrabber = this.getHoveredResizeGrabber();
        if (hoveredGrabber != null) {
            CursorHandler.setClientTickCursor(hoveredGrabber.getCursor());
        }
        if ((hoveredRotationGrabber = this.getHoveredRotationGrabber()) != null) {
            CursorHandler.setClientTickCursor(CursorHandler.CURSOR_RESIZE_ALL);
        }
        if ((hoveredVerticalTiltGrabber = this.getHoveredVerticalTiltGrabber()) != null) {
            CursorHandler.setClientTickCursor(CursorHandler.CURSOR_RESIZE_VERTICAL);
        }
        if ((hoveredHorizontalTiltGrabber = this.getHoveredHorizontalTiltGrabber()) != null) {
            CursorHandler.setClientTickCursor(CursorHandler.CURSOR_RESIZE_HORIZONTAL);
        }
        this.renderBorder(graphics, mouseX, mouseY, partial);
    }

    protected void tick() {
        boolean shouldShowHorizontalTilt;
        boolean shouldShowVerticalTilt;
        boolean shouldShowRotation;
        if (this.element.advancedWidth != null || this.element.advancedHeight != null && !this.topLeftDisplay.hasLine("advanced_sizing_enabled")) {
            this.topLeftDisplay.addLine("advanced_sizing_enabled", () -> Component.translatable((String)"fancymenu.elements.advanced_sizing.enabled_notification"));
        }
        if (this.element.advancedWidth == null && this.element.advancedHeight == null && this.topLeftDisplay.hasLine("advanced_sizing_enabled")) {
            this.topLeftDisplay.removeLine("advanced_sizing_enabled");
        }
        if (this.element.advancedX != null || this.element.advancedY != null && !this.topLeftDisplay.hasLine("advanced_positioning_enabled")) {
            this.topLeftDisplay.addLine("advanced_positioning_enabled", () -> Component.translatable((String)"fancymenu.elements.advanced_positioning.enabled_notification"));
        }
        if (this.element.advancedX == null && this.element.advancedY == null && this.topLeftDisplay.hasLine("advanced_positioning_enabled")) {
            this.topLeftDisplay.removeLine("advanced_positioning_enabled");
        }
        boolean bl = shouldShowRotation = this.element.supportsRotation() && this.element.getRotationDegrees() != 0.0f;
        if (shouldShowRotation && !this.topLeftDisplay.hasLine("rotation")) {
            this.topLeftDisplay.addLine("rotation", () -> Component.translatable((String)"fancymenu.element.border_display.rotation", (Object[])new Object[]{String.format("%.1f", Float.valueOf(this.element.getRotationDegrees()))}));
        } else if (!shouldShowRotation && this.topLeftDisplay.hasLine("rotation")) {
            this.topLeftDisplay.removeLine("rotation");
        }
        boolean bl2 = shouldShowVerticalTilt = this.element.supportsTilting() && this.element.getVerticalTiltDegrees() != 0.0f;
        if (shouldShowVerticalTilt && !this.topLeftDisplay.hasLine("vertical_tilt")) {
            this.topLeftDisplay.addLine("vertical_tilt", () -> Component.translatable((String)"fancymenu.element.border_display.vertical_tilt", (Object[])new Object[]{String.format("%.1f", Float.valueOf(this.element.getVerticalTiltDegrees()))}));
        } else if (!shouldShowVerticalTilt && this.topLeftDisplay.hasLine("vertical_tilt")) {
            this.topLeftDisplay.removeLine("vertical_tilt");
        }
        boolean bl3 = shouldShowHorizontalTilt = this.element.supportsTilting() && this.element.getHorizontalTiltDegrees() != 0.0f;
        if (shouldShowHorizontalTilt && !this.topLeftDisplay.hasLine("horizontal_tilt")) {
            this.topLeftDisplay.addLine("horizontal_tilt", () -> Component.translatable((String)"fancymenu.element.border_display.horizontal_tilt", (Object[])new Object[]{String.format("%.1f", Float.valueOf(this.element.getHorizontalTiltDegrees()))}));
        } else if (!shouldShowHorizontalTilt && this.topLeftDisplay.hasLine("horizontal_tilt")) {
            this.topLeftDisplay.removeLine("horizontal_tilt");
        }
    }

    protected void renderDraggingNotAllowedOverlay(GuiGraphics graphics) {
        if (this.renderMovingNotAllowedTime >= System.currentTimeMillis()) {
            RenderSystem.enableBlend();
            graphics.fill(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), UIBase.getUIColorTheme().layout_editor_element_dragging_not_allowed_color.getColorInt());
            AspectRatio ratio = new AspectRatio(32, 32);
            int[] size = ratio.getAspectRatioSizeByMaximumSize(this.getWidth(), this.getHeight());
            int texW = size[0];
            int texH = size[1];
            int texX = this.getX() + this.getWidth() / 2 - texW / 2;
            int texY = this.getY() + this.getHeight() / 2 - texH / 2;
            graphics.blit(DRAGGING_NOT_ALLOWED_TEXTURE, texX, texY, 0.0f, 0.0f, texW, texH, texW, texH);
        }
    }

    protected void renderDeprecatedIndicator(GuiGraphics graphics) {
        if (this.element.builder.isDeprecated()) {
            RenderSystem.enableBlend();
            AspectRatio ratio = new AspectRatio(32, 32);
            int[] size = ratio.getAspectRatioSizeByMaximumSize(this.getWidth() / 3, this.getHeight() / 3);
            int texW = size[0];
            int texH = size[1];
            int texX = this.getX() + this.getWidth() - texW;
            int texY = this.getY();
            UIBase.setShaderColor(graphics, UIBase.getUIColorTheme().warning_text_color);
            graphics.blit(DEPRECATED_WARNING_TEXTURE, texX, texY, 0.0f, 0.0f, texW, texH, texW, texH);
            RenderingUtils.resetShaderColor(graphics);
        }
    }

    protected void renderBorder(GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        RenderSystem.disableDepthTest();
        RenderingUtils.setDepthTestLocked(true);
        if (this.editor.getTopHoveredElement() == this && !this.editor.isUserNavigatingInRightClickMenu() && !this.editor.isUserNavigatingInElementMenu() || this.isSelected() || this.isMultiSelected()) {
            graphics.fill(this.getX() + 1, this.getY(), this.getX() + this.getWidth() - 1, this.getY() + 1, BORDER_COLOR.get(this).intValue());
            graphics.fill(this.getX() + 1, this.getY() + this.getHeight() - 1, this.getX() + this.getWidth() - 1, this.getY() + this.getHeight(), BORDER_COLOR.get(this).intValue());
            graphics.fill(this.getX(), this.getY(), this.getX() + 1, this.getY() + this.getHeight(), BORDER_COLOR.get(this).intValue());
            graphics.fill(this.getX() + this.getWidth() - 1, this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), BORDER_COLOR.get(this).intValue());
            for (ResizeGrabber g : this.resizeGrabbers) {
                g.render(graphics, mouseX, mouseY, partial);
            }
            if (this.isSelected() && this.element.supportsRotation() && !this.element.advancedRotationMode && !this.isMultiSelected()) {
                this.renderRotationControls(graphics, mouseX, mouseY, partial);
            }
            if (this.isSelected() && this.element.supportsTilting() && !this.isMultiSelected()) {
                this.renderTiltControls(graphics, mouseX, mouseY, partial);
            }
        }
        if (this.isSelected()) {
            this.topLeftDisplay.render(graphics, mouseX, mouseY, partial);
            this.bottomRightDisplay.render(graphics, mouseX, mouseY, partial);
        }
        RenderingUtils.setDepthTestLocked(false);
        RenderSystem.enableDepthTest();
    }

    protected void renderRotationControls(GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (!FancyMenu.getOptions().enableElementRotationControls.getValue().booleanValue()) {
            return;
        }
        float centerX = (float)this.getX() + (float)this.getWidth() / 2.0f;
        float centerY = (float)this.getY() + (float)this.getHeight() / 2.0f;
        float halfWidth = (float)this.getWidth() / 2.0f;
        float halfHeight = (float)this.getHeight() / 2.0f;
        float radius = (float)Math.sqrt(halfWidth * halfWidth + halfHeight * halfHeight) + 8.0f;
        int points = 360;
        int circleColor = UIBase.getUIColorTheme().layout_editor_element_border_rotation_controls_color.getColorIntWithAlpha(ROTATION_CONTROLS_ALPHA.get(this).floatValue());
        for (int i = 0; i < points; ++i) {
            float angle = (float)((double)(i * 2) * Math.PI / (double)points);
            int x = Math.round(centerX + radius * (float)Math.cos(angle));
            int y = Math.round(centerY + radius * (float)Math.sin(angle));
            graphics.fill(x, y, x + 1, y + 1, circleColor);
        }
        this.rotationGrabber.render(graphics, mouseX, mouseY, partial);
    }

    protected void renderTiltControls(GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (!FancyMenu.getOptions().enableElementTiltingControls.getValue().booleanValue()) {
            return;
        }
        float centerX = (float)this.getX() + (float)this.getWidth() / 2.0f;
        float centerY = (float)this.getY() + (float)this.getHeight() / 2.0f;
        int lineExtension = 20;
        if (!this.element.advancedVerticalTiltMode) {
            int verticalLineX = (int)centerX + 8;
            int verticalLineTop = this.getY() - 20;
            int verticalLineBottom = this.getY() + this.getHeight() + 20;
            graphics.fill(verticalLineX, verticalLineTop, verticalLineX + 1, verticalLineBottom, UIBase.getUIColorTheme().layout_editor_element_border_vertical_tilting_controls_color.getColorIntWithAlpha(VERTICAL_TILT_CONTROLS_ALPHA.get(this).floatValue()));
        }
        if (!this.element.advancedHorizontalTiltMode) {
            int horizontalLineY = (int)centerY + 8;
            int horizontalLineLeft = this.getX() - 20;
            int horizontalLineRight = this.getX() + this.getWidth() + 20;
            graphics.fill(horizontalLineLeft, horizontalLineY, horizontalLineRight, horizontalLineY + 1, UIBase.getUIColorTheme().layout_editor_element_border_horizontal_tilting_controls_color.getColorIntWithAlpha(HORIZONTAL_TILT_CONTROLS_ALPHA.get(this).floatValue()));
        }
        if (!this.element.advancedVerticalTiltMode) {
            this.verticalTiltGrabber.render(graphics, mouseX, mouseY, partial);
        }
        if (!this.element.advancedVerticalTiltMode) {
            this.horizontalTiltGrabber.render(graphics, mouseX, mouseY, partial);
        }
    }

    public void setAnchorPoint(ElementAnchorPoint newAnchor, boolean resetElementStates) {
        int oldAbsX = this.element.getAbsoluteX();
        int oldAbsY = this.element.getAbsoluteY();
        this.setAnchorPoint(newAnchor, oldAbsX, oldAbsY, resetElementStates);
    }

    public void setAnchorPoint(ElementAnchorPoint newAnchor, int oldAbsX, int oldAbsY, boolean resetElementStates) {
        if (!this.settings.isAnchorPointChangeable()) {
            return;
        }
        if (newAnchor == ElementAnchorPoints.ELEMENT && !this.settings.isElementAnchorPointAllowed()) {
            return;
        }
        if (newAnchor == ElementAnchorPoints.ELEMENT && this.element.getAnchorPointElementIdentifier() == null) {
            LOGGER.error("[FANCYMENU] Failed to set element's anchor to anchor point type 'ELEMENT'! Identifier was NULL!", (Throwable)new NullPointerException());
            return;
        }
        boolean stayOnScreen = this.element.stayOnScreen;
        this.element.stayOnScreen = false;
        if (resetElementStates) {
            this.resetElementStates();
        }
        if (newAnchor == null) {
            newAnchor = ElementAnchorPoints.MID_CENTERED;
        }
        if (newAnchor == ElementAnchorPoints.ELEMENT) {
            AbstractEditorElement ee = this.editor.getElementByInstanceIdentifier(Objects.requireNonNull(this.element.getAnchorPointElementIdentifier()));
            if (ee != null) {
                this.element.setElementAnchorPointParent(ee.element);
            } else {
                this.element.setElementAnchorPointParent(null);
                LOGGER.error("[FANCYMENU] Failed to get parent element for 'ELEMENT' anchor type! Element was NULL!", (Throwable)new NullPointerException());
            }
        } else {
            this.element.setAnchorPointElementIdentifier(null);
            this.element.setElementAnchorPointParent(null);
        }
        this.element.anchorPoint = newAnchor;
        int newAbsX = this.element.getAbsoluteX();
        int newAbsY = this.element.getAbsoluteY();
        this.element.posOffsetX += oldAbsX - newAbsX;
        this.element.posOffsetY += oldAbsY - newAbsY;
        this.element.stayOnScreen = stayOnScreen;
    }

    @ApiStatus.Internal
    public void setAnchorPointViaOverlay(AnchorPointOverlay.AnchorPointArea anchor, int mouseX, int mouseY) {
        if (!this.settings.isAnchorPointChangeable()) {
            return;
        }
        if (anchor.anchorPoint == ElementAnchorPoints.ELEMENT && !this.settings.isElementAnchorPointAllowed()) {
            return;
        }
        if (anchor instanceof AnchorPointOverlay.ElementAnchorPointArea) {
            AnchorPointOverlay.ElementAnchorPointArea ea = (AnchorPointOverlay.ElementAnchorPointArea)anchor;
            this.element.setAnchorPointElementIdentifier(ea.elementIdentifier);
        }
        this.setAnchorPoint(anchor.anchorPoint, false);
        this.updateLeftMouseDownCachedValues(mouseX, mouseY);
        this.updateMovingStartPos(mouseX, mouseY);
    }

    public void resetElementStates() {
        this.selected = false;
        this.multiSelected = false;
        this.leftMouseDown = false;
        this.activeResizeGrabber = null;
        this.rotationGrabberActive = false;
        this.verticalTiltGrabberActive = false;
        this.horizontalTiltGrabberActive = false;
        this.rightClickMenu.closeMenu();
    }

    public void onSettingsChanged() {
        this.resetElementStates();
        this.init();
    }

    public void updateLeftMouseDownCachedValues(int mouseX, int mouseY) {
        this.leftMouseDownMouseX = mouseX;
        this.leftMouseDownMouseY = mouseY;
        this.leftMouseDownBaseX = this.element.posOffsetX;
        this.leftMouseDownBaseY = this.element.posOffsetY;
        this.leftMouseDownBaseWidth = this.element.baseWidth;
        this.leftMouseDownBaseHeight = this.element.baseHeight;
    }

    public void updateMovingStartPos(int mouseX, int mouseY) {
        this.movingStartPosX = mouseX;
        this.movingStartPosY = mouseY;
    }

    public void updateResizingStartPos(int mouseX, int mouseY) {
        this.resizingStartPosX = mouseX;
        this.resizingStartPosY = mouseY;
    }

    public boolean isElementAnchorAndParentIsSelected() {
        if (this.element.anchorPoint != ElementAnchorPoints.ELEMENT) {
            return false;
        }
        if (this.element.getAnchorPointElementIdentifier() == null) {
            return false;
        }
        AbstractEditorElement parent = this.editor.getElementByInstanceIdentifier(this.element.getAnchorPointElementIdentifier());
        if (parent == null) {
            return false;
        }
        return parent.isSelected() || parent.isMultiSelected();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.element.layerHiddenInEditor) {
            return false;
        }
        if (!this.isSelected()) {
            return false;
        }
        if (button == 0 && !this.rightClickMenu.isUserNavigatingInMenu()) {
            this.activeResizeGrabber = !this.isMultiSelected() ? this.getHoveredResizeGrabber() : null;
            this.rotationGrabberActive = !this.isMultiSelected() && this.getHoveredRotationGrabber() != null;
            this.verticalTiltGrabberActive = !this.isMultiSelected() && this.getHoveredVerticalTiltGrabber() != null;
            boolean bl = this.horizontalTiltGrabberActive = !this.isMultiSelected() && this.getHoveredHorizontalTiltGrabber() != null;
            if (this.isHovered() || this.isMultiSelected() && !this.editor.getHoveredElements().isEmpty() || this.isGettingResized() || this.isGettingRotated() || this.isGettingTilted()) {
                this.leftMouseDown = true;
                this.updateLeftMouseDownCachedValues((int)mouseX, (int)mouseY);
                this.resizeAspectRatio = new AspectRatio(this.getWidth(), this.getHeight());
                if (this.rotationGrabberActive) {
                    this.preRotationSnapshot = this.editor.history.createSnapshot();
                    this.rotationStartAngle = this.element.rotationDegrees;
                    float centerX = (float)this.getX() + (float)this.getWidth() / 2.0f;
                    float centerY = (float)this.getY() + (float)this.getHeight() / 2.0f;
                    this.rotationStartMouseAngle = Math.toDegrees(Math.atan2(mouseY - (double)centerY, mouseX - (double)centerX));
                }
                if (this.verticalTiltGrabberActive) {
                    this.preTiltSnapshot = this.editor.history.createSnapshot();
                    this.verticalTiltStartAngle = this.element.verticalTiltDegrees;
                    this.verticalTiltStartMouseY = mouseY;
                }
                if (this.horizontalTiltGrabberActive) {
                    this.preTiltSnapshot = this.editor.history.createSnapshot();
                    this.horizontalTiltStartAngle = this.element.horizontalTiltDegrees;
                    this.horizontalTiltStartMouseX = mouseX;
                }
                if (this.element.autoSizingWidth > 0) {
                    this.element.baseWidth = this.element.autoSizingWidth;
                }
                if (this.element.autoSizingHeight > 0) {
                    this.element.baseHeight = this.element.autoSizingHeight;
                }
                this.element.setAutoSizingBaseWidthAndHeight();
                this.element.updateAutoSizing(true);
                this.element.autoSizingWidth = 0;
                this.element.autoSizingHeight = 0;
            }
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.leftMouseDown = false;
            this.activeResizeGrabber = null;
            if (this.isGettingRotated() && this.preRotationSnapshot != null && this.rotationStartAngle != this.element.rotationDegrees) {
                this.editor.history.saveSnapshot(this.preRotationSnapshot);
            }
            if ((this.isGettingVerticalTilted() || this.isGettingHorizontalTilted()) && this.preTiltSnapshot != null && (this.verticalTiltStartAngle != this.element.verticalTiltDegrees || this.horizontalTiltStartAngle != this.element.horizontalTiltDegrees)) {
                this.editor.history.saveSnapshot(this.preTiltSnapshot);
            }
            this.preRotationSnapshot = null;
            this.preTiltSnapshot = null;
            this.rotationGrabberActive = false;
            this.verticalTiltGrabberActive = false;
            this.horizontalTiltGrabberActive = false;
            this.element.updateAutoSizing(true);
            this.recentlyMovedByDragging = false;
            this.recentlyResized = false;
            this.movingCrumpleZonePassed = false;
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.element.layerHiddenInEditor) {
            return false;
        }
        if (!this.isSelected()) {
            return false;
        }
        if (button == 0) {
            if (this.leftMouseDown && this.isGettingRotated()) {
                float centerX = (float)this.getX() + (float)this.getWidth() / 2.0f;
                float centerY = (float)this.getY() + (float)this.getHeight() / 2.0f;
                double currentMouseAngle = Math.toDegrees(Math.atan2(mouseY - (double)centerY, mouseX - (double)centerX));
                double angleDiff = currentMouseAngle - this.rotationStartMouseAngle;
                float newRotation = (float)((double)this.rotationStartAngle + angleDiff);
                if (Screen.hasShiftDown()) {
                    newRotation = (float)Math.round(newRotation / 45.0f) * 45.0f;
                }
                while (newRotation < 0.0f) {
                    newRotation += 360.0f;
                }
                while (newRotation >= 360.0f) {
                    newRotation -= 360.0f;
                }
                this.element.rotationDegrees = newRotation;
            } else if (this.leftMouseDown && this.isGettingVerticalTilted()) {
                double mouseDiff = mouseY - this.verticalTiltStartMouseY;
                float tiltChange = (float)(mouseDiff * 0.5);
                float newTilt = this.verticalTiltStartAngle + tiltChange;
                newTilt = Math.max(-60.0f, Math.min(60.0f, newTilt));
                if (Screen.hasShiftDown()) {
                    newTilt = (float)Math.round(newTilt / 15.0f) * 15.0f;
                }
                this.element.verticalTiltDegrees = newTilt;
            } else if (this.leftMouseDown && this.isGettingHorizontalTilted()) {
                double mouseDiff = mouseX - this.horizontalTiltStartMouseX;
                float tiltChange = (float)(mouseDiff * 0.5);
                float newTilt = this.horizontalTiltStartAngle + tiltChange;
                newTilt = Math.max(-60.0f, Math.min(60.0f, newTilt));
                if (Screen.hasShiftDown()) {
                    newTilt = (float)Math.round(newTilt / 15.0f) * 15.0f;
                }
                this.element.horizontalTiltDegrees = newTilt;
            } else if (this.leftMouseDown && !this.isGettingResized() && this.movingCrumpleZonePassed) {
                int diffX = (int)(-((double)this.movingStartPosX - mouseX));
                int diffY = (int)(-((double)this.movingStartPosY - mouseY));
                if (this.editor.allSelectedElementsMovable()) {
                    if (!this.isMultiSelected() || !this.isElementAnchorAndParentIsSelected()) {
                        int newOffsetX = this.leftMouseDownBaseX + diffX;
                        int newOffsetY = this.leftMouseDownBaseY + diffY;
                        if (this.element.stayOnScreen && !this.element.stickyAnchor) {
                            int oldPosOffsetX = this.element.posOffsetX;
                            int oldPosOffsetY = this.element.posOffsetY;
                            this.element.posOffsetX = newOffsetX;
                            this.element.posOffsetY = newOffsetY;
                            int absoluteX = this.element.getAbsoluteX();
                            int absoluteY = this.element.getAbsoluteY();
                            this.element.posOffsetX = oldPosOffsetX;
                            this.element.posOffsetY = oldPosOffsetY;
                            int leftEdge = 2;
                            int rightEdge = AbstractElement.getScreenWidth() - 2 - this.element.getAbsoluteWidth();
                            if (absoluteX <= leftEdge && diffX < 0) {
                                newOffsetX = this.element.posOffsetX;
                            } else if (absoluteX >= rightEdge && diffX > 0) {
                                newOffsetX = this.element.posOffsetX;
                            }
                            int topEdge = 2;
                            int bottomEdge = AbstractElement.getScreenHeight() - 2 - this.element.getAbsoluteHeight();
                            if (absoluteY <= topEdge && diffY < 0) {
                                newOffsetY = this.element.posOffsetY;
                            } else if (absoluteY >= bottomEdge && diffY > 0) {
                                newOffsetY = this.element.posOffsetY;
                            }
                        }
                        this.element.posOffsetX = newOffsetX;
                        this.element.posOffsetY = newOffsetY;
                        if (FancyMenu.getOptions().showLayoutEditorGrid.getValue().booleanValue() && FancyMenu.getOptions().layoutEditorGridSnapping.getValue().booleanValue() && !this.isMultiSelected()) {
                            int closestEdgeIndexY;
                            int closestEdgeIndexX;
                            int leftEdge = this.getX();
                            int rightEdge = leftEdge + this.getWidth();
                            int topEdge = this.getY();
                            int bottomEdge = topEdge + this.getHeight();
                            double guiScale = Minecraft.getInstance().getWindow().getGuiScale();
                            int gridSize = FancyMenu.getOptions().layoutEditorGridSize.getValue();
                            double snapThreshold = Math.max(2.0 * guiScale, (double)gridSize / 5.0) * (double)FancyMenu.getOptions().layoutEditorGridSnappingStrength.getValue().floatValue();
                            double centerXInGridSpace = (double)AbstractElement.getScreenWidth() * guiScale / 2.0;
                            double centerYInGridSpace = (double)AbstractElement.getScreenHeight() * guiScale / 2.0;
                            double[] edgesX = new double[]{(double)leftEdge * guiScale, (double)rightEdge * guiScale};
                            double[] distancesToGridX = new double[2];
                            int[] nearestGridLinesX = new int[2];
                            for (int i = 0; i < 2; ++i) {
                                double distToUpper;
                                double edgeInGridSpace = edgesX[i];
                                double offsetFromCenter = edgeInGridSpace - centerXInGridSpace;
                                double modX = offsetFromCenter % (double)gridSize;
                                if (modX < 0.0) {
                                    modX += (double)gridSize;
                                }
                                double nearestLowerGridXInGridSpace = edgeInGridSpace - modX;
                                double nearestUpperGridXInGridSpace = nearestLowerGridXInGridSpace + (double)gridSize;
                                double distToLower = Math.abs(edgeInGridSpace - nearestLowerGridXInGridSpace);
                                if (distToLower <= (distToUpper = Math.abs(nearestUpperGridXInGridSpace - edgeInGridSpace))) {
                                    distancesToGridX[i] = distToLower;
                                    nearestGridLinesX[i] = (int)(nearestLowerGridXInGridSpace / guiScale);
                                    continue;
                                }
                                distancesToGridX[i] = distToUpper;
                                nearestGridLinesX[i] = (int)(nearestUpperGridXInGridSpace / guiScale);
                            }
                            int n = closestEdgeIndexX = distancesToGridX[0] <= distancesToGridX[1] ? 0 : 1;
                            if (distancesToGridX[closestEdgeIndexX] <= snapThreshold) {
                                int edgePos = closestEdgeIndexX == 0 ? leftEdge : rightEdge;
                                int gridPos = nearestGridLinesX[closestEdgeIndexX];
                                int xAdjustment = gridPos - edgePos;
                                this.element.posOffsetX += xAdjustment;
                            }
                            double[] edgesY = new double[]{(double)topEdge * guiScale, (double)bottomEdge * guiScale};
                            double[] distancesToGridY = new double[2];
                            int[] nearestGridLinesY = new int[2];
                            for (int i = 0; i < 2; ++i) {
                                double distToUpper;
                                double edgeInGridSpace = edgesY[i];
                                double offsetFromCenter = edgeInGridSpace - centerYInGridSpace;
                                double modY = offsetFromCenter % (double)gridSize;
                                if (modY < 0.0) {
                                    modY += (double)gridSize;
                                }
                                double nearestLowerGridYInGridSpace = edgeInGridSpace - modY;
                                double nearestUpperGridYInGridSpace = nearestLowerGridYInGridSpace + (double)gridSize;
                                double distToLower = Math.abs(edgeInGridSpace - nearestLowerGridYInGridSpace);
                                if (distToLower <= (distToUpper = Math.abs(nearestUpperGridYInGridSpace - edgeInGridSpace))) {
                                    distancesToGridY[i] = distToLower;
                                    nearestGridLinesY[i] = (int)(nearestLowerGridYInGridSpace / guiScale);
                                    continue;
                                }
                                distancesToGridY[i] = distToUpper;
                                nearestGridLinesY[i] = (int)(nearestUpperGridYInGridSpace / guiScale);
                            }
                            int n2 = closestEdgeIndexY = distancesToGridY[0] <= distancesToGridY[1] ? 0 : 1;
                            if (distancesToGridY[closestEdgeIndexY] <= snapThreshold) {
                                int edgePos = closestEdgeIndexY == 0 ? topEdge : bottomEdge;
                                int gridPos = nearestGridLinesY[closestEdgeIndexY];
                                int yAdjustment = gridPos - edgePos;
                                this.element.posOffsetY += yAdjustment;
                            }
                        }
                    }
                    if (diffX > 0 || diffY > 0) {
                        this.recentlyMovedByDragging = true;
                    }
                } else if (!this.settings.isMovable()) {
                    this.renderMovingNotAllowedTime = System.currentTimeMillis() + 800L;
                }
            }
            if (this.leftMouseDown && this.isGettingResized()) {
                int diffX = (int)(-((double)this.resizingStartPosX - mouseX));
                int diffY = (int)(-((double)this.resizingStartPosY - mouseY));
                if (diffX > 0 || diffY > 0) {
                    this.recentlyResized = true;
                }
                if (this.activeResizeGrabber.type == ResizeGrabberType.LEFT || this.activeResizeGrabber.type == ResizeGrabberType.RIGHT) {
                    int newWidth;
                    int n = newWidth = this.activeResizeGrabber.type == ResizeGrabberType.LEFT ? this.leftMouseDownBaseWidth - diffX : this.leftMouseDownBaseWidth + diffX;
                    if (newWidth >= 2) {
                        this.element.autoSizingWidth = 0;
                        this.element.autoSizingHeight = 0;
                        int cachedOldOffsetX = this.element.posOffsetX;
                        int cachedOldPosX = this.element.getAbsoluteX();
                        int cachedOldWidth = this.element.getAbsoluteWidth();
                        this.element.baseWidth = newWidth;
                        this.element.posOffsetX = this.leftMouseDownBaseX + this.element.anchorPoint.getResizePositionOffsetX(this.element, diffX, this.activeResizeGrabber.type);
                        if (this.element.stickyAnchor) {
                            this.element.posOffsetX += this.element.anchorPoint.getStickyResizePositionCorrectionX(this.element, diffX, cachedOldOffsetX, this.element.posOffsetX, cachedOldPosX, this.element.getAbsoluteX(), cachedOldWidth, this.element.getAbsoluteWidth(), this.activeResizeGrabber.type);
                        }
                        if (Screen.hasShiftDown()) {
                            this.element.baseHeight = this.resizeAspectRatio.getAspectRatioHeight(this.element.baseWidth);
                        }
                    }
                }
                if (this.activeResizeGrabber.type == ResizeGrabberType.TOP || this.activeResizeGrabber.type == ResizeGrabberType.BOTTOM) {
                    int newHeight;
                    int n = newHeight = this.activeResizeGrabber.type == ResizeGrabberType.TOP ? this.leftMouseDownBaseHeight - diffY : this.leftMouseDownBaseHeight + diffY;
                    if (newHeight >= 2) {
                        this.element.autoSizingWidth = 0;
                        this.element.autoSizingHeight = 0;
                        int cachedOldOffsetY = this.element.posOffsetY;
                        int cachedOldPosY = this.element.getAbsoluteY();
                        int cachedOldHeight = this.element.getAbsoluteHeight();
                        this.element.baseHeight = newHeight;
                        this.element.posOffsetY = this.leftMouseDownBaseY + this.element.anchorPoint.getResizePositionOffsetY(this.element, diffY, this.activeResizeGrabber.type);
                        if (this.element.stickyAnchor) {
                            this.element.posOffsetY += this.element.anchorPoint.getStickyResizePositionCorrectionY(this.element, diffY, cachedOldOffsetY, this.element.posOffsetY, cachedOldPosY, this.element.getAbsoluteY(), cachedOldHeight, this.element.baseHeight, this.activeResizeGrabber.type);
                        }
                        if (Screen.hasShiftDown()) {
                            this.element.baseWidth = this.resizeAspectRatio.getAspectRatioWidth(this.element.baseHeight);
                        }
                    }
                }
            }
        }
        return false;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        if (this.element.layerHiddenInEditor) {
            return false;
        }
        return UIBase.isXYInArea((int)mouseX, (int)mouseY, this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public void setFocused(boolean var1) {
    }

    public boolean isFocused() {
        return false;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        if (!this.selected) {
            this.resetElementStates();
        }
        this.editor.onUpdateSelectedElements();
    }

    public boolean isMultiSelected() {
        return this.multiSelected;
    }

    public void setMultiSelected(boolean multiSelected) {
        this.multiSelected = multiSelected;
    }

    public boolean isHovered() {
        if (this.element.layerHiddenInEditor) {
            return false;
        }
        return this.hovered || this.rightClickMenu.isUserNavigatingInMenu() || this.getHoveredResizeGrabber() != null || this.getHoveredRotationGrabber() != null || this.getHoveredVerticalTiltGrabber() != null || this.getHoveredHorizontalTiltGrabber() != null;
    }

    public int getX() {
        return this.element.getAbsoluteX();
    }

    public int getY() {
        return this.element.getAbsoluteY();
    }

    public int getWidth() {
        return this.element.getAbsoluteWidth();
    }

    public int getHeight() {
        return this.element.getAbsoluteHeight();
    }

    public boolean deleteElement() {
        return this.editor.deleteElement(this);
    }

    public boolean isGettingResized() {
        if (!this.settings.isResizeable()) {
            return false;
        }
        return this.activeResizeGrabber != null;
    }

    public boolean isGettingRotated() {
        if (!this.element.supportsRotation()) {
            return false;
        }
        return this.rotationGrabberActive;
    }

    public boolean isGettingVerticalTilted() {
        if (!this.element.supportsTilting()) {
            return false;
        }
        return this.verticalTiltGrabberActive;
    }

    public boolean isGettingHorizontalTilted() {
        if (!this.element.supportsTilting()) {
            return false;
        }
        return this.horizontalTiltGrabberActive;
    }

    public boolean isGettingTilted() {
        return this.isGettingVerticalTilted() || this.isGettingHorizontalTilted();
    }

    public boolean isDragged() {
        return this.recentlyMovedByDragging;
    }

    public boolean isPressed() {
        return this.leftMouseDown;
    }

    @Nullable
    public ResizeGrabber getHoveredResizeGrabber() {
        if (!this.settings.isResizeable()) {
            return null;
        }
        if (this.activeResizeGrabber != null) {
            return this.activeResizeGrabber;
        }
        for (ResizeGrabber g : this.resizeGrabbers) {
            if (!g.hovered) continue;
            return g;
        }
        return null;
    }

    @Nullable
    public RotationGrabber getHoveredRotationGrabber() {
        if (!FancyMenu.getOptions().enableElementRotationControls.getValue().booleanValue()) {
            return null;
        }
        if (!this.element.supportsRotation()) {
            return null;
        }
        if (this.element.advancedRotationMode) {
            return null;
        }
        if (this.isMultiSelected()) {
            return null;
        }
        if (this.rotationGrabberActive) {
            return this.rotationGrabber;
        }
        if (this.rotationGrabber.hovered) {
            return this.rotationGrabber;
        }
        return null;
    }

    @Nullable
    public VerticalTiltGrabber getHoveredVerticalTiltGrabber() {
        if (!FancyMenu.getOptions().enableElementTiltingControls.getValue().booleanValue()) {
            return null;
        }
        if (!this.element.supportsTilting()) {
            return null;
        }
        if (this.element.advancedVerticalTiltMode) {
            return null;
        }
        if (this.isMultiSelected()) {
            return null;
        }
        if (this.verticalTiltGrabberActive) {
            return this.verticalTiltGrabber;
        }
        if (this.verticalTiltGrabber.hovered) {
            return this.verticalTiltGrabber;
        }
        return null;
    }

    @Nullable
    public HorizontalTiltGrabber getHoveredHorizontalTiltGrabber() {
        if (!FancyMenu.getOptions().enableElementTiltingControls.getValue().booleanValue()) {
            return null;
        }
        if (!this.element.supportsTilting()) {
            return null;
        }
        if (this.element.advancedHorizontalTiltMode) {
            return null;
        }
        if (this.isMultiSelected()) {
            return null;
        }
        if (this.horizontalTiltGrabberActive) {
            return this.horizontalTiltGrabber;
        }
        if (this.horizontalTiltGrabber.hovered) {
            return this.horizontalTiltGrabber;
        }
        return null;
    }

    protected <E extends AbstractEditorElement> ContextMenu.ClickableContextMenuEntry<?> addImageResourceChooserContextMenuEntryTo(@NotNull ContextMenu addTo, @NotNull String entryIdentifier, @NotNull Class<E> elementType, ResourceSupplier<ITexture> defaultValue, @NotNull ConsumingSupplier<E, ResourceSupplier<ITexture>> targetFieldGetter, @NotNull BiConsumer<E, ResourceSupplier<ITexture>> targetFieldSetter, @NotNull Component label, boolean addResetOption, @Nullable FileFilter fileFilter, boolean allowLocation, boolean allowLocal, boolean allowWeb) {
        ConsumingSupplier getter = targetFieldGetter;
        BiConsumer setter = targetFieldSetter;
        return this.addGenericResourceChooserContextMenuEntryTo(addTo, entryIdentifier, (AbstractEditorElement consumes) -> elementType.isAssignableFrom(consumes.getClass()), () -> ResourceChooserScreen.image(null, file -> {}), ResourceSupplier::image, defaultValue, getter, setter, label, addResetOption, FileTypeGroups.IMAGE_TYPES, fileFilter, allowLocation, allowLocal, allowWeb);
    }

    protected <E extends AbstractEditorElement> ContextMenu.ClickableContextMenuEntry<?> addAudioResourceChooserContextMenuEntryTo(@NotNull ContextMenu addTo, @NotNull String entryIdentifier, @NotNull Class<E> elementType, ResourceSupplier<IAudio> defaultValue, @NotNull ConsumingSupplier<E, ResourceSupplier<IAudio>> targetFieldGetter, @NotNull BiConsumer<E, ResourceSupplier<IAudio>> targetFieldSetter, @NotNull Component label, boolean addResetOption, @Nullable FileFilter fileFilter, boolean allowLocation, boolean allowLocal, boolean allowWeb) {
        ConsumingSupplier getter = targetFieldGetter;
        BiConsumer setter = targetFieldSetter;
        return this.addGenericResourceChooserContextMenuEntryTo(addTo, entryIdentifier, (AbstractEditorElement consumes) -> elementType.isAssignableFrom(consumes.getClass()), () -> ResourceChooserScreen.audio(null, file -> {}), ResourceSupplier::audio, defaultValue, getter, setter, label, addResetOption, FileTypeGroups.AUDIO_TYPES, fileFilter, allowLocation, allowLocal, allowWeb);
    }

    protected <E extends AbstractEditorElement> ContextMenu.ClickableContextMenuEntry<?> addVideoResourceChooserContextMenuEntryTo(@NotNull ContextMenu addTo, @NotNull String entryIdentifier, @NotNull Class<E> elementType, ResourceSupplier<IVideo> defaultValue, @NotNull ConsumingSupplier<E, ResourceSupplier<IVideo>> targetFieldGetter, @NotNull BiConsumer<E, ResourceSupplier<IVideo>> targetFieldSetter, @NotNull Component label, boolean addResetOption, @Nullable FileFilter fileFilter, boolean allowLocation, boolean allowLocal, boolean allowWeb) {
        ConsumingSupplier getter = targetFieldGetter;
        BiConsumer setter = targetFieldSetter;
        return this.addGenericResourceChooserContextMenuEntryTo(addTo, entryIdentifier, (AbstractEditorElement consumes) -> elementType.isAssignableFrom(consumes.getClass()), () -> ResourceChooserScreen.video(null, file -> {}), ResourceSupplier::video, defaultValue, getter, setter, label, addResetOption, FileTypeGroups.VIDEO_TYPES, fileFilter, allowLocation, allowLocal, allowWeb);
    }

    protected <E extends AbstractEditorElement> ContextMenu.ClickableContextMenuEntry<?> addTextResourceChooserContextMenuEntryTo(@NotNull ContextMenu addTo, @NotNull String entryIdentifier, @NotNull Class<E> elementType, ResourceSupplier<IText> defaultValue, @NotNull ConsumingSupplier<E, ResourceSupplier<IText>> targetFieldGetter, @NotNull BiConsumer<E, ResourceSupplier<IText>> targetFieldSetter, @NotNull Component label, boolean addResetOption, @Nullable FileFilter fileFilter, boolean allowLocation, boolean allowLocal, boolean allowWeb) {
        ConsumingSupplier getter = targetFieldGetter;
        BiConsumer setter = targetFieldSetter;
        return this.addGenericResourceChooserContextMenuEntryTo(addTo, entryIdentifier, (AbstractEditorElement consumes) -> elementType.isAssignableFrom(consumes.getClass()), () -> ResourceChooserScreen.text(null, file -> {}), ResourceSupplier::text, defaultValue, getter, setter, label, addResetOption, FileTypeGroups.TEXT_TYPES, fileFilter, allowLocation, allowLocal, allowWeb);
    }

    protected <R extends Resource, F extends FileType<R>, E extends AbstractEditorElement> ContextMenu.ClickableContextMenuEntry<?> addGenericResourceChooserContextMenuEntryTo(@NotNull ContextMenu addTo, @NotNull String entryIdentifier, @NotNull Class<E> elementType, @NotNull Supplier<ResourceChooserScreen<R, F>> resourceChooserScreenBuilder, @NotNull ConsumingSupplier<String, ResourceSupplier<R>> resourceSupplierBuilder, ResourceSupplier<R> defaultValue, @NotNull ConsumingSupplier<E, ResourceSupplier<R>> targetFieldGetter, @NotNull BiConsumer<E, ResourceSupplier<R>> targetFieldSetter, @NotNull Component label, boolean addResetOption, @Nullable FileTypeGroup<F> fileTypes, @Nullable FileFilter fileFilter, boolean allowLocation, boolean allowLocal, boolean allowWeb) {
        ConsumingSupplier<AbstractEditorElement, ResourceSupplier<R>> getter = targetFieldGetter;
        BiConsumer<AbstractEditorElement, ResourceSupplier<R>> setter = targetFieldSetter;
        return this.addGenericResourceChooserContextMenuEntryTo(addTo, entryIdentifier, (AbstractEditorElement consumes) -> elementType.isAssignableFrom(consumes.getClass()), resourceChooserScreenBuilder, resourceSupplierBuilder, defaultValue, getter, setter, label, addResetOption, fileTypes, fileFilter, allowLocation, allowLocal, allowWeb);
    }

    protected <R extends Resource, F extends FileType<R>> ContextMenu.ClickableContextMenuEntry<?> addGenericResourceChooserContextMenuEntryTo(@NotNull ContextMenu addTo, @NotNull String entryIdentifier, @Nullable ConsumingSupplier<AbstractEditorElement, Boolean> selectedElementsFilter, @NotNull Supplier<ResourceChooserScreen<R, F>> resourceChooserScreenBuilder, @NotNull ConsumingSupplier<String, ResourceSupplier<R>> resourceSupplierBuilder, ResourceSupplier<R> defaultValue, @NotNull ConsumingSupplier<AbstractEditorElement, ResourceSupplier<R>> targetFieldGetter, @NotNull BiConsumer<AbstractEditorElement, ResourceSupplier<R>> targetFieldSetter, @NotNull Component label, boolean addResetOption, @Nullable FileTypeGroup<F> fileTypes, @Nullable FileFilter fileFilter, boolean allowLocation, boolean allowLocal, boolean allowWeb) {
        ContextMenu subMenu = new ContextMenu();
        subMenu.addClickableEntry("choose_file", (Component)Component.translatable((String)"fancymenu.ui.resources.choose"), (menu, entry) -> {
            List<AbstractEditorElement> selectedElements = this.getFilteredSelectedElementList(selectedElementsFilter);
            if (entry.getStackMeta().isFirstInStack() && !selectedElements.isEmpty()) {
                String preSelectedSource = null;
                List<String> allPaths = ObjectUtils.getOfAll(String.class, selectedElements, consumes -> {
                    ResourceSupplier supplier = (ResourceSupplier)targetFieldGetter.get((AbstractEditorElement)consumes);
                    if (supplier != null) {
                        return supplier.getSourceWithPrefix();
                    }
                    return null;
                });
                if (!allPaths.isEmpty() && ListUtils.allInListEqual(allPaths)) {
                    preSelectedSource = allPaths.get(0);
                }
                ResourceChooserScreen chooserScreen = (ResourceChooserScreen)resourceChooserScreenBuilder.get();
                chooserScreen.setFileFilter(fileFilter);
                chooserScreen.setAllowedFileTypes(fileTypes);
                chooserScreen.setSource(preSelectedSource, false);
                chooserScreen.setLocationSourceAllowed(allowLocation);
                chooserScreen.setLocalSourceAllowed(allowLocal);
                chooserScreen.setWebSourceAllowed(allowWeb);
                chooserScreen.setResourceSourceCallback(source -> {
                    if (source != null) {
                        this.editor.history.saveSnapshot();
                        for (AbstractEditorElement e : selectedElements) {
                            targetFieldSetter.accept(e, (ResourceSupplier)resourceSupplierBuilder.get((String)source));
                        }
                    }
                    Minecraft.getInstance().setScreen((Screen)this.editor);
                });
                Minecraft.getInstance().setScreen((Screen)chooserScreen);
            }
        }).setStackable(true);
        if (addResetOption) {
            subMenu.addClickableEntry("reset_to_default", (Component)Component.translatable((String)"fancymenu.ui.resources.reset"), (menu, entry) -> {
                if (entry.getStackMeta().isFirstInStack()) {
                    List<AbstractEditorElement> selectedElements = this.getFilteredSelectedElementList(selectedElementsFilter);
                    this.editor.history.saveSnapshot();
                    for (AbstractEditorElement e : selectedElements) {
                        targetFieldSetter.accept(e, defaultValue);
                    }
                }
            }).setStackable(true);
        }
        Supplier<Component> currentValueDisplayLabelSupplier = () -> {
            List<AbstractEditorElement> selectedElements = this.getFilteredSelectedElementList(selectedElementsFilter);
            if (selectedElements.size() == 1) {
                MutableComponent valueComponent;
                Object val;
                ResourceSupplier supplier = (ResourceSupplier)targetFieldGetter.get(selectedElements.get(0));
                Object object = val = supplier != null ? supplier.getSourceWithoutPrefix() : null;
                if (val == null) {
                    valueComponent = Component.literal((String)"---").setStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().error_text_color.getColorInt()));
                } else {
                    if (Minecraft.getInstance().font.width((String)(val = GameDirectoryUtils.getPathWithoutGameDirectory((String)val))) > 150) {
                        val = new StringBuilder((String)val).reverse().toString();
                        val = Minecraft.getInstance().font.plainSubstrByWidth((String)val, 150);
                        val = new StringBuilder((String)val).reverse().toString();
                        val = ".." + (String)val;
                    }
                    valueComponent = Component.literal((String)val).setStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().success_text_color.getColorInt()));
                }
                return Component.translatable((String)"fancymenu.ui.resources.current", (Object[])new Object[]{valueComponent});
            }
            return Component.empty();
        };
        subMenu.addSeparatorEntry("separator_before_current_value_display").setIsVisibleSupplier((menu, entry) -> this.getFilteredSelectedElementList(selectedElementsFilter).size() == 1);
        ((ContextMenu.ClickableContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)((ContextMenu.ContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)subMenu.addClickableEntry("current_value_display", (Component)Component.empty(), (menu, entry) -> {}).setLabelSupplier((menu, entry) -> (Component)currentValueDisplayLabelSupplier.get())).setClickSoundEnabled(false)).setChangeBackgroundColorOnHover(false)).setIsVisibleSupplier((menu, entry) -> this.getFilteredSelectedElementList(selectedElementsFilter).size() == 1)).setIcon(ContextMenu.IconFactory.getIcon("info"));
        return (ContextMenu.ClickableContextMenuEntry)addTo.addSubMenuEntry(entryIdentifier, label, subMenu).setStackable(true);
    }

    protected ContextMenu.ClickableContextMenuEntry<?> addInputContextMenuEntryTo(@NotNull ContextMenu addTo, @NotNull String entryIdentifier, @Nullable ConsumingSupplier<AbstractEditorElement, Boolean> selectedElementsFilter, @NotNull ConsumingSupplier<AbstractEditorElement, String> targetFieldGetter, @NotNull BiConsumer<AbstractEditorElement, String> targetFieldSetter, @Nullable CharacterFilter inputCharacterFilter, boolean multiLineInput, boolean allowPlaceholders, @NotNull Component label, boolean addResetOption, String defaultValue, @Nullable ConsumingSupplier<String, Boolean> textValidator, @Nullable ConsumingSupplier<String, Tooltip> textValidatorUserFeedback) {
        ContextMenu subMenu = new ContextMenu();
        ContextMenu.ClickableContextMenuEntry inputEntry = (ContextMenu.ClickableContextMenuEntry)subMenu.addClickableEntry("input_value", (Component)Component.translatable((String)"fancymenu.common_components.set"), (menu, entry) -> {
            if (entry.getStackMeta().isFirstInStack()) {
                Screen inputScreen;
                List<AbstractEditorElement> selectedElements = this.getFilteredSelectedElementList(selectedElementsFilter);
                String defaultText = null;
                ArrayList<String> targetValuesOfSelected = new ArrayList<String>();
                for (AbstractEditorElement e : selectedElements) {
                    targetValuesOfSelected.add((String)targetFieldGetter.get(e));
                }
                if (!entry.getStackMeta().isPartOfStack() || ListUtils.allInListEqual(targetValuesOfSelected)) {
                    defaultText = (String)targetFieldGetter.get(this);
                }
                if (!multiLineInput && !allowPlaceholders) {
                    s = TextInputScreen.build(label, inputCharacterFilter, call -> {
                        if (call != null) {
                            this.editor.history.saveSnapshot();
                            for (AbstractEditorElement e : selectedElements) {
                                targetFieldSetter.accept(e, (String)call);
                            }
                        }
                        menu.closeMenu();
                        Minecraft.getInstance().setScreen((Screen)this.editor);
                    });
                    if (textValidator != null) {
                        s.setTextValidator(consumes -> {
                            if (textValidatorUserFeedback != null) {
                                consumes.setTextValidatorUserFeedback((Tooltip)textValidatorUserFeedback.get(consumes.getText()));
                            }
                            return (Boolean)textValidator.get(consumes.getText());
                        });
                    }
                    s.setText(defaultText);
                    inputScreen = s;
                } else {
                    s = new TextEditorScreen(label, inputCharacterFilter != null ? inputCharacterFilter.convertToLegacyFilter() : null, call -> {
                        if (call != null) {
                            this.editor.history.saveSnapshot();
                            for (AbstractEditorElement e : selectedElements) {
                                targetFieldSetter.accept(e, (String)call);
                            }
                        }
                        menu.closeMenu();
                        Minecraft.getInstance().setScreen((Screen)this.editor);
                    });
                    if (textValidator != null) {
                        s.setTextValidator(consumes -> {
                            if (textValidatorUserFeedback != null) {
                                consumes.setTextValidatorUserFeedback((Tooltip)textValidatorUserFeedback.get(consumes.getText()));
                            }
                            return (Boolean)textValidator.get(consumes.getText());
                        });
                    }
                    s.setText(defaultText);
                    s.setMultilineMode(multiLineInput);
                    s.setPlaceholdersAllowed(allowPlaceholders);
                    inputScreen = s;
                }
                Minecraft.getInstance().setScreen(inputScreen);
            }
        }).setStackable(true);
        if (addResetOption) {
            subMenu.addClickableEntry("reset_to_default", (Component)Component.translatable((String)"fancymenu.common_components.reset"), (menu, entry) -> {
                if (entry.getStackMeta().isFirstInStack()) {
                    List<AbstractEditorElement> selectedElements = this.getFilteredSelectedElementList(selectedElementsFilter);
                    this.editor.history.saveSnapshot();
                    for (AbstractEditorElement e : selectedElements) {
                        targetFieldSetter.accept(e, defaultValue);
                    }
                }
            }).setStackable(true);
        }
        Supplier<Component> currentValueDisplayLabelSupplier = () -> {
            List<AbstractEditorElement> selectedElements = this.getFilteredSelectedElementList(selectedElementsFilter);
            if (selectedElements.size() == 1) {
                MutableComponent valueComponent;
                Object val = (String)targetFieldGetter.get(selectedElements.get(0));
                if (val == null) {
                    valueComponent = Component.literal((String)"---").setStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().error_text_color.getColorInt()));
                } else {
                    if (Minecraft.getInstance().font.width((String)(val = GameDirectoryUtils.getPathWithoutGameDirectory((String)val))) > 150) {
                        val = new StringBuilder((String)val).reverse().toString();
                        val = Minecraft.getInstance().font.plainSubstrByWidth((String)val, 150);
                        val = new StringBuilder((String)val).reverse().toString();
                        val = ".." + (String)val;
                    }
                    valueComponent = Component.literal((String)val).setStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().success_text_color.getColorInt()));
                }
                return Component.translatable((String)"fancymenu.context_menu.entries.choose_or_set.current", (Object[])new Object[]{valueComponent});
            }
            return Component.empty();
        };
        subMenu.addSeparatorEntry("separator_before_current_value_display").setIsVisibleSupplier((menu, entry) -> this.getFilteredSelectedElementList(selectedElementsFilter).size() == 1);
        ((ContextMenu.ClickableContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)((ContextMenu.ContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)subMenu.addClickableEntry("current_value_display", (Component)Component.empty(), (menu, entry) -> {}).setLabelSupplier((menu, entry) -> (Component)currentValueDisplayLabelSupplier.get())).setClickSoundEnabled(false)).setChangeBackgroundColorOnHover(false)).setIsVisibleSupplier((menu, entry) -> this.getFilteredSelectedElementList(selectedElementsFilter).size() == 1)).setIcon(ContextMenu.IconFactory.getIcon("info"));
        return (ContextMenu.ClickableContextMenuEntry)addTo.addSubMenuEntry(entryIdentifier, label, subMenu).setStackable(true);
    }

    protected <E extends AbstractEditorElement> ContextMenu.ClickableContextMenuEntry<?> addInputContextMenuEntryTo(@NotNull ContextMenu addTo, @NotNull String entryIdentifier, @NotNull Class<E> elementType, @NotNull ConsumingSupplier<E, String> targetFieldGetter, @NotNull BiConsumer<E, String> targetFieldSetter, @Nullable CharacterFilter inputCharacterFilter, boolean multiLineInput, boolean allowPlaceholders, @NotNull Component label, boolean addResetOption, String defaultValue, @Nullable ConsumingSupplier<String, Boolean> textValidator, @Nullable ConsumingSupplier<String, Tooltip> textValidatorUserFeedback) {
        ConsumingSupplier<AbstractEditorElement, String> getter = targetFieldGetter;
        BiConsumer<AbstractEditorElement, String> setter = targetFieldSetter;
        return this.addInputContextMenuEntryTo(addTo, entryIdentifier, (AbstractEditorElement consumes) -> elementType.isAssignableFrom(consumes.getClass()), getter, setter, inputCharacterFilter, multiLineInput, allowPlaceholders, label, addResetOption, defaultValue, textValidator, textValidatorUserFeedback);
    }

    protected ContextMenu.ClickableContextMenuEntry<?> addGenericStringInputContextMenuEntryTo(@NotNull ContextMenu addTo, @NotNull String entryIdentifier, @Nullable ConsumingSupplier<AbstractEditorElement, Boolean> selectedElementsFilter, @NotNull ConsumingSupplier<AbstractEditorElement, String> targetFieldGetter, @NotNull BiConsumer<AbstractEditorElement, String> targetFieldSetter, @Nullable CharacterFilter inputCharacterFilter, boolean multiLineInput, boolean allowPlaceholders, @NotNull Component label, boolean addResetOption, String defaultValue, @Nullable ConsumingSupplier<String, Boolean> textValidator, @Nullable ConsumingSupplier<String, Tooltip> textValidatorUserFeedback) {
        return this.addInputContextMenuEntryTo(addTo, entryIdentifier, selectedElementsFilter, targetFieldGetter, targetFieldSetter, inputCharacterFilter, multiLineInput, allowPlaceholders, label, addResetOption, defaultValue, textValidator, textValidatorUserFeedback);
    }

    protected <E extends AbstractEditorElement> ContextMenu.ClickableContextMenuEntry<?> addStringInputContextMenuEntryTo(@NotNull ContextMenu addTo, @NotNull String entryIdentifier, @NotNull Class<E> elementType, @NotNull ConsumingSupplier<E, String> targetFieldGetter, @NotNull BiConsumer<E, String> targetFieldSetter, @Nullable CharacterFilter inputCharacterFilter, boolean multiLineInput, boolean allowPlaceholders, @NotNull Component label, boolean addResetOption, String defaultValue, @Nullable ConsumingSupplier<String, Boolean> textValidator, @Nullable ConsumingSupplier<String, Tooltip> textValidatorUserFeedback) {
        ConsumingSupplier<AbstractEditorElement, String> getter = targetFieldGetter;
        BiConsumer<AbstractEditorElement, String> setter = targetFieldSetter;
        return this.addGenericStringInputContextMenuEntryTo(addTo, entryIdentifier, consumes -> elementType.isAssignableFrom(consumes.getClass()), getter, setter, inputCharacterFilter, multiLineInput, allowPlaceholders, label, addResetOption, defaultValue, textValidator, textValidatorUserFeedback);
    }

    protected ContextMenu.ClickableContextMenuEntry<?> addGenericIntegerInputContextMenuEntryTo(@NotNull ContextMenu addTo, @NotNull String entryIdentifier, @Nullable ConsumingSupplier<AbstractEditorElement, Boolean> selectedElementsFilter, @NotNull ConsumingSupplier<AbstractEditorElement, Integer> targetFieldGetter, @NotNull BiConsumer<AbstractEditorElement, Integer> targetFieldSetter, @NotNull Component label, boolean addResetOption, int defaultValue, @Nullable ConsumingSupplier<String, Boolean> textValidator, @Nullable ConsumingSupplier<String, Tooltip> textValidatorUserFeedback) {
        ConsumingSupplier<String, Boolean> defaultIntegerValidator = consumes -> consumes != null && !consumes.replace(" ", "").isEmpty() && de.keksuccino.konkrete.math.MathUtils.isInteger((String)consumes);
        return this.addInputContextMenuEntryTo(addTo, entryIdentifier, selectedElementsFilter, (AbstractEditorElement consumes) -> {
            Integer i = (Integer)targetFieldGetter.get((AbstractEditorElement)consumes);
            if (i == null) {
                i = 0;
            }
            return "" + i;
        }, (AbstractEditorElement e, String s) -> {
            if (de.keksuccino.konkrete.math.MathUtils.isInteger((String)s)) {
                targetFieldSetter.accept((AbstractEditorElement)e, Integer.valueOf(s));
            }
        }, CharacterFilter.buildIntegerFiler(), false, false, label, addResetOption, "" + defaultValue, textValidator != null ? textValidator : defaultIntegerValidator, textValidatorUserFeedback);
    }

    protected <E extends AbstractEditorElement> ContextMenu.ClickableContextMenuEntry<?> addIntegerInputContextMenuEntryTo(@NotNull ContextMenu addTo, @NotNull String entryIdentifier, @NotNull Class<E> elementType, @NotNull ConsumingSupplier<E, Integer> targetFieldGetter, @NotNull BiConsumer<E, Integer> targetFieldSetter, @NotNull Component label, boolean addResetOption, int defaultValue, @Nullable ConsumingSupplier<String, Boolean> textValidator, @Nullable ConsumingSupplier<String, Tooltip> textValidatorUserFeedback) {
        ConsumingSupplier<AbstractEditorElement, Integer> getter = targetFieldGetter;
        BiConsumer<AbstractEditorElement, Integer> setter = targetFieldSetter;
        return this.addGenericIntegerInputContextMenuEntryTo(addTo, entryIdentifier, consumes -> elementType.isAssignableFrom(consumes.getClass()), getter, setter, label, addResetOption, defaultValue, textValidator, textValidatorUserFeedback);
    }

    protected ContextMenu.ClickableContextMenuEntry<?> addGenericLongInputContextMenuEntryTo(@NotNull ContextMenu addTo, @NotNull String entryIdentifier, @Nullable ConsumingSupplier<AbstractEditorElement, Boolean> selectedElementsFilter, @NotNull ConsumingSupplier<AbstractEditorElement, Long> targetFieldGetter, @NotNull BiConsumer<AbstractEditorElement, Long> targetFieldSetter, @NotNull Component label, boolean addResetOption, long defaultValue, @Nullable ConsumingSupplier<String, Boolean> textValidator, @Nullable ConsumingSupplier<String, Tooltip> textValidatorUserFeedback) {
        ConsumingSupplier<String, Boolean> defaultLongValidator = consumes -> consumes != null && !consumes.replace(" ", "").isEmpty() && de.keksuccino.konkrete.math.MathUtils.isLong((String)consumes);
        return this.addInputContextMenuEntryTo(addTo, entryIdentifier, selectedElementsFilter, (AbstractEditorElement consumes) -> {
            Long l = (Long)targetFieldGetter.get((AbstractEditorElement)consumes);
            if (l == null) {
                l = 0L;
            }
            return "" + l;
        }, (AbstractEditorElement e, String s) -> {
            if (de.keksuccino.konkrete.math.MathUtils.isLong((String)s)) {
                targetFieldSetter.accept((AbstractEditorElement)e, Long.valueOf(s));
            }
        }, CharacterFilter.buildIntegerFiler(), false, false, label, addResetOption, "" + defaultValue, textValidator != null ? textValidator : defaultLongValidator, textValidatorUserFeedback);
    }

    protected <E extends AbstractEditorElement> ContextMenu.ClickableContextMenuEntry<?> addLongInputContextMenuEntryTo(@NotNull ContextMenu addTo, @NotNull String entryIdentifier, @NotNull Class<E> elementType, @NotNull ConsumingSupplier<E, Long> targetFieldGetter, @NotNull BiConsumer<E, Long> targetFieldSetter, @NotNull Component label, boolean addResetOption, long defaultValue, @Nullable ConsumingSupplier<String, Boolean> textValidator, @Nullable ConsumingSupplier<String, Tooltip> textValidatorUserFeedback) {
        ConsumingSupplier<AbstractEditorElement, Long> getter = targetFieldGetter;
        BiConsumer<AbstractEditorElement, Long> setter = targetFieldSetter;
        return this.addGenericLongInputContextMenuEntryTo(addTo, entryIdentifier, consumes -> elementType.isAssignableFrom(consumes.getClass()), getter, setter, label, addResetOption, defaultValue, textValidator, textValidatorUserFeedback);
    }

    protected ContextMenu.ClickableContextMenuEntry<?> addGenericDoubleInputContextMenuEntryTo(@NotNull ContextMenu addTo, @NotNull String entryIdentifier, @Nullable ConsumingSupplier<AbstractEditorElement, Boolean> selectedElementsFilter, @NotNull ConsumingSupplier<AbstractEditorElement, Double> targetFieldGetter, @NotNull BiConsumer<AbstractEditorElement, Double> targetFieldSetter, @NotNull Component label, boolean addResetOption, double defaultValue, @Nullable ConsumingSupplier<String, Boolean> textValidator, @Nullable ConsumingSupplier<String, Tooltip> textValidatorUserFeedback) {
        ConsumingSupplier<String, Boolean> defaultDoubleValidator = consumes -> consumes != null && !consumes.replace(" ", "").isEmpty() && de.keksuccino.konkrete.math.MathUtils.isDouble((String)consumes);
        return this.addInputContextMenuEntryTo(addTo, entryIdentifier, selectedElementsFilter, (AbstractEditorElement consumes) -> {
            Double d = (Double)targetFieldGetter.get((AbstractEditorElement)consumes);
            if (d == null) {
                d = 0.0;
            }
            return "" + d;
        }, (AbstractEditorElement e, String s) -> {
            if (de.keksuccino.konkrete.math.MathUtils.isDouble((String)s)) {
                targetFieldSetter.accept((AbstractEditorElement)e, Double.valueOf(s));
            }
        }, CharacterFilter.buildDecimalFiler(), false, false, label, addResetOption, "" + defaultValue, textValidator != null ? textValidator : defaultDoubleValidator, textValidatorUserFeedback);
    }

    protected <E extends AbstractEditorElement> ContextMenu.ClickableContextMenuEntry<?> addDoubleInputContextMenuEntryTo(@NotNull ContextMenu addTo, @NotNull String entryIdentifier, @NotNull Class<E> elementType, @NotNull ConsumingSupplier<E, Double> targetFieldGetter, @NotNull BiConsumer<E, Double> targetFieldSetter, @NotNull Component label, boolean addResetOption, double defaultValue, @Nullable ConsumingSupplier<String, Boolean> textValidator, @Nullable ConsumingSupplier<String, Tooltip> textValidatorUserFeedback) {
        ConsumingSupplier<AbstractEditorElement, Double> getter = targetFieldGetter;
        BiConsumer<AbstractEditorElement, Double> setter = targetFieldSetter;
        return this.addGenericDoubleInputContextMenuEntryTo(addTo, entryIdentifier, consumes -> elementType.isAssignableFrom(consumes.getClass()), getter, setter, label, addResetOption, defaultValue, textValidator, textValidatorUserFeedback);
    }

    protected ContextMenu.ClickableContextMenuEntry<?> addGenericFloatInputContextMenuEntryTo(@NotNull ContextMenu addTo, @NotNull String entryIdentifier, @Nullable ConsumingSupplier<AbstractEditorElement, Boolean> selectedElementsFilter, @NotNull ConsumingSupplier<AbstractEditorElement, Float> targetFieldGetter, @NotNull BiConsumer<AbstractEditorElement, Float> targetFieldSetter, @NotNull Component label, boolean addResetOption, float defaultValue, @Nullable ConsumingSupplier<String, Boolean> textValidator, @Nullable ConsumingSupplier<String, Tooltip> textValidatorUserFeedback) {
        ConsumingSupplier<String, Boolean> defaultFloatValidator = consumes -> consumes != null && !consumes.replace(" ", "").isEmpty() && de.keksuccino.konkrete.math.MathUtils.isFloat((String)consumes);
        return this.addInputContextMenuEntryTo(addTo, entryIdentifier, selectedElementsFilter, (AbstractEditorElement consumes) -> {
            Float f = (Float)targetFieldGetter.get((AbstractEditorElement)consumes);
            if (f == null) {
                f = Float.valueOf(0.0f);
            }
            return "" + f;
        }, (AbstractEditorElement e, String s) -> {
            if (de.keksuccino.konkrete.math.MathUtils.isFloat((String)s)) {
                targetFieldSetter.accept((AbstractEditorElement)e, Float.valueOf(s));
            }
        }, CharacterFilter.buildDecimalFiler(), false, false, label, addResetOption, "" + defaultValue, textValidator != null ? textValidator : defaultFloatValidator, textValidatorUserFeedback);
    }

    protected <E extends AbstractEditorElement> ContextMenu.ClickableContextMenuEntry<?> addFloatInputContextMenuEntryTo(@NotNull ContextMenu addTo, @NotNull String entryIdentifier, @NotNull Class<E> elementType, @NotNull ConsumingSupplier<E, Float> targetFieldGetter, @NotNull BiConsumer<E, Float> targetFieldSetter, @NotNull Component label, boolean addResetOption, float defaultValue, @Nullable ConsumingSupplier<String, Boolean> textValidator, @Nullable ConsumingSupplier<String, Tooltip> textValidatorUserFeedback) {
        ConsumingSupplier<AbstractEditorElement, Float> getter = targetFieldGetter;
        BiConsumer<AbstractEditorElement, Float> setter = targetFieldSetter;
        return this.addGenericFloatInputContextMenuEntryTo(addTo, entryIdentifier, consumes -> elementType.isAssignableFrom(consumes.getClass()), getter, setter, label, addResetOption, defaultValue, textValidator, textValidatorUserFeedback);
    }

    protected <V> ContextMenu.ClickableContextMenuEntry<?> addGenericCycleContextMenuEntryTo(@NotNull ContextMenu addTo, @NotNull String entryIdentifier, List<V> switcherValues, @Nullable ConsumingSupplier<AbstractEditorElement, Boolean> selectedElementsFilter, @NotNull ConsumingSupplier<AbstractEditorElement, V> targetFieldGetter, @NotNull BiConsumer<AbstractEditorElement, V> targetFieldSetter, @NotNull SwitcherContextMenuEntryLabelSupplier<V> labelSupplier) {
        return (ContextMenu.ClickableContextMenuEntry)((ContextMenu.ContextMenuEntry)addTo.addClickableEntry(entryIdentifier, (Component)Component.literal((String)""), (menu, entry) -> {
            List<AbstractEditorElement> selectedElements = this.getFilteredSelectedElementList(selectedElementsFilter);
            ValueCycle cycle = this.setupValueCycle("switcher", ValueCycle.fromList(switcherValues), selectedElements, entry.getStackMeta(), targetFieldGetter);
            this.editor.history.saveSnapshot();
            if (!selectedElements.isEmpty() && entry.getStackMeta().isFirstInStack()) {
                Object next = cycle.next();
                for (AbstractEditorElement e : selectedElements) {
                    targetFieldSetter.accept(e, next);
                }
            }
        }).setLabelSupplier((menu, entry) -> {
            List<Object> selectedElements = new ArrayList();
            if (!entry.getStackMeta().getProperties().hasProperty("switcher")) {
                selectedElements = this.getFilteredSelectedElementList(selectedElementsFilter);
            }
            ValueCycle switcher = this.setupValueCycle("switcher", ValueCycle.fromList(switcherValues), selectedElements, entry.getStackMeta(), targetFieldGetter);
            return labelSupplier.get(menu, (ContextMenu.ClickableContextMenuEntry)entry, switcher.current());
        })).setStackable(true);
    }

    protected <V, E extends AbstractEditorElement> ContextMenu.ClickableContextMenuEntry<?> addCycleContextMenuEntryTo(@NotNull ContextMenu addTo, @NotNull String entryIdentifier, List<V> switcherValues, @NotNull Class<E> elementType, @NotNull ConsumingSupplier<E, V> targetFieldGetter, @NotNull BiConsumer<E, V> targetFieldSetter, @NotNull SwitcherContextMenuEntryLabelSupplier<V> labelSupplier) {
        ConsumingSupplier<E, V> getter = targetFieldGetter;
        BiConsumer<E, V> setter = targetFieldSetter;
        return this.addGenericCycleContextMenuEntryTo(addTo, entryIdentifier, switcherValues, consumes -> elementType.isAssignableFrom(consumes.getClass()), getter, setter, labelSupplier);
    }

    protected <E extends AbstractEditorElement> ContextMenu.ClickableContextMenuEntry<?> addToggleContextMenuEntryTo(@NotNull ContextMenu addTo, @NotNull String entryIdentifier, @NotNull Class<E> elementType, @NotNull ConsumingSupplier<E, Boolean> targetFieldGetter, @NotNull BiConsumer<E, Boolean> targetFieldSetter, @NotNull String labelLocalizationKeyBase) {
        ConsumingSupplier<E, Boolean> getter = targetFieldGetter;
        BiConsumer<E, Boolean> setter = targetFieldSetter;
        return (ContextMenu.ClickableContextMenuEntry)this.addGenericCycleContextMenuEntryTo(addTo, entryIdentifier, ListUtils.of(false, true), consumes -> elementType.isAssignableFrom(consumes.getClass()), getter, setter, (menu, entry, switcherValue) -> {
            if (switcherValue.booleanValue() && entry.isActive()) {
                MutableComponent enabled = Component.translatable((String)"fancymenu.general.cycle.enabled_disabled.enabled").withStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().success_text_color.getColorInt()));
                return Component.translatable((String)labelLocalizationKeyBase, (Object[])new Object[]{enabled});
            }
            MutableComponent disabled = Component.translatable((String)"fancymenu.general.cycle.enabled_disabled.disabled").withStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().error_text_color.getColorInt()));
            return Component.translatable((String)labelLocalizationKeyBase, (Object[])new Object[]{disabled});
        }).setStackable(true);
    }

    @Deprecated
    protected ContextMenu.ClickableContextMenuEntry<?> addGenericBooleanSwitcherContextMenuEntryTo(@NotNull ContextMenu addTo, @NotNull String entryIdentifier, @Nullable ConsumingSupplier<AbstractEditorElement, Boolean> selectedElementsFilter, @NotNull ConsumingSupplier<AbstractEditorElement, Boolean> targetFieldGetter, @NotNull BiConsumer<AbstractEditorElement, Boolean> targetFieldSetter, @NotNull String labelLocalizationKeyBase) {
        return (ContextMenu.ClickableContextMenuEntry)this.addGenericCycleContextMenuEntryTo(addTo, entryIdentifier, ListUtils.of(false, true), selectedElementsFilter, targetFieldGetter, targetFieldSetter, (menu, entry, switcherValue) -> {
            if (switcherValue.booleanValue() && entry.isActive()) {
                return Component.translatable((String)(labelLocalizationKeyBase + ".on"));
            }
            return Component.translatable((String)(labelLocalizationKeyBase + ".off"));
        }).setStackable(true);
    }

    protected <T, E extends AbstractEditorElement> ValueCycle<T> setupValueCycle(String toggleIdentifier, ValueCycle<T> cycle, List<E> elements, ContextMenu.ContextMenuStackMeta stackMeta, ConsumingSupplier<E, T> defaultValue) {
        boolean hasProperty = stackMeta.getProperties().hasProperty(toggleIdentifier);
        ValueCycle<T> t = stackMeta.getProperties().putPropertyIfAbsentAndGet(toggleIdentifier, cycle);
        if (!elements.isEmpty()) {
            AbstractEditorElement firstElement = (AbstractEditorElement)elements.get(0);
            if (!stackMeta.isPartOfStack()) {
                t.setCurrentValue((Object)defaultValue.get(firstElement));
            } else if (!hasProperty && ListUtils.allInListEqual(ObjectUtils.getOfAllUnsafe(elements, defaultValue))) {
                t.setCurrentValue(defaultValue.get(firstElement));
            }
        }
        return t;
    }

    protected List<AbstractEditorElement> getFilteredSelectedElementList(@Nullable ConsumingSupplier<AbstractEditorElement, Boolean> selectedElementsFilter) {
        return ListUtils.filterList(this.editor.getSelectedElements(), consumes -> {
            if (selectedElementsFilter == null) {
                return true;
            }
            return (Boolean)selectedElementsFilter.get((AbstractEditorElement)consumes);
        });
    }

    public class ResizeGrabber
    implements Renderable {
        protected int width = 4;
        protected int height = 4;
        protected final ResizeGrabberType type;
        protected boolean hovered = false;

        protected ResizeGrabber(ResizeGrabberType type) {
            this.type = type;
        }

        public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
            boolean bl = this.hovered = AbstractEditorElement.this.isSelected() && this.isGrabberEnabled() && this.isMouseOver(mouseX, mouseY);
            if (AbstractEditorElement.this.isSelected() && this.isGrabberEnabled()) {
                graphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, BORDER_COLOR.get(AbstractEditorElement.this).intValue());
            }
        }

        protected int getX() {
            int x = AbstractEditorElement.this.getX();
            if (this.type == ResizeGrabberType.TOP || this.type == ResizeGrabberType.BOTTOM) {
                x += AbstractEditorElement.this.getWidth() / 2 - this.width / 2;
            }
            if (this.type == ResizeGrabberType.RIGHT) {
                x += AbstractEditorElement.this.getWidth() - this.width / 2;
            }
            if (this.type == ResizeGrabberType.LEFT) {
                x -= this.width / 2;
            }
            return x;
        }

        protected int getY() {
            int y = AbstractEditorElement.this.getY();
            if (this.type == ResizeGrabberType.TOP) {
                y -= this.height / 2;
            }
            if (this.type == ResizeGrabberType.RIGHT || this.type == ResizeGrabberType.LEFT) {
                y += AbstractEditorElement.this.getHeight() / 2 - this.height / 2;
            }
            if (this.type == ResizeGrabberType.BOTTOM) {
                y += AbstractEditorElement.this.getHeight() - this.height / 2;
            }
            return y;
        }

        protected long getCursor() {
            if (this.type == ResizeGrabberType.TOP || this.type == ResizeGrabberType.BOTTOM) {
                return CursorHandler.CURSOR_RESIZE_VERTICAL;
            }
            return CursorHandler.CURSOR_RESIZE_HORIZONTAL;
        }

        protected boolean isGrabberEnabled() {
            if (AbstractEditorElement.this.isMultiSelected()) {
                return false;
            }
            if (this.type == ResizeGrabberType.TOP || this.type == ResizeGrabberType.BOTTOM) {
                if (this.type == ResizeGrabberType.TOP && AbstractEditorElement.this.element.advancedY != null) {
                    return false;
                }
                return AbstractEditorElement.this.settings.isResizeable() && AbstractEditorElement.this.settings.isResizeableY() && AbstractEditorElement.this.element.advancedHeight == null;
            }
            if (this.type == ResizeGrabberType.LEFT || this.type == ResizeGrabberType.RIGHT) {
                if (this.type == ResizeGrabberType.LEFT && AbstractEditorElement.this.element.advancedX != null) {
                    return false;
                }
                return AbstractEditorElement.this.settings.isResizeable() && AbstractEditorElement.this.settings.isResizeableX() && AbstractEditorElement.this.element.advancedWidth == null;
            }
            return false;
        }

        protected boolean isMouseOver(double mouseX, double mouseY) {
            return mouseX >= (double)this.getX() && mouseX <= (double)(this.getX() + this.width) && mouseY >= (double)this.getY() && mouseY <= (double)(this.getY() + this.height);
        }
    }

    public static enum ResizeGrabberType {
        TOP,
        RIGHT,
        BOTTOM,
        LEFT;

    }

    public class RotationGrabber
    implements Renderable {
        protected int size = 6;
        protected boolean hovered = false;

        public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
            boolean bl = this.hovered = AbstractEditorElement.this.isSelected() && this.isGrabberEnabled() && this.isMouseOver(mouseX, mouseY);
            if (AbstractEditorElement.this.isSelected() && this.isGrabberEnabled()) {
                int x = this.getX();
                int y = this.getY();
                int color = UIBase.getUIColorTheme().layout_editor_element_border_rotation_controls_color.getColorIntWithAlpha(ROTATION_CONTROLS_ALPHA.get(AbstractEditorElement.this).floatValue());
                graphics.fill(x - this.size / 2, y - this.size / 2, x + this.size / 2, y + this.size / 2, color);
            }
        }

        protected int getX() {
            float centerX = (float)AbstractEditorElement.this.getX() + (float)AbstractEditorElement.this.getWidth() / 2.0f;
            float halfWidth = (float)AbstractEditorElement.this.getWidth() / 2.0f;
            float halfHeight = (float)AbstractEditorElement.this.getHeight() / 2.0f;
            float radius = (float)Math.sqrt(halfWidth * halfWidth + halfHeight * halfHeight) + 8.0f;
            float angleRad = (float)Math.toRadians(AbstractEditorElement.this.element.rotationDegrees - 90.0f);
            return (int)((double)centerX + (double)radius * Math.cos(angleRad));
        }

        protected int getY() {
            float centerY = (float)AbstractEditorElement.this.getY() + (float)AbstractEditorElement.this.getHeight() / 2.0f;
            float halfWidth = (float)AbstractEditorElement.this.getWidth() / 2.0f;
            float halfHeight = (float)AbstractEditorElement.this.getHeight() / 2.0f;
            float radius = (float)Math.sqrt(halfWidth * halfWidth + halfHeight * halfHeight) + 8.0f;
            float angleRad = (float)Math.toRadians(AbstractEditorElement.this.element.rotationDegrees - 90.0f);
            return (int)((double)centerY + (double)radius * Math.sin(angleRad));
        }

        protected boolean isGrabberEnabled() {
            if (!FancyMenu.getOptions().enableElementRotationControls.getValue().booleanValue()) {
                return false;
            }
            if (!AbstractEditorElement.this.element.supportsRotation()) {
                return false;
            }
            if (AbstractEditorElement.this.element.advancedRotationMode) {
                return false;
            }
            return !AbstractEditorElement.this.isMultiSelected();
        }

        protected boolean isMouseOver(double mouseX, double mouseY) {
            int x = this.getX();
            int y = this.getY();
            return mouseX >= (double)(x - this.size / 2) && mouseX <= (double)(x + this.size / 2) && mouseY >= (double)(y - this.size / 2) && mouseY <= (double)(y + this.size / 2);
        }
    }

    public class VerticalTiltGrabber
    implements Renderable {
        protected int size = 6;
        protected boolean hovered = false;

        public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
            boolean bl = this.hovered = AbstractEditorElement.this.isSelected() && this.isGrabberEnabled() && this.isMouseOver(mouseX, mouseY);
            if (AbstractEditorElement.this.isSelected() && this.isGrabberEnabled()) {
                int x = this.getX();
                int y = this.getY();
                graphics.fill(x - this.size / 2, y - this.size / 2, x + this.size / 2, y + this.size / 2, UIBase.getUIColorTheme().layout_editor_element_border_vertical_tilting_controls_color.getColorIntWithAlpha(VERTICAL_TILT_CONTROLS_ALPHA.get(AbstractEditorElement.this).floatValue()));
            }
        }

        protected int getX() {
            float centerX = (float)AbstractEditorElement.this.getX() + (float)AbstractEditorElement.this.getWidth() / 2.0f;
            return (int)centerX + 8;
        }

        protected int getY() {
            float centerY = (float)AbstractEditorElement.this.getY() + (float)AbstractEditorElement.this.getHeight() / 2.0f;
            float lineExtension = 20.0f;
            float lineLength = (float)AbstractEditorElement.this.getHeight() + lineExtension * 2.0f;
            float lineTop = (float)AbstractEditorElement.this.getY() - lineExtension;
            float normalizedTilt = (AbstractEditorElement.this.element.verticalTiltDegrees + 60.0f) / 120.0f;
            return (int)(lineTop + lineLength * normalizedTilt);
        }

        protected boolean isGrabberEnabled() {
            if (!FancyMenu.getOptions().enableElementTiltingControls.getValue().booleanValue()) {
                return false;
            }
            if (!AbstractEditorElement.this.element.supportsTilting()) {
                return false;
            }
            if (AbstractEditorElement.this.element.advancedVerticalTiltMode) {
                return false;
            }
            return !AbstractEditorElement.this.isMultiSelected();
        }

        protected boolean isMouseOver(double mouseX, double mouseY) {
            int x = this.getX();
            int y = this.getY();
            return mouseX >= (double)(x - this.size / 2) && mouseX <= (double)(x + this.size / 2) && mouseY >= (double)(y - this.size / 2) && mouseY <= (double)(y + this.size / 2);
        }
    }

    public class HorizontalTiltGrabber
    implements Renderable {
        protected int size = 6;
        protected boolean hovered = false;

        public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
            boolean bl = this.hovered = AbstractEditorElement.this.isSelected() && this.isGrabberEnabled() && this.isMouseOver(mouseX, mouseY);
            if (AbstractEditorElement.this.isSelected() && this.isGrabberEnabled()) {
                int x = this.getX();
                int y = this.getY();
                graphics.fill(x - this.size / 2, y - this.size / 2, x + this.size / 2, y + this.size / 2, UIBase.getUIColorTheme().layout_editor_element_border_horizontal_tilting_controls_color.getColorIntWithAlpha(HORIZONTAL_TILT_CONTROLS_ALPHA.get(AbstractEditorElement.this).floatValue()));
            }
        }

        protected int getX() {
            float centerX = (float)AbstractEditorElement.this.getX() + (float)AbstractEditorElement.this.getWidth() / 2.0f;
            float lineExtension = 20.0f;
            float lineLength = (float)AbstractEditorElement.this.getWidth() + lineExtension * 2.0f;
            float lineLeft = (float)AbstractEditorElement.this.getX() - lineExtension;
            float normalizedTilt = (AbstractEditorElement.this.element.horizontalTiltDegrees + 60.0f) / 120.0f;
            return (int)(lineLeft + lineLength * normalizedTilt);
        }

        protected int getY() {
            float centerY = (float)AbstractEditorElement.this.getY() + (float)AbstractEditorElement.this.getHeight() / 2.0f;
            return (int)centerY + 8;
        }

        protected boolean isGrabberEnabled() {
            if (!FancyMenu.getOptions().enableElementTiltingControls.getValue().booleanValue()) {
                return false;
            }
            if (!AbstractEditorElement.this.element.supportsTilting()) {
                return false;
            }
            if (AbstractEditorElement.this.element.advancedHorizontalTiltMode) {
                return false;
            }
            return !AbstractEditorElement.this.isMultiSelected();
        }

        protected boolean isMouseOver(double mouseX, double mouseY) {
            int x = this.getX();
            int y = this.getY();
            return mouseX >= (double)(x - this.size / 2) && mouseX <= (double)(x + this.size / 2) && mouseY >= (double)(y - this.size / 2) && mouseY <= (double)(y + this.size / 2);
        }
    }

    @FunctionalInterface
    protected static interface SwitcherContextMenuEntryLabelSupplier<V> {
        public Component get(ContextMenu var1, ContextMenu.ClickableContextMenuEntry<?> var2, V var3);
    }
}

