/*
 * Decompiled with CFR 0.152.
 */
package me.ultrusmods.extrasponges.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class WetLavaSpongeBlock
extends Block {
    private final BlockState originalBlock;

    public WetLavaSpongeBlock(BlockBehaviour.Properties settings, BlockState originalBlock) {
        super(settings);
        this.originalBlock = originalBlock;
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean notify) {
        boolean isTouchingWater = false;
        for (BlockPos blockPos : BlockPos.withinManhattan((BlockPos)pos, (int)1, (int)1, (int)1)) {
            if (!level.getBlockState(blockPos).getFluidState().is(FluidTags.WATER)) continue;
            isTouchingWater = true;
        }
        if (isTouchingWater) {
            level.setBlock(pos, this.originalBlock, 3);
            level.globalLevelEvent(2009, pos, 0);
            level.playSound(null, pos, SoundEvents.LAVA_EXTINGUISH, SoundSource.BLOCKS, 1.0f, (1.0f + level.getRandom().nextFloat() * 0.2f) * 0.7f);
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        Direction direction = Direction.getRandom((RandomSource)random);
        if (direction != Direction.UP) {
            BlockPos blockPos = pos.relative(direction);
            BlockState blockState = level.getBlockState(blockPos);
            if (!state.canOcclude() || !blockState.isFaceSturdy((BlockGetter)level, blockPos, direction.getOpposite())) {
                double d = pos.getX();
                double e = pos.getY();
                double f = pos.getZ();
                if (direction == Direction.DOWN) {
                    e -= 0.05;
                    d += random.nextDouble();
                    f += random.nextDouble();
                } else {
                    e += random.nextDouble() * 0.8;
                    if (direction.getAxis() == Direction.Axis.X) {
                        f += random.nextDouble();
                        d = direction == Direction.EAST ? (d += 1.0) : (d += 0.05);
                    } else {
                        d += random.nextDouble();
                        f = direction == Direction.SOUTH ? (f += 1.0) : (f += 0.05);
                    }
                }
                level.addParticle((ParticleOptions)ParticleTypes.DRIPPING_LAVA, d, e, f, 0.0, 0.0, 0.0);
            }
        }
    }
}

