/*
 * Decompiled with CFR 0.152.
 */
package me.ultrusmods.extrasponges.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public class LavaSpongeBlock
extends Block {
    private final int range;
    private final int absorbAmount;
    private Block wetSponge;

    public LavaSpongeBlock(BlockBehaviour.Properties settings, int range, int absorbAmount) {
        super(settings);
        this.range = range;
        this.absorbAmount = absorbAmount;
    }

    public void setWetSponge(Block wetSponge) {
        this.wetSponge = wetSponge;
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean notify) {
        if (!oldState.is(state.getBlock())) {
            this.update(level, pos);
        }
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        this.update(level, pos);
        super.neighborChanged(state, level, pos, block, fromPos, notify);
    }

    protected void update(Level level, BlockPos pos) {
        if (this.absorbLava(level, pos)) {
            level.setBlock(pos, this.wetSponge.defaultBlockState(), 2);
            level.globalLevelEvent(2001, pos, Block.getId((BlockState)Blocks.LAVA.defaultBlockState()));
        }
    }

    private boolean absorbLava(Level level, BlockPos pos) {
        return BlockPos.breadthFirstTraversal((BlockPos)pos, (int)this.range, (int)this.absorbAmount, (posx, consumer) -> {
            for (Direction direction : BlockBehaviour.UPDATE_SHAPE_ORDER) {
                consumer.accept(posx.relative(direction));
            }
        }, checkedPos -> {
            BucketPickup bucketPickup;
            if (checkedPos.equals((Object)pos)) {
                return true;
            }
            BlockState blockState = level.getBlockState(checkedPos);
            FluidState fluidState = level.getFluidState(checkedPos);
            if (!fluidState.is(FluidTags.LAVA)) {
                return false;
            }
            Block block = blockState.getBlock();
            if (block instanceof BucketPickup && !(bucketPickup = (BucketPickup)block).pickupBlock(null, (LevelAccessor)level, checkedPos, blockState).isEmpty()) {
                return true;
            }
            if (!(blockState.getBlock() instanceof LiquidBlock)) {
                return false;
            }
            level.setBlock(checkedPos, Blocks.AIR.defaultBlockState(), 3);
            return true;
        }) > 1;
    }
}

