/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.network.packet;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.swedz.extended_industrialization.EIClient;
import net.swedz.extended_industrialization.network.EICustomPacket;
import net.swedz.tesseract.neoforge.packet.PacketContext;

public record EntitiesElectrocutedPacket(IntList entityIds) implements EICustomPacket
{
    public static final StreamCodec<FriendlyByteBuf, EntitiesElectrocutedPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT.apply(ByteBufCodecs.list()).map(IntArrayList::new, Lists::newArrayList), EntitiesElectrocutedPacket::entityIds, EntitiesElectrocutedPacket::new);
    private static final int SPARK_COUNT = 3;

    public void handle(PacketContext context) {
        context.assertClientbound();
        Level level = context.getPlayer().level();
        if (this.entityIds.isEmpty() || !EIClient.config().renderTeslaAnimations()) {
            return;
        }
        IntListIterator intListIterator = this.entityIds.iterator();
        while (intListIterator.hasNext()) {
            int entityId = (Integer)intListIterator.next();
            Entity entity = level.getEntity(entityId);
            if (entity == null) continue;
            Vec3 pos = entity.getBoundingBox().getCenter();
            for (int i = 0; i < 3; ++i) {
                EntitiesElectrocutedPacket.spark((LevelAccessor)level, pos);
            }
        }
    }

    private static float sparkSpeed(LevelAccessor level) {
        RandomSource random = level.getRandom();
        return random.nextFloat() * 0.3f * (float)(random.nextBoolean() ? -1 : 1);
    }

    private static void spark(LevelAccessor level, Vec3 pos) {
        level.addParticle((ParticleOptions)ParticleTypes.FIREWORK, pos.x, pos.y, pos.z, (double)EntitiesElectrocutedPacket.sparkSpeed(level), (double)EntitiesElectrocutedPacket.sparkSpeed(level), (double)EntitiesElectrocutedPacket.sparkSpeed(level));
    }
}

