/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.guicomponent.universaltransformer;

import aztech.modern_industrialization.inventory.HackySlot;
import aztech.modern_industrialization.inventory.SlotGroup;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.gui.GuiComponentServer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Unit;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.machines.component.TransformerTierComponent;

public final class UniversalTransformerSlots
implements GuiComponentServer<Unit, Unit> {
    public static final GuiComponentServer.Type<Unit, Unit> TYPE = new GuiComponentServer.Type(EI.id("universal_transformer"), StreamCodec.unit((Object)Unit.INSTANCE), StreamCodec.unit((Object)Unit.INSTANCE));
    private final MachineBlockEntity machine;
    private final TransformerTierComponent transformerFrom;
    private final TransformerTierComponent transformerTo;

    public static int getSlotX() {
        return -22;
    }

    public static int getSlotY(int index) {
        return 19 + index * 36;
    }

    public UniversalTransformerSlots(MachineBlockEntity machine, TransformerTierComponent transformerFrom, TransformerTierComponent transformerTo) {
        this.machine = machine;
        this.transformerFrom = transformerFrom;
        this.transformerTo = transformerTo;
    }

    public Unit getParams() {
        return Unit.INSTANCE;
    }

    public Unit extractData() {
        return Unit.INSTANCE;
    }

    public GuiComponentServer.Type<Unit, Unit> getType() {
        return TYPE;
    }

    private void addSlot(GuiComponent.MenuFacade menu, int index, final Supplier<ItemStack> getStack, final Consumer<ItemStack> setStack) {
        menu.addSlotToMenu((Slot)new HackySlot(this, UniversalTransformerSlots.getSlotX(), UniversalTransformerSlots.getSlotY(index)){

            protected ItemStack getRealStack() {
                return (ItemStack)getStack.get();
            }

            protected void setRealStack(ItemStack itemStack) {
                setStack.accept(itemStack);
            }

            public boolean mayPlace(ItemStack itemStack) {
                return TransformerTierComponent.getTierFromCasing(itemStack) != null;
            }

            public int getMaxStackSize() {
                return 1;
            }
        }, SlotGroup.CONFIGURABLE_STACKS);
    }

    public void setupMenu(GuiComponent.MenuFacade menu) {
        this.addSlot(menu, 0, this.transformerFrom::getStack, stack -> this.transformerFrom.setCasing(this.machine, (ItemStack)stack));
        this.addSlot(menu, 1, this.transformerTo::getStack, stack -> this.transformerTo.setCasing(this.machine, (ItemStack)stack));
    }
}

