/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.guicomponent.teslanetwork;

import aztech.modern_industrialization.client.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.client.machines.gui.GuiComponentClient;
import aztech.modern_industrialization.client.machines.gui.MachineScreen;
import aztech.modern_industrialization.client.util.RenderHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.machines.guicomponent.teslanetwork.TeslaNetworkBar;
import net.swedz.tesseract.neoforge.helper.ComponentHelper;

public final class TeslaNetworkBarClient
extends GuiComponentClient<TeslaNetworkBar.Params, Optional<TeslaNetworkBar.Data>> {
    public TeslaNetworkBarClient(TeslaNetworkBar.Params params, Optional<TeslaNetworkBar.Data> data) {
        super((Object)params, data);
    }

    public ClientComponentRenderer createRenderer(MachineScreen machineScreen) {
        return new ClientComponentRenderer(){
            private static final ResourceLocation TESLA_NETWORK_BAR = EI.id("textures/gui/container/tesla_network_bar.png");
            private final int WIDTH = 18;
            private final int HEIGHT = 18;

            public void renderBackground(GuiGraphics guiGraphics, int x, int y) {
                int iconIndex = ((Optional)TeslaNetworkBarClient.this.data).map(TeslaNetworkBar.Data::iconIndex).orElse(0);
                guiGraphics.blit(TESLA_NETWORK_BAR, x + ((TeslaNetworkBar.Params)TeslaNetworkBarClient.this.params).renderX(), y + ((TeslaNetworkBar.Params)TeslaNetworkBarClient.this.params).renderY(), (float)(iconIndex * 18), 0.0f, 18, 18, 126, 18);
            }

            public void renderTooltip(MachineScreen screen, Font font, GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
                if (RenderHelper.isPointWithinRectangle((int)((TeslaNetworkBar.Params)TeslaNetworkBarClient.this.params).renderX(), (int)((TeslaNetworkBar.Params)TeslaNetworkBarClient.this.params).renderY(), (int)18, (int)18, (double)(mouseX - x), (double)(mouseY - y))) {
                    ArrayList lines = Lists.newArrayList();
                    if (((Optional)TeslaNetworkBarClient.this.data).isPresent()) {
                        Object t = ((Optional)TeslaNetworkBarClient.this.data).get();
                        if (t instanceof TeslaNetworkBar.TransmitterData) {
                            TeslaNetworkBar.TransmitterData transmitter = (TeslaNetworkBar.TransmitterData)t;
                            lines.add(EI.text().teslaNetworkTransmitterReceivers(transmitter.receivers()));
                            lines.add(EI.text().teslaNetworkTransmitterTransmitting(transmitter.energyTransmitting(), transmitter.cableTier()));
                            lines.add(EI.text().teslaNetworkTransmitterDrain(transmitter.energyDrain()));
                            lines.add(EI.text().teslaNetworkTransmitterConsuming(transmitter.energyConsuming()));
                        } else {
                            t = ((Optional)TeslaNetworkBarClient.this.data).get();
                            if (t instanceof TeslaNetworkBar.ReceiverData) {
                                TeslaNetworkBar.ReceiverData receiver = (TeslaNetworkBar.ReceiverData)t;
                                if (receiver.linked().isPresent()) {
                                    lines.add(EI.text().teslaNetworkReceiverLinked(receiver.linked().get()));
                                }
                                if (receiver.state().isFailure()) {
                                    switch (receiver.state()) {
                                        case NO_LINK: {
                                            EI.text().teslaNetworkReceiverNoLink();
                                            break;
                                        }
                                        case UNLOADED_TRANSMITTER: {
                                            EI.text().teslaNetworkReceiverUnloaded();
                                            break;
                                        }
                                        case MISMATCHING_VOLTAGE: {
                                            EI.text().teslaNetworkReceiverMismatchingVoltage(receiver.networkCableTier().orElseThrow());
                                            break;
                                        }
                                        case TOO_FAR: {
                                            EI.text().teslaNetworkReceiverTooFar();
                                        }
                                    }
                                }
                            } else {
                                t = ((Optional)TeslaNetworkBarClient.this.data).get();
                                if (t instanceof TeslaNetworkBar.SingingData) {
                                    TeslaNetworkBar.SingingData singing = (TeslaNetworkBar.SingingData)t;
                                    lines.add(EI.text().teslaNetworkSingingNote(singing.getReadableNote()));
                                    lines.add(EI.text().teslaNetworkTransmitterConsuming(singing.energyConsuming()));
                                }
                            }
                        }
                    }
                    if (!lines.isEmpty()) {
                        guiGraphics.renderTooltip(font, lines.stream().map(c -> ComponentHelper.stripStyle((FormattedCharSequence)c.getVisualOrderText())).toList(), mouseX, mouseY);
                    }
                }
            }
        };
    }
}

