/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.guicomponent.processingarraymachineslot;

import aztech.modern_industrialization.inventory.HackySlot;
import aztech.modern_industrialization.inventory.SlotGroup;
import aztech.modern_industrialization.machines.MachineBlock;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.blockentities.ElectricCraftingMachineBlockEntity;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.gui.GuiComponentServer;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Unit;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.EITags;
import net.swedz.extended_industrialization.machines.component.craft.processingarray.ProcessingArrayMachineComponent;
import net.swedz.tesseract.neoforge.helper.RegistryHelper;

public final class ProcessingArrayMachineSlot
implements GuiComponentServer<Unit, Integer> {
    public static final GuiComponentServer.Type<Unit, Integer> TYPE = new GuiComponentServer.Type(EI.id("processing_array_machine_slot"), StreamCodec.unit((Object)Unit.INSTANCE), ByteBufCodecs.VAR_INT);
    private final MachineBlockEntity machine;
    private final Supplier<Integer> getMaxMachines;
    private final ProcessingArrayMachineComponent machines;

    public static int getSlotX(MachineGuiParameters guiParameters) {
        return guiParameters.backgroundWidth + 6;
    }

    public static int getSlotY() {
        return 106 - (EI.config().allowUpgradesInProcessingArray() ? 0 : 20);
    }

    public static boolean isMachine(Item item) {
        MachineBlock machineBlock;
        BlockItem blockItem;
        Block block;
        return !RegistryHelper.holder((Registry)BuiltInRegistries.ITEM, (Object)item).is(EITags.Items.PROCESSING_ARRAY_BLACKLIST) && item instanceof BlockItem && (block = (blockItem = (BlockItem)item).getBlock()) instanceof MachineBlock && (machineBlock = (MachineBlock)block).getBlockEntityInstance() instanceof ElectricCraftingMachineBlockEntity;
    }

    public static boolean isMachine(ItemStack itemStack) {
        return ProcessingArrayMachineSlot.isMachine(itemStack.getItem());
    }

    public static ElectricCraftingMachineBlockEntity getMachine(ItemStack itemStack) {
        return (ElectricCraftingMachineBlockEntity)((MachineBlock)((BlockItem)itemStack.getItem()).getBlock()).getBlockEntityInstance();
    }

    public ProcessingArrayMachineSlot(MachineBlockEntity machine, Supplier<Integer> getMaxMachines, ProcessingArrayMachineComponent machines) {
        this.machine = machine;
        this.getMaxMachines = getMaxMachines;
        this.machines = machines;
    }

    public Unit getParams() {
        return Unit.INSTANCE;
    }

    public Integer extractData() {
        return this.getMaxMachines.get();
    }

    public GuiComponentServer.Type<Unit, Integer> getType() {
        return TYPE;
    }

    public void setupMenu(GuiComponent.MenuFacade menu) {
        menu.addSlotToMenu((Slot)new HackySlot(ProcessingArrayMachineSlot.getSlotX(this.machine.guiParams), ProcessingArrayMachineSlot.getSlotY()){

            protected ItemStack getRealStack() {
                return ProcessingArrayMachineSlot.this.machines.getMachines();
            }

            protected void setRealStack(ItemStack itemStack) {
                ProcessingArrayMachineSlot.this.machines.setMachines(ProcessingArrayMachineSlot.this.machine, itemStack);
            }

            public boolean mayPlace(ItemStack itemStack) {
                return ProcessingArrayMachineSlot.isMachine(itemStack);
            }

            public int getMaxStackSize() {
                return ProcessingArrayMachineSlot.this.getMaxMachines.get();
            }
        }, SlotGroup.CONFIGURABLE_STACKS);
    }
}

