/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.component.chainer.handler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.swedz.extended_industrialization.machines.component.chainer.ChainerLinks;
import net.swedz.extended_industrialization.machines.component.chainer.handler.SlotChainerHandler;
import net.swedz.extended_industrialization.machines.component.chainer.wrapper.SlotInventoryWrapper;

public final class ChainerItemHandler
extends SlotChainerHandler<IItemHandler>
implements IItemHandler {
    public ChainerItemHandler(ChainerLinks chainerLinks) {
        super(chainerLinks);
    }

    @Override
    public void invalidate() {
        ArrayList wrappers = Lists.newArrayList();
        int slots = 0;
        for (IItemHandler handler : this.getMachineLinks().itemHandlers()) {
            int handlerSlots = handler.getSlots();
            wrappers.add(new SlotInventoryWrapper<IItemHandler>(handler, slots, handlerSlots));
            slots += handlerSlots;
        }
        this.wrappers = Collections.unmodifiableList(wrappers);
        this.wrappersSlotMap = Maps.newConcurrentMap();
        this.slots = slots;
    }

    public int getSlots() {
        return this.slots;
    }

    public ItemStack getStackInSlot(int slot) {
        SlotInventoryWrapper wrapper = this.getWrapper(slot);
        return wrapper != null ? ((IItemHandler)wrapper.handler()).getStackInSlot(wrapper.toLocalSlot(slot)) : ItemStack.EMPTY;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (!this.chainerLinks.doesAllowOperation()) {
            return stack;
        }
        SlotInventoryWrapper wrapper = this.getWrapper(slot);
        return wrapper != null ? ((IItemHandler)wrapper.handler()).insertItem(wrapper.toLocalSlot(slot), stack, simulate) : stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!this.chainerLinks.doesAllowOperation()) {
            return ItemStack.EMPTY;
        }
        SlotInventoryWrapper wrapper = this.getWrapper(slot);
        return wrapper != null ? ((IItemHandler)wrapper.handler()).extractItem(wrapper.toLocalSlot(slot), amount, simulate) : ItemStack.EMPTY;
    }

    public int getSlotLimit(int slot) {
        SlotInventoryWrapper wrapper = this.getWrapper(slot);
        return wrapper != null ? ((IItemHandler)wrapper.handler()).getSlotLimit(wrapper.toLocalSlot(slot)) : 0;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        SlotInventoryWrapper wrapper = this.getWrapper(slot);
        return wrapper != null && ((IItemHandler)wrapper.handler()).isItemValid(wrapper.toLocalSlot(slot), stack);
    }
}

