/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.blockentity;

import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.inventory.SlotPositions;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.MachineComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.gui.GuiComponentServer;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.AutoExtract;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.util.Tickable;
import java.util.ArrayList;
import java.util.Collections;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.EIMachines;

public final class LargeConfigurableChestMachineBlockEntity
extends MachineBlockEntity
implements Tickable {
    private final MIInventory inventory;

    public LargeConfigurableChestMachineBlockEntity(BEP bep) {
        super(bep, new MachineGuiParameters.Builder(EI.id("large_configurable_chest"), true).backgroundHeight(234).build(), new OrientationComponent.Params(true, true, false));
        ArrayList<ConfigurableItemStack> stacks = new ArrayList<ConfigurableItemStack>();
        for (int i = 0; i < 54; ++i) {
            stacks.add(ConfigurableItemStack.standardIOSlot((boolean)true));
        }
        SlotPositions itemPositions = new SlotPositions.Builder().addSlots(8, 30, 9, 6).build();
        this.inventory = new MIInventory(stacks, Collections.emptyList(), itemPositions, SlotPositions.empty());
        this.registerGuiComponent(new GuiComponentServer[]{new AutoExtract(this.orientation)});
        this.registerComponents(new MachineComponent[]{this.inventory});
    }

    public MIInventory getInventory() {
        return this.inventory;
    }

    public MachineModelClientData getMachineModelData() {
        MachineModelClientData data = new MachineModelClientData(EIMachines.Casings.LARGE_STEEL_CRATE);
        this.orientation.writeModelData(data);
        return data;
    }

    public void tick() {
        if (this.level.isClientSide()) {
            return;
        }
        if (this.orientation.extractItems) {
            this.inventory.autoExtractItems(this.level, this.worldPosition, this.orientation.outputDirection);
        }
    }
}

