/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.item.machineconfig;

import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.items.RedstoneControlModuleItem;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.CasingComponent;
import aztech.modern_industrialization.machines.components.OverdriveComponent;
import aztech.modern_industrialization.machines.components.RedstoneControlComponent;
import aztech.modern_industrialization.machines.components.UpgradeComponent;
import aztech.modern_industrialization.util.Simulation;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.swedz.extended_industrialization.item.machineconfig.MachineConfigApplicable;
import net.swedz.extended_industrialization.machines.component.craft.processingarray.ProcessingArrayMachineComponent;
import net.swedz.extended_industrialization.machines.component.enchantmentmodule.EnchantmentModuleComponent;
import net.swedz.extended_industrialization.machines.guicomponent.processingarraymachineslot.ProcessingArrayMachineSlot;
import net.swedz.tesseract.neoforge.compat.mi.api.ComponentStackHolder;

public record MachineConfigPanel(Map<String, ItemStack> slotItems) implements MachineConfigApplicable<MachineBlockEntity>
{
    public static final Codec<MachineConfigPanel> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)ItemStack.CODEC).fieldOf("items").forGetter(MachineConfigPanel::slotItems)).apply((Applicative)instance, MachineConfigPanel::new));
    private static Map<String, RegisteredComponentType> REGISTERED_COMPONENT_TYPES = Maps.newHashMap();
    private static Map<Class<?>, String> REGISTERED_COMPONENT_TYPES_BY_TYPE = Maps.newHashMap();

    public static <T> void register(String key, Class<T> componentType, ComponentTypeHandler<T> handler) {
        if (REGISTERED_COMPONENT_TYPES.containsKey(key)) {
            throw new IllegalArgumentException("There already exists a registered component type for the key '" + key + "'");
        }
        if (REGISTERED_COMPONENT_TYPES_BY_TYPE.containsKey(componentType)) {
            throw new IllegalArgumentException("There already exists a registered component type for the type '" + String.valueOf(componentType) + "'");
        }
        if (!ComponentStackHolder.class.isAssignableFrom(componentType)) {
            throw new IllegalArgumentException("The component type '" + String.valueOf(componentType) + "' must implement ComponentStackHolder");
        }
        RegisteredComponentType<T> registeredType = new RegisteredComponentType<T>(componentType, handler);
        REGISTERED_COMPONENT_TYPES.put(key, registeredType);
        REGISTERED_COMPONENT_TYPES_BY_TYPE.put(componentType, key);
    }

    public static MachineConfigPanel from(MachineBlockEntity machine) {
        HashMap slotItems = Maps.newHashMap();
        for (Class<?> componentType : REGISTERED_COMPONENT_TYPES_BY_TYPE.keySet()) {
            String key = REGISTERED_COMPONENT_TYPES_BY_TYPE.get(componentType);
            machine.components.forType(componentType, component -> {
                ComponentStackHolder holder;
                ItemStack drop;
                if (component instanceof ComponentStackHolder && !(drop = (holder = (ComponentStackHolder)component).getStack().copy()).isEmpty()) {
                    slotItems.put(key, drop);
                }
            });
        }
        return new MachineConfigPanel(slotItems);
    }

    private static List<ItemStack> findItemsMatching(Inventory inventory, ItemStack itemStack) {
        ArrayList items = Lists.newArrayList();
        for (int i = 0; i < inventory.items.size(); ++i) {
            ItemStack slot = (ItemStack)inventory.items.get(i);
            if (slot.isEmpty() || !ItemStack.isSameItem((ItemStack)itemStack, (ItemStack)slot)) continue;
            items.add(slot);
        }
        return items;
    }

    @Override
    public boolean matches(MachineBlockEntity target) {
        for (Class<?> componentType : REGISTERED_COMPONENT_TYPES_BY_TYPE.keySet()) {
            if (target.components.getNullable(componentType) == null) continue;
            return true;
        }
        return false;
    }

    private <T extends ComponentStackHolder> boolean insertItemToComponent(String key, Player player, MachineBlockEntity target, T component, ItemStack item, Simulation simulation) {
        ItemStack slotItem = this.slotItems.get(key);
        ComponentTypeHandler<T> handler = REGISTERED_COMPONENT_TYPES.get(key).handler();
        return handler.handle(player, target, component, component, slotItem, item, simulation);
    }

    private <T> boolean insertToComponent(Player player, MachineBlockEntity target, T component, String key, Simulation simulation) {
        ItemStack componentStack;
        List<ItemStack> matchingItems;
        if (!(component instanceof ComponentStackHolder)) {
            return false;
        }
        ComponentStackHolder componentStackHolder = (ComponentStackHolder)component;
        boolean success = false;
        ItemStack slotItem = this.slotItems.get(key).copy();
        List<ItemStack> list = matchingItems = player.hasInfiniteMaterials() ? List.of(slotItem) : MachineConfigPanel.findItemsMatching(player.getInventory(), slotItem);
        if (matchingItems.isEmpty() && componentStackHolder instanceof RedstoneControlComponent && !(componentStack = componentStackHolder.getStack().copy()).isEmpty()) {
            matchingItems.add(componentStack);
        }
        for (ItemStack matchingItem : matchingItems) {
            if (!this.insertItemToComponent(key, player, target, componentStackHolder, matchingItem, simulation)) break;
            success = true;
        }
        return success;
    }

    private <T extends ComponentStackHolder> boolean dropFromComponent(Player player, MachineBlockEntity target, T component, Simulation simulation) {
        ItemStack componentItem = component.getStack();
        if (!componentItem.isEmpty()) {
            if (!player.hasInfiniteMaterials()) {
                ComponentTypeHandler.drop(target, componentItem.copy());
            }
            component.setStack(ItemStack.EMPTY);
            return true;
        }
        return false;
    }

    private <T> boolean applyComponent(Player player, MachineBlockEntity target, String key, Simulation simulation) {
        AtomicBoolean success = new AtomicBoolean(false);
        Inventory inventory = player.getInventory();
        Class componentType = REGISTERED_COMPONENT_TYPES.get(key).componentType();
        target.components.forType(componentType, component -> {
            ComponentStackHolder componentStackHolder;
            if (this.slotItems.containsKey(key)) {
                if (this.insertToComponent(player, target, component, key, simulation)) {
                    success.set(true);
                }
            } else if (component instanceof ComponentStackHolder && this.dropFromComponent(player, target, componentStackHolder = (ComponentStackHolder)component, simulation)) {
                success.set(true);
            }
        });
        return success.get();
    }

    @Override
    public boolean apply(Player player, MachineBlockEntity target, Simulation simulation) {
        boolean success = false;
        for (String key : REGISTERED_COMPONENT_TYPES.keySet()) {
            if (!this.applyComponent(player, target, key, simulation)) continue;
            success = true;
        }
        return success;
    }

    static {
        MachineConfigPanel.register("redstone_module", RedstoneControlComponent.class, (player, target, component, holder, slotItem, item, simulation) -> MIItem.REDSTONE_CONTROL_MODULE.is(item) && ComponentTypeHandler.insertSingle(player, holder, slotItem, item, simulation, insert -> RedstoneControlModuleItem.setRequiresLowSignal((ItemStack)insert, (boolean)RedstoneControlModuleItem.isRequiresLowSignal((ItemStack)slotItem))));
        MachineConfigPanel.register("upgrades", UpgradeComponent.class, (player, target, component, holder, slotItem, item, simulation) -> UpgradeComponent.getExtraEu((ItemLike)item.getItem()) > 0L && ComponentTypeHandler.insertStack(player, target, holder, slotItem, item, simulation));
        MachineConfigPanel.register("casings", CasingComponent.class, (player, target, component, holder, slotItem, item, simulation) -> {
            CableTier newTier;
            CableTier currentTier = component.getCableTier();
            ItemStack componentItem = holder.getStack();
            if (!item.isEmpty() && (newTier = CasingComponent.getCasingTier((Item)item.getItem())) != null && newTier != currentTier) {
                if (simulation.isActing()) {
                    if (currentTier != CableTier.LV && !player.hasInfiniteMaterials()) {
                        ComponentTypeHandler.drop(target, componentItem);
                    }
                    holder.setStack(item.copyWithCount(1));
                    item.consume(1, (LivingEntity)player);
                }
                return true;
            }
            return false;
        });
        MachineConfigPanel.register("overdrive_module", OverdriveComponent.class, (player, target, component, holder, slotItem, item, simulation) -> MIItem.OVERDRIVE_MODULE.is(item) && ComponentTypeHandler.insertStack(player, target, holder, slotItem, item, simulation));
        MachineConfigPanel.register("processing_array_machines", ProcessingArrayMachineComponent.class, (player, target, component, holder, slotItem, item, simulation) -> ProcessingArrayMachineSlot.isMachine(item) && ComponentTypeHandler.insertStack(player, target, holder, slotItem, item, simulation));
        MachineConfigPanel.register("enchantment_module", EnchantmentModuleComponent.class, (player, target, component, holder, slotItem, item, simulation) -> component.is(item) && ComponentTypeHandler.insertSingle(player, holder, slotItem, item, simulation));
    }

    private record RegisteredComponentType<T>(Class<T> componentType, ComponentTypeHandler<T> handler) {
    }

    public static interface ComponentTypeHandler<T> {
        public boolean handle(Player var1, MachineBlockEntity var2, T var3, ComponentStackHolder var4, ItemStack var5, ItemStack var6, Simulation var7);

        public static void drop(MachineBlockEntity machine, ItemStack stack) {
            BlockPos blockPos = machine.getBlockPos();
            Containers.dropItemStack((Level)machine.getLevel(), (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), (ItemStack)stack);
        }

        public static boolean insertSingle(Player player, ComponentStackHolder holder, ItemStack slotItem, ItemStack item, Simulation simulation, Consumer<ItemStack> itemMutator) {
            if (simulation.isActing()) {
                ItemStack insertItem;
                ItemStack componentItem = holder.getStack();
                if (componentItem.isEmpty()) {
                    insertItem = item.copyWithCount(1);
                    item.consume(1, (LivingEntity)player);
                } else {
                    insertItem = componentItem.copy();
                }
                if (itemMutator != null) {
                    itemMutator.accept(insertItem);
                }
                holder.setStack(insertItem);
            }
            return true;
        }

        public static boolean insertSingle(Player player, ComponentStackHolder holder, ItemStack slotItem, ItemStack item, Simulation simulation) {
            return ComponentTypeHandler.insertSingle(player, holder, slotItem, item, simulation, null);
        }

        public static boolean insertStack(Player player, MachineBlockEntity target, ComponentStackHolder holder, ItemStack slotItem, ItemStack item, Simulation simulation) {
            int desiredCount = slotItem.getCount();
            ItemStack componentItem = holder.getStack();
            boolean changed = false;
            if (componentItem.isEmpty()) {
                if (simulation.isActing()) {
                    ItemStack insertItem = item.copyWithCount(Math.min(item.getCount(), desiredCount));
                    holder.setStack(insertItem);
                    item.consume(insertItem.getCount(), (LivingEntity)player);
                    changed = true;
                }
            } else if (item.getItem() == componentItem.getItem()) {
                if (componentItem.getCount() < desiredCount) {
                    int added = Math.min(item.getCount(), desiredCount - componentItem.getCount());
                    boolean bl = changed = added > 0;
                    if (simulation.isActing() && changed) {
                        ItemStack insertItem = componentItem.copy();
                        insertItem.grow(added);
                        holder.setStack(insertItem);
                        item.consume(added, (LivingEntity)player);
                    }
                } else if (componentItem.getCount() > desiredCount) {
                    int subtracted = componentItem.getCount() - desiredCount;
                    boolean bl = changed = subtracted > 0;
                    if (simulation.isActing() && changed) {
                        ItemStack insertItem = componentItem.copy();
                        insertItem.shrink(subtracted);
                        if (insertItem.getCount() == 0) {
                            insertItem = ItemStack.EMPTY;
                        }
                        if (!player.hasInfiniteMaterials()) {
                            ComponentTypeHandler.drop(target, componentItem.copyWithCount(subtracted));
                        }
                        holder.setStack(insertItem);
                    }
                }
            } else if (item.getItem() != componentItem.getItem()) {
                if (simulation.isActing()) {
                    if (!player.hasInfiniteMaterials()) {
                        ComponentTypeHandler.drop(target, componentItem.copy());
                    }
                    ItemStack insertItem = item.copyWithCount(Math.min(item.getCount(), desiredCount));
                    holder.setStack(insertItem);
                    item.consume(insertItem.getCount(), (LivingEntity)player);
                }
                changed = true;
            }
            return changed;
        }
    }
}

