/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.item.machineconfig;

import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBlockEntity;
import aztech.modern_industrialization.util.Simulation;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.swedz.extended_industrialization.item.machineconfig.MachineConfigActiveShape;
import net.swedz.extended_industrialization.item.machineconfig.MachineConfigApplicable;
import net.swedz.extended_industrialization.item.machineconfig.MachineConfigOrientation;
import net.swedz.extended_industrialization.item.machineconfig.MachineConfigPanel;
import net.swedz.extended_industrialization.item.machineconfig.MachineConfigSlots;
import net.swedz.tesseract.neoforge.helper.CodecHelper;

public record MachineConfig(Block machineBlock, MachineConfigSlots slots, MachineConfigOrientation orientation, MachineConfigPanel panel, Optional<MachineConfigActiveShape> activeShape) implements MachineConfigApplicable<MachineBlockEntity>
{
    public static final Codec<MachineConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CodecHelper.forRegistry((Registry)BuiltInRegistries.BLOCK).fieldOf("machine_block").forGetter(MachineConfig::machineBlock), (App)MachineConfigSlots.CODEC.fieldOf("slots").forGetter(MachineConfig::slots), (App)MachineConfigOrientation.CODEC.fieldOf("orientation").forGetter(MachineConfig::orientation), (App)MachineConfigPanel.CODEC.fieldOf("panel").forGetter(MachineConfig::panel), (App)MachineConfigActiveShape.CODEC.optionalFieldOf("active_shape").forGetter(MachineConfig::activeShape)).apply((Applicative)instance, MachineConfig::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, MachineConfig> STREAM_CODEC = ByteBufCodecs.fromCodecWithRegistries(CODEC);

    public static MachineConfig from(MachineBlockEntity machine) {
        return new MachineConfig(machine.getBlockState().getBlock(), MachineConfigSlots.from(machine), MachineConfigOrientation.from(machine.orientation), MachineConfigPanel.from(machine), MachineConfigActiveShape.from(machine));
    }

    @Override
    public boolean matches(MachineBlockEntity target) {
        return target.getBlockState().getBlock() == this.machineBlock;
    }

    @Override
    public boolean apply(Player player, MachineBlockEntity target, Simulation simulation) {
        if (!this.matches(target)) {
            return false;
        }
        if (this.slots.apply(player, target, simulation) && this.orientation.apply(player, target.orientation, simulation)) {
            this.panel.apply(player, target, simulation);
            this.activeShape.ifPresent(activeShape -> activeShape.apply(player, target, simulation));
            if (simulation.isActing()) {
                target.invalidateCapabilities();
                target.getLevel().blockUpdated(target.getBlockPos(), Blocks.AIR);
                target.setChanged();
                if (!target.getLevel().isClientSide()) {
                    if (target instanceof MultiblockMachineBlockEntity) {
                        MultiblockMachineBlockEntity multiblockTarget = (MultiblockMachineBlockEntity)target;
                        multiblockTarget.unlink();
                    }
                    target.sync();
                }
            }
            return true;
        }
        return false;
    }
}

