/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.client.shader;

import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.swedz.extended_industrialization.EIClientShaders;

public final class NanoQuantumTextureStateShard
extends RenderStateShard.TextureStateShard {
    private final ResourceLocation glint;
    private final boolean renderStars;
    private final float starScaleX;
    private final float starScaleY;
    private final ResourceLocation starAtlas;
    private final List<ResourceLocation> sprites;

    public NanoQuantumTextureStateShard(ResourceLocation mask, ResourceLocation glint, boolean renderStars, float starScaleX, float starScaleY, ResourceLocation starAtlas, List<ResourceLocation> sprites, boolean blur, boolean mipmap) {
        super(mask, blur, mipmap);
        this.glint = glint;
        this.renderStars = renderStars;
        this.starScaleX = starScaleX;
        this.starScaleY = starScaleY;
        this.starAtlas = starAtlas;
        this.sprites = sprites;
    }

    public void setupRenderState() {
        super.setupRenderState();
        EIClientShaders.nanoQuantum().getUniform("RenderStars").set(this.renderStars ? 1 : 0);
        EIClientShaders.nanoQuantum().getUniform("StarScale").set(new float[]{this.starScaleX, this.starScaleY});
        RenderSystem.setShaderTexture((int)1, (ResourceLocation)this.glint);
        RenderSystem.setShaderTexture((int)2, (ResourceLocation)this.starAtlas);
        Function atlas = Minecraft.getInstance().getTextureAtlas(this.starAtlas);
        int index = 1;
        for (ResourceLocation spriteLocation : this.sprites) {
            TextureAtlasSprite sprite = (TextureAtlasSprite)atlas.apply(spriteLocation);
            Uniform uniform = EIClientShaders.nanoQuantum().getUniform("QuantumStarUV" + index);
            uniform.setSafe(sprite.getU0(), sprite.getV0(), sprite.getU1(), sprite.getV1());
            ++index;
        }
    }
}

