/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.component.farmer;

import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.machines.component.farmer.PlantableConfigurableItemStack;
import net.swedz.extended_industrialization.machines.component.farmer.block.FarmerTile;

public enum PlantingMode {
    AS_NEEDED((Component)EI.text().farmerPlantingAsNeeded(), false, (block, plantables) -> 0),
    ALTERNATING_LINES((Component)EI.text().farmerPlantingAlternatingLines(), true, (block, plantables) -> block.line() % plantables.size()),
    QUADRANTS((Component)EI.text().farmerPlantingQuadrants(), true, (block, plantables) -> block.quadrant() % plantables.size());

    private final Component textComponent;
    private final boolean includeEmptyStacks;
    private final BiFunction<FarmerTile, List<PlantableConfigurableItemStack>, Integer> index;

    private PlantingMode(Component textComponent, boolean includeEmptyStacks, BiFunction<FarmerTile, List<PlantableConfigurableItemStack>, Integer> index) {
        this.textComponent = textComponent;
        this.includeEmptyStacks = includeEmptyStacks;
        this.index = index;
    }

    public Component textComponent() {
        return this.textComponent;
    }

    public boolean includeEmptyStacks() {
        return this.includeEmptyStacks;
    }

    public int index(FarmerTile tile, List<PlantableConfigurableItemStack> plantables) {
        return this.index.apply(tile, plantables);
    }

    public static PlantingMode fromIndex(int index) {
        return PlantingMode.values()[Mth.clamp((int)index, (int)0, (int)(PlantingMode.values().length - 1))];
    }

    public static PlantingMode fromName(String name) {
        for (PlantingMode mode : PlantingMode.values()) {
            if (!mode.name().equals(name)) continue;
            return mode;
        }
        return null;
    }
}

