/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.blockentity.tesla;

import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.EnergyApi;
import aztech.modern_industrialization.api.energy.MIEnergyStorage;
import aztech.modern_industrialization.api.machine.component.EnergyAccess;
import aztech.modern_industrialization.api.machine.holder.EnergyComponentHolder;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.CasingComponent;
import aztech.modern_industrialization.machines.components.EnergyComponent;
import aztech.modern_industrialization.machines.components.IsActiveComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.RedstoneControlComponent;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.EnergyBar;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.util.Tickable;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.EISounds;
import net.swedz.extended_industrialization.client.ber.tesla.behavior.TeslaBehavior;
import net.swedz.extended_industrialization.machines.component.tesla.AestheticTeslaCoilComponent;
import net.swedz.extended_industrialization.machines.component.tesla.SingingTeslaCoilComponent;
import net.swedz.extended_industrialization.machines.component.tesla.TeslaBuzzingComponent;
import net.swedz.extended_industrialization.machines.component.tesla.network.TeslaNetwork;
import net.swedz.extended_industrialization.machines.component.tesla.network.TeslaTransferLimits;
import net.swedz.extended_industrialization.machines.component.tesla.network.transmitter.TeslaTransmitter;
import net.swedz.extended_industrialization.machines.component.tesla.network.transmitter.TeslaTransmitterComponent;
import net.swedz.extended_industrialization.machines.guicomponent.teslanetwork.TeslaNetworkBar;
import net.swedz.extended_industrialization.proxy.EIProxy;
import net.swedz.tesseract.neoforge.capabilities.CapabilitiesListeners;
import net.swedz.tesseract.neoforge.compat.mi.guicomponent.configurationpanel.ConfigurationPanelBuilder;
import net.swedz.tesseract.neoforge.compat.mi.guicomponent.slotpanel.ModularSlotPanel;
import net.swedz.tesseract.neoforge.proxy.Proxies;
import org.joml.Vector3f;

public final class TeslaCoilMachineBlockEntity
extends MachineBlockEntity
implements TeslaTransmitter.Delegate,
Tickable,
EnergyComponentHolder,
TeslaBehavior {
    private final IsActiveComponent isActive = new IsActiveComponent();
    private final RedstoneControlComponent redstoneControl = new RedstoneControlComponent();
    private final CasingComponent casing = new CasingComponent(this::onCasingUpdate);
    private final EnergyComponent energy = new EnergyComponent((BlockEntity)this, () -> 600L * this.casing.getCableTier().eu);
    private final MIEnergyStorage insertable = this.energy.buildInsertable(arg_0 -> ((CasingComponent)this.casing).canInsertEu(arg_0));
    private final SingingTeslaCoilComponent singing = new SingingTeslaCoilComponent(this);
    private final TeslaBuzzingComponent buzzing = new TeslaBuzzingComponent(this, EISounds.TESLA_COIL_SINGING.get(), SoundSource.RECORDS, () -> this.singing.hasNote() && this.isActive.isActive, this.singing::getPitch);
    private final AestheticTeslaCoilComponent aesthetic = new AestheticTeslaCoilComponent();
    private final TeslaTransmitterComponent transmitter = new TeslaTransmitterComponent(this, List.of(this.energy), () -> {
        CableTier tier = this.casing.getCableTier();
        long maxTransfer = tier.getMaxTransfer();
        return TeslaTransferLimits.of(tier, maxTransfer, EI.config().teslaCoilRange(), this.singing.hasNote() ? 1L : tier.eu / 16L);
    });
    private long lastEnergyTransmitted;

    public TeslaCoilMachineBlockEntity(BEP bep) {
        super(bep, new MachineGuiParameters.Builder(EI.id("tesla_coil"), false).build(), new OrientationComponent.Params(false, false, false));
        this.registerComponents(new IComponent[]{this.isActive, this.redstoneControl, this.casing, this.energy, this.transmitter, this.singing, this.buzzing, this.aesthetic});
        GuiComponent.Server[] serverArray = new GuiComponent.Server[1];
        serverArray[0] = new EnergyBar.Server(new EnergyBar.Parameters(61, 34), () -> ((EnergyComponent)this.energy).getEu(), () -> ((EnergyComponent)this.energy).getCapacity());
        this.registerGuiComponent(serverArray);
        this.registerGuiComponent(new GuiComponent.Server[]{new TeslaNetworkBar.Server(new TeslaNetworkBar.Parameters(101, 34), () -> {
            TeslaNetwork network;
            if (this.singing.hasNote()) {
                return Optional.of(new TeslaNetworkBar.SingingData(this.singing.getNote(), this.getPassiveDrain()));
            }
            if (this.hasNetwork() && (network = this.getNetwork()).isTransmitterLoaded()) {
                long drain = this.getPassiveDrain();
                return Optional.of(new TeslaNetworkBar.TransmitterData(network.receiverCount(), this.lastEnergyTransmitted, network.getCableTier(), drain, this.lastEnergyTransmitted + drain));
            }
            return Optional.empty();
        })});
        this.registerGuiComponent(new GuiComponent.Server[]{new ModularSlotPanel.Server((MachineBlockEntity)this, 0).withRedstoneModule(this.redstoneControl).withCasings(this.casing)});
        ConfigurationPanelBuilder configPanel = new ConfigurationPanelBuilder((Component)EI.text().configurationPanel(), (Component)EI.text().configurationPanelDescription(), (lineIndex, delta) -> this.sync());
        this.aesthetic.appendSelectionPanel(this, configPanel);
        this.registerGuiComponent(new GuiComponent.Server[]{configPanel.build()});
    }

    private void onCasingUpdate(CableTier from, CableTier to) {
        if (this.level != null && !this.level.isClientSide()) {
            this.transmitter.getNetwork().updateAll();
        }
    }

    public SingingTeslaCoilComponent getSingingComponent() {
        return this.singing;
    }

    @Override
    public boolean shouldTeslaRender() {
        return this.isActive.isActive;
    }

    @Override
    public ResourceLocation getTeslaModelLocation() {
        return EI.id("tesla/tesla_coil");
    }

    @Override
    public Vector3f getTeslaColor() {
        return this.aesthetic.getColor();
    }

    @Override
    public TeslaTransmitter getDelegateTransmitter() {
        return this.transmitter;
    }

    protected MachineModelClientData getMachineModelData() {
        MachineModelClientData data = new MachineModelClientData(this.casing.getCasing());
        data.isActive = this.isActive.isActive;
        this.orientation.writeModelData(data);
        return data;
    }

    public MIInventory getInventory() {
        return MIInventory.EMPTY;
    }

    public EnergyAccess getEnergyComponent() {
        return this.energy;
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        this.setNetwork(this.getPosition());
    }

    public void setRemoved() {
        super.setRemoved();
        if (this.level.isClientSide()) {
            ((EIProxy)Proxies.get(EIProxy.class)).removeTesla(this.worldPosition);
            return;
        }
        if (this.hasNetwork()) {
            this.getNetwork().unloadTransmitter();
        } else {
            EI.LOGGER.error("Failed to unload transmitter into the network because no network was set yet");
        }
    }

    public void tick() {
        long amountToDrain;
        long drained;
        TeslaNetwork network;
        if (this.level.isClientSide()) {
            ((EIProxy)Proxies.get(EIProxy.class)).tickTesla(this.worldPosition);
            this.buzzing.tick();
            return;
        }
        if (this.singing.updateNote()) {
            this.sync(false);
        }
        if (!(network = this.getNetwork()).hasTransmitter()) {
            network.loadTransmitter(this.transmitter);
        }
        this.lastEnergyTransmitted = 0L;
        boolean active = false;
        if (this.redstoneControl.doAllowNormalOperation((MachineBlockEntity)this) && (drained = this.extractEnergy(amountToDrain = this.getPassiveDrain(), false)) == amountToDrain) {
            if (!this.singing.hasNote()) {
                this.lastEnergyTransmitted = this.transmitEnergy(this.getMaxTransfer());
            }
            active = true;
        }
        this.isActive.updateActive(active, (MachineBlockEntity)this);
    }

    protected ItemInteractionResult useItemOn(Player player, InteractionHand hand, Direction face) {
        ItemInteractionResult result = super.useItemOn(player, hand, face);
        if (!result.consumesAction()) {
            result = this.redstoneControl.onUse((MachineBlockEntity)this, player, hand);
        }
        if (!result.consumesAction()) {
            result = this.casing.onUse((MachineBlockEntity)this, player, hand);
        }
        if (!result.consumesAction()) {
            result = this.aesthetic.onUse(this, player, hand);
        }
        return result;
    }

    public List<Component> getTooltips() {
        return List.of(EI.text().teslaCoilHelp1(EI.config().teslaCoilRange()), EI.text().teslaCoilHelp2());
    }

    public static void registerEnergyApi(BlockEntityType<?> bet) {
        CapabilitiesListeners.register((String)"extended_industrialization", event -> event.registerBlockEntity(EnergyApi.SIDED, bet, (be, direction) -> ((TeslaCoilMachineBlockEntity)be).insertable));
    }
}

