/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.machines.blockentity.multiblock.farmer;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.machine.component.EnergyAccess;
import aztech.modern_industrialization.api.machine.holder.EnergyListComponentHolder;
import aztech.modern_industrialization.compat.rei.machines.ReiMachineRecipes;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.blockentities.hatches.EnergyHatch;
import aztech.modern_industrialization.machines.components.EnergyComponent;
import aztech.modern_industrialization.machines.components.RedstoneControlComponent;
import aztech.modern_industrialization.machines.components.UpgradeComponent;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.multiblocks.HatchBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.ShapeMatcher;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.machines.multiblocks.SimpleMember;
import aztech.modern_industrialization.util.Simulation;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.EIMachines;
import net.swedz.extended_industrialization.EITags;
import net.swedz.extended_industrialization.machines.blockentity.multiblock.farmer.FarmerBlockEntity;
import net.swedz.extended_industrialization.machines.component.enchantmentmodule.EnchantmentModuleComponent;
import net.swedz.extended_industrialization.machines.component.farmer.PlantingMode;
import net.swedz.extended_industrialization.machines.component.farmer.task.FarmerProcessRates;
import net.swedz.extended_industrialization.machines.component.farmer.task.FarmerTaskType;
import net.swedz.extended_industrialization.machines.guicomponent.EIModularSlotPanelSlots;
import net.swedz.tesseract.neoforge.compat.mi.component.SimpleItemStackComponent;
import net.swedz.tesseract.neoforge.compat.mi.guicomponent.slotpanel.ModularSlotPanel;

public final class ElectricFarmerBlockEntity
extends FarmerBlockEntity
implements EnergyListComponentHolder {
    private static final FarmerBlockEntity.ShapeWrapper SHAPES = new FarmerBlockEntity.ShapeWrapper(4).withCasing(SimpleMember.forBlock((Supplier)((Supplier)MIBlock.BLOCK_DEFINITIONS.get(MI.id((String)"steel_machine_casing")))), SimpleMember.forBlock((Supplier)((Supplier)MIBlock.BLOCK_DEFINITIONS.get(MI.id((String)"steel_machine_casing_pipe")))), EIMachines.Casings.STEEL_PIPE).withElectric().complete();
    private static final FarmerProcessRates PROCESS_RATES = new FarmerProcessRates().with(FarmerTaskType.TILLING, 1, 1).with(FarmerTaskType.HYDRATING, 1, 1).with(FarmerTaskType.FERTLIZING, 1, 1).with(FarmerTaskType.HARVESTING, Integer.MAX_VALUE, 5).with(FarmerTaskType.PLANTING, 1, 5);
    private final RedstoneControlComponent redstoneControl;
    private final EnchantmentModuleComponent enchantmentModule;
    private final List<EnergyComponent> energyInputs = Lists.newArrayList();
    private CableTier highestCableTier;

    public ElectricFarmerBlockEntity(BEP bep) {
        super(bep, EI.id("electric_farmer"), 64L, PlantingMode.ALTERNATING_LINES, true, PROCESS_RATES, SHAPES);
        this.redstoneControl = new RedstoneControlComponent();
        this.enchantmentModule = new EnchantmentModuleComponent(EITags.Items.EnchantmentModules.FARMER);
        this.registerComponents(new IComponent[]{this.redstoneControl, this.enchantmentModule});
        this.registerGuiComponent(new GuiComponent.Server[]{new ModularSlotPanel.Server((MachineBlockEntity)this, 0).withRedstoneModule(this.redstoneControl).with(EIModularSlotPanelSlots.FARMER_ENCHANTMENT_MODULE, (SimpleItemStackComponent)this.enchantmentModule)});
    }

    public EnchantmentModuleComponent getEnchantmentModuleComponent() {
        return this.enchantmentModule;
    }

    public static void registerReiShapes() {
        int index = 0;
        for (ShapeTemplate shapeTemplate : SHAPES.shapeTemplates()) {
            ReiMachineRecipes.registerMultiblockShape((ResourceLocation)EI.id("electric_farmer"), (ShapeTemplate)shapeTemplate, (String)("" + index));
            ++index;
        }
    }

    @Override
    public CableTier getHighestCableTier() {
        return this.highestCableTier;
    }

    @Override
    public long getEuCost() {
        return super.getEuCost() + this.enchantmentModule.getAdditionalEuCost(this.highestCableTier);
    }

    @Override
    public long consumeEu(long max) {
        long total = 0L;
        for (EnergyComponent energyComponent : this.energyInputs) {
            total += energyComponent.consumeEu(max - total, Simulation.ACT);
        }
        return total;
    }

    public List<? extends EnergyAccess> getEnergyComponents() {
        return this.energyInputs;
    }

    @Override
    protected void onRematch(ShapeMatcher shapeMatcher) {
        super.onRematch(shapeMatcher);
        if (shapeMatcher.isMatchSuccessful()) {
            this.energyInputs.clear();
            this.highestCableTier = null;
            for (HatchBlockEntity hatch : shapeMatcher.getMatchedHatches()) {
                hatch.appendEnergyInputs(this.energyInputs);
                if (!(hatch instanceof EnergyHatch)) continue;
                EnergyHatch energyHatch = (EnergyHatch)hatch;
                if (this.highestCableTier != null && energyHatch.getCableTier().getEu() <= this.highestCableTier.getEu()) continue;
                this.highestCableTier = energyHatch.getCableTier();
            }
        }
    }

    protected ItemInteractionResult useItemOn(Player player, InteractionHand hand, Direction face) {
        ItemInteractionResult result = super.useItemOn(player, hand, face);
        if (!result.consumesAction()) {
            result = (ItemInteractionResult)this.components.mapOrDefault(UpgradeComponent.class, upgrade -> upgrade.onUse((MachineBlockEntity)this, player, hand), (Object)result);
        }
        if (!result.consumesAction()) {
            result = this.redstoneControl.onUse((MachineBlockEntity)this, player, hand);
        }
        if (!result.consumesAction()) {
            result = this.enchantmentModule.onUse((MachineBlockEntity)this, player, hand);
        }
        return result;
    }

    @Override
    public boolean isEnabled() {
        return this.redstoneControl.doAllowNormalOperation((MachineBlockEntity)this);
    }
}

