/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.datagen.server.provider.tags;

import java.util.Comparator;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.swedz.extended_industrialization.EIItems;
import net.swedz.extended_industrialization.EITags;
import net.swedz.tesseract.neoforge.registry.holder.ItemHolder;

public final class ItemTagDatagenProvider
extends ItemTagsProvider {
    public ItemTagDatagenProvider(GatherDataEvent event) {
        super(event.getGenerator().getPackOutput(), event.getLookupProvider(), CompletableFuture.completedFuture(TagsProvider.TagLookup.empty()), "extended_industrialization", event.getExistingFileHelper());
    }

    private void addFarmerVoidableDropTag() {
        this.tag(EITags.Items.FARMER_VOIDABLE).add((Object[])new Item[]{Items.STICK, Items.APPLE, Items.MOSS_CARPET, Items.MANGROVE_ROOTS, Items.WEEPING_VINES, Items.NETHER_WART_BLOCK, Items.WARPED_WART_BLOCK, Items.SHROOMLIGHT}).addTags(new TagKey[]{ItemTags.SAPLINGS}).addOptionalTag(ResourceLocation.fromNamespaceAndPath((String)"rootsclassic", (String)"berries"));
    }

    private void addFarmerStandardPlantableTag() {
        this.tag(EITags.Items.FARMER_PLANTABLE).add((Object[])new Item[]{Items.KELP, Items.CRIMSON_FUNGUS, Items.WARPED_FUNGUS, Items.SWEET_BERRIES}).addTags(new TagKey[]{Tags.Items.SEEDS, Tags.Items.CROPS, ItemTags.VILLAGER_PLANTABLE_SEEDS, ItemTags.SAPLINGS}).remove((Object)Items.BEETROOT, (Object[])new Item[]{Items.WHEAT});
    }

    private void addEnchantmentModuleTags() {
        this.tag(EITags.Items.EnchantmentModules.FARMER).add((Object)EIItems.SILK_TOUCH_MODULE.asItem()).add((Object)EIItems.LOOTING_MODULE.asItem());
        this.tag(EITags.Items.EnchantmentModules.LETHAL_TESLA_COIL).add((Object)EIItems.LOOTING_MODULE.asItem());
    }

    private void addGeneratedRecipesBlacklistTags() {
        this.tag(EITags.GeneratedRecipesBlacklist.CANNING_FOOD).add((Object)EIItems.CANNED_FOOD.asItem()).add((Object)Items.OMINOUS_BOTTLE);
    }

    private IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item> curiosTag(String path) {
        return this.tag(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"curios", (String)path)));
    }

    private void addCuriosTags() {
        this.curiosTag("shoulders").add((Object)EIItems.ROBOT_AUTO_FEEDER.asItem());
        this.curiosTag("belt").add((Object)EIItems.TESLA_HANDHELD_RECEIVER.asItem());
        this.curiosTag("hands").add((Object)EIItems.TESLA_HANDHELD_RECEIVER.asItem());
    }

    protected void addTags(HolderLookup.Provider provider) {
        for (ItemHolder item2 : EIItems.values().stream().sorted(Comparator.comparing(item -> item.identifier().id())).toList()) {
            for (TagKey tag : item2.tags()) {
                this.tag(tag).add((Object)item2.asItem());
            }
        }
        this.addFarmerVoidableDropTag();
        this.addFarmerStandardPlantableTag();
        this.addEnchantmentModuleTags();
        this.addGeneratedRecipesBlacklistTags();
        this.addCuriosTags();
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

