/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.extended_industrialization.client.nanosuit.decorations;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ItemStack;
import net.swedz.extended_industrialization.EI;
import net.swedz.extended_industrialization.client.nanosuit.NanoArmorLayer;
import net.swedz.extended_industrialization.client.nanosuit.decorations.NanoSuitDecorationModel;
import net.swedz.extended_industrialization.item.nanosuit.NanoSuitArmorItem;
import net.swedz.extended_industrialization.item.nanosuit.decoration.NanoSuitDecoration;

public final class MeowNanoSuitDecorationModel<T extends LivingEntity>
extends NanoSuitDecorationModel<T> {
    public static final ModelLayerLocation LAYER = new ModelLayerLocation(EI.id("nano_armor"), "meow");

    public static LayerDefinition createLayer() {
        CubeDeformation deformation = new CubeDeformation(0.0f);
        MeshDefinition mesh = MeowNanoSuitDecorationModel.createMesh((CubeDeformation)deformation, (float)0.0f);
        PartDefinition root = MeowNanoSuitDecorationModel.createHumanoidAlias(mesh);
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.ZERO);
        head.addOrReplaceChild("left_bottom_ear", CubeListBuilder.create().texOffs(0, 0).addBox(-4.625f, -11.25f, -2.375f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.375f, 0.25f, 0.125f)), PartPose.ZERO);
        head.addOrReplaceChild("left_top_ear", CubeListBuilder.create().texOffs(0, 3).addBox(-3.625f, -12.625f, -2.375f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.125f, 0.125f, 0.125f)), PartPose.ZERO);
        head.addOrReplaceChild("right_bottom_ear", CubeListBuilder.create().texOffs(0, 0).addBox(1.625f, -11.25f, -2.375f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.375f, 0.25f, 0.125f)), PartPose.ZERO);
        head.addOrReplaceChild("right_top_ear", CubeListBuilder.create().texOffs(0, 3).addBox(2.625f, -12.625f, -2.375f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.125f, 0.125f, 0.125f)), PartPose.ZERO);
        head.addOrReplaceChild("left_whisker_1", CubeListBuilder.create().texOffs(0, 5).addBox(0.0f, 0.0f, 0.0f, 3.0f, 1.0f, 0.0f), PartPose.offset((float)-7.5f, (float)-2.5f, (float)-5.1f));
        head.addOrReplaceChild("left_whisker_2", CubeListBuilder.create().texOffs(0, 5).addBox(-3.0f, -1.0f, 0.0f, 3.0f, 1.0f, 0.0f), PartPose.offsetAndRotation((float)-4.5f, (float)-2.6f, (float)-5.1f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(15.0))));
        head.addOrReplaceChild("left_whisker_3", CubeListBuilder.create().texOffs(0, 5).addBox(-3.0f, 0.0f, 0.0f, 3.0f, 1.0f, 0.0f), PartPose.offsetAndRotation((float)-4.5f, (float)-1.4f, (float)-5.1f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-15.0))));
        head.addOrReplaceChild("right_whisker_1", CubeListBuilder.create().mirror().texOffs(0, 5).addBox(0.0f, 0.0f, 0.0f, 3.0f, 1.0f, 0.0f), PartPose.offset((float)4.5f, (float)-2.5f, (float)-5.1f));
        head.addOrReplaceChild("right_whisker_2", CubeListBuilder.create().mirror().texOffs(0, 5).addBox(0.0f, 0.0f, 0.0f, 3.0f, 1.0f, 0.0f), PartPose.offsetAndRotation((float)4.5f, (float)-1.4f, (float)-5.1f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(15.0))));
        head.addOrReplaceChild("right_whisker_3", CubeListBuilder.create().mirror().texOffs(0, 5).addBox(0.0f, -1.0f, 0.0f, 3.0f, 1.0f, 0.0f), PartPose.offsetAndRotation((float)4.5f, (float)-2.6f, (float)-5.1f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(-15.0))));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)32);
    }

    private static PartDefinition createHumanoidAlias(MeshDefinition mesh) {
        PartDefinition root = mesh.getRoot();
        PartDefinition head = root.addOrReplaceChild("head", new CubeListBuilder(), PartPose.ZERO);
        head.addOrReplaceChild("left_bottom_ear", new CubeListBuilder(), PartPose.ZERO);
        head.addOrReplaceChild("left_top_ear", new CubeListBuilder(), PartPose.ZERO);
        head.addOrReplaceChild("right_bottom_ear", new CubeListBuilder(), PartPose.ZERO);
        head.addOrReplaceChild("right_top_ear", new CubeListBuilder(), PartPose.ZERO);
        head.addOrReplaceChild("left_whisker_1", new CubeListBuilder(), PartPose.ZERO);
        head.addOrReplaceChild("left_whisker_2", new CubeListBuilder(), PartPose.ZERO);
        head.addOrReplaceChild("left_whisker_3", new CubeListBuilder(), PartPose.ZERO);
        head.addOrReplaceChild("right_whisker_1", new CubeListBuilder(), PartPose.ZERO);
        head.addOrReplaceChild("right_whisker_2", new CubeListBuilder(), PartPose.ZERO);
        head.addOrReplaceChild("right_whisker_3", new CubeListBuilder(), PartPose.ZERO);
        return root;
    }

    private static ResourceLocation getTexture(boolean quantum, int layerIndex) {
        return EI.id("textures/models/armor/nano_decorations/meow%s%s.png".formatted(quantum ? "_quantum" : "", layerIndex == 1 ? "_overlay" : ""));
    }

    public MeowNanoSuitDecorationModel(ModelPart root) {
        super(root, NanoSuitDecoration.MEOW);
    }

    @Override
    public void render(T entity, EquipmentSlot slot, ItemStack stack, NanoSuitArmorItem item, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, ArmorMaterial.Layer armorLayer, int armorLayerIndex, int armorLayerColor, boolean armorLayerIsColored) {
        ResourceLocation texture = MeowNanoSuitDecorationModel.getTexture(item.isQuantum(), armorLayerIndex);
        RenderType renderType = NanoArmorLayer.decorationRenderType(armorLayerIndex, item, texture, armorLayerIsColored);
        VertexConsumer buffer = bufferSource.getBuffer(renderType);
        this.renderToBuffer(poseStack, buffer, packedLight, OverlayTexture.NO_OVERLAY, armorLayerColor);
    }

    protected Iterable<ModelPart> headParts() {
        return List.of(this.head);
    }

    protected Iterable<ModelPart> bodyParts() {
        return List.of();
    }
}

