/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure_polaroid.client.gui.screen.camera.button;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.mortuusars.exposure.world.camera.Camera;
import io.github.mortuusars.exposure_polaroid.Config;
import io.github.mortuusars.exposure_polaroid.world.item.InstantCameraItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class SlideCounterWidget
extends AbstractWidget {
    protected final WidgetSprites sprites;
    protected final Camera camera;
    protected final int secondaryFontColor;
    protected final int mainFontColor;

    public SlideCounterWidget(int x, int y, int width, int height, WidgetSprites sprites, Camera camera) {
        super(x, y, width, height, (Component)Component.empty());
        this.sprites = sprites;
        this.camera = camera;
        this.mainFontColor = Config.getColor(Config.Client.VIEWFINDER_FONT_MAIN_COLOR);
        this.secondaryFontColor = Config.getColor(Config.Client.VIEWFINDER_FONT_SECONDARY_COLOR);
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        MutableComponent tooltipComponent = Component.translatable((String)"gui.exposure_polaroid.camera_controls.slide_counter.tooltip");
        if (!this.cameraHasSlides()) {
            tooltipComponent.append(CommonComponents.NEW_LINE).append((Component)Component.translatable((String)"gui.exposure_polaroid.camera_controls.slide_counter.tooltip.no_slides").withStyle(Style.EMPTY.withColor(14508887)));
        }
        this.setTooltip(Tooltip.create((Component)tooltipComponent));
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        ResourceLocation sliderSprite = this.sprites.get(this.isActive(), this.isHoveredOrFocused());
        guiGraphics.blitSprite(sliderSprite, this.getX(), this.getY(), this.width, this.height);
        String text = this.createText();
        Font font = Minecraft.getInstance().font;
        int textWidth = font.width(text);
        int xPos = 15 + (27 - textWidth) / 2;
        guiGraphics.drawString(font, text, this.getX() + xPos, this.getY() + 8, this.secondaryFontColor, false);
        guiGraphics.drawString(font, text, this.getX() + xPos, this.getY() + 7, this.mainFontColor, false);
    }

    protected String createText() {
        return this.camera.map((i, s) -> {
            InstantCameraItem instantCamera;
            if (!(i instanceof InstantCameraItem) || (instantCamera = (InstantCameraItem)((Object)i)).getRemainingSlides((ItemStack)s) == 0) {
                return "-";
            }
            int remainingSlides = instantCamera.getRemainingSlides((ItemStack)s);
            int maxSlides = instantCamera.getMaxSlideCount();
            return remainingSlides + "/" + maxSlides;
        }).orElse("-");
    }

    protected boolean cameraHasSlides() {
        return this.camera.map((i, s) -> {
            InstantCameraItem instantCamera;
            return i instanceof InstantCameraItem && (instantCamera = (InstantCameraItem)((Object)i)).getRemainingSlides((ItemStack)s) > 0;
        }).orElse(false);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

