/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.util;

import java.util.List;
import java.util.stream.Stream;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class Vec3Util {
    public static List<Vec3> getProbeVectors(Vec3 direction, float offsetDegrees) {
        Vec3 upVector = new Vec3(0.0, 1.0, 0.0);
        Vec3 rightVector = direction.cross(upVector).normalize();
        if (Mth.equal((double)rightVector.length(), (double)0.0)) {
            rightVector = new Vec3(1.0, 0.0, 0.0).cross(direction).normalize();
        }
        upVector = rightVector.cross(direction).normalize();
        float offsetRadians = (float)Math.toRadians(offsetDegrees);
        Vec3 topLeft = Vec3Util.calculateOffsetDirection(direction, upVector, rightVector, offsetRadians, offsetRadians);
        Vec3 topRight = Vec3Util.calculateOffsetDirection(direction, upVector, rightVector, -offsetRadians, offsetRadians);
        Vec3 bottomLeft = Vec3Util.calculateOffsetDirection(direction, upVector, rightVector, offsetRadians, -offsetRadians);
        Vec3 bottomRight = Vec3Util.calculateOffsetDirection(direction, upVector, rightVector, -offsetRadians, -offsetRadians);
        return Stream.of(direction, topLeft, topRight, bottomLeft, bottomRight).toList();
    }

    public static Vec3 calculateOffsetDirection(Vec3 forward, Vec3 up, Vec3 right, double horizontalOffset, double verticalOffset) {
        Vec3 horizontalRotated = Vec3Util.rotateVector(forward, up, horizontalOffset);
        return Vec3Util.rotateVector(horizontalRotated, right, verticalOffset).normalize();
    }

    public static Vec3 rotateVector(Vec3 vec, Vec3 axis, double angle) {
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double dot = vec.dot(axis);
        return vec.scale(cos).add(axis.cross(vec).scale(sin)).add(axis.scale(dot * (1.0 - cos)));
    }
}

