/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.event;

import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureServer;
import io.github.mortuusars.exposure.world.item.camera.CameraItem;
import java.util.stream.Stream;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ServerEvents {
    public static void onServerSave() {
        if (((Boolean)Config.Server.CLEANUP_TIMED_OUT_EXPECTED_EXPOSURES.get()).booleanValue()) {
            ExposureServer.exposureRepository().clearExpectedExposuresTimedOutLongAgo();
        }
    }

    public static void serverStarted(MinecraftServer server) {
        Exposure.initServer(server);
    }

    public static void serverStopped(MinecraftServer server) {
    }

    public static void syncDatapack(Stream<ServerPlayer> relevantPlayers) {
    }

    public static void playerTick(ServerPlayer player) {
    }

    public static void itemDrop(ServerPlayer player) {
        CameraItem cameraItem;
        Inventory inventory = player.getInventory();
        ItemStack droppedItem = inventory.getSelected();
        Item item = droppedItem.getItem();
        if (item instanceof CameraItem && (cameraItem = (CameraItem)item).isActive(droppedItem)) {
            player.getActiveExposureCameraOptional().ifPresentOrElse(camera -> {
                player.removeActiveExposureCamera();
                cameraItem.deactivate((Entity)player, droppedItem);
            }, () -> cameraItem.setActive(droppedItem, false));
        }
    }
}

