/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.PlatformHelperClient;
import io.github.mortuusars.exposure.client.image.modifier.ImageEffect;
import io.github.mortuusars.exposure.client.image.renderable.RenderableImage;
import io.github.mortuusars.exposure.client.render.image.RenderCoordinates;
import io.github.mortuusars.exposure.client.render.photograph.PhotographStyle;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.world.camera.frame.Frame;
import io.github.mortuusars.exposure.world.entity.PhotographFrameEntity;
import io.github.mortuusars.exposure.world.item.PhotographItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class PhotographFrameEntityRenderer<T extends PhotographFrameEntity>
extends EntityRenderer<T> {
    protected final BlockRenderDispatcher blockRenderer;

    public PhotographFrameEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.blockRenderer = context.getBlockRenderDispatcher();
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull T pEntity) {
        return InventoryMenu.BLOCK_ATLAS;
    }

    public ModelResourceLocation getModelLocation(T entity, int size) {
        return switch (size) {
            case 0 -> ExposureClient.Models.PHOTOGRAPH_FRAME_SMALL;
            case 1 -> ExposureClient.Models.PHOTOGRAPH_FRAME_MEDIUM;
            case 2 -> ExposureClient.Models.PHOTOGRAPH_FRAME_LARGE;
            default -> throw new IllegalArgumentException("size " + size + " is not valid. Expected 0-2.");
        };
    }

    @NotNull
    protected RenderType getRenderType() {
        return Sheets.solidBlockSheet();
    }

    public void render(@NotNull T entity, float entityYaw, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        boolean photographRendered;
        EntityHitResult entityHitResult;
        HitResult hitResult = Minecraft.getInstance().hitResult;
        if (hitResult instanceof EntityHitResult && (entityHitResult = (EntityHitResult)hitResult).getEntity() == entity) {
            Minecraft.getInstance().crosshairPickEntity = entity;
        }
        Direction direction = entity.getDirection();
        int size = ((PhotographFrameEntity)((Object)entity)).getSize();
        poseStack.pushPose();
        poseStack.translate((float)direction.getStepX() * 0.3f, (float)direction.getStepY() * 0.3f, (float)direction.getStepZ() * 0.3f);
        super.render(entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        poseStack.popPose();
        poseStack.pushPose();
        double hangOffset = 0.46875;
        poseStack.translate((double)direction.getStepX() * hangOffset, (double)direction.getStepY() * hangOffset, (double)direction.getStepZ() * hangOffset);
        poseStack.mulPose(Axis.XP.rotationDegrees(entity.getXRot()));
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - entity.getYRot()));
        ItemStack item = ((PhotographFrameEntity)((Object)entity)).getItem();
        if (!item.isEmpty() && !(photographRendered = this.renderPhotograph(entity, poseStack, bufferSource, packedLight, item, size))) {
            poseStack.pushPose();
            float scale = 0.65f + (float)((PhotographFrameEntity)((Object)entity)).getSize() * 0.5f;
            poseStack.translate(0.0, 0.0, 0.46875);
            poseStack.scale(scale, scale, scale * 0.75f);
            poseStack.mulPose(Axis.ZP.rotationDegrees((float)((PhotographFrameEntity)((Object)entity)).getItemRotation() * 360.0f / 4.0f));
            Minecrft.get().getItemRenderer().renderStatic(item, ItemDisplayContext.FIXED, packedLight, OverlayTexture.NO_OVERLAY, poseStack, bufferSource, entity.level(), 0);
            poseStack.popPose();
        }
        if (!((PhotographFrameEntity)((Object)entity)).isFrameInvisible()) {
            this.renderFrame(entity, poseStack, bufferSource, packedLight, size);
        }
        poseStack.popPose();
    }

    protected void renderFrame(@NotNull T entity, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int size) {
        poseStack.pushPose();
        poseStack.translate(-0.5f, -0.5f, -0.5f);
        ModelResourceLocation modelLocation = this.getModelLocation(entity, size);
        BakedModel model = PlatformHelperClient.getModel(modelLocation);
        this.blockRenderer.getModelRenderer().renderModel(poseStack.last(), bufferSource.getBuffer(this.getRenderType()), null, model, 1.0f, 1.0f, 1.0f, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }

    protected boolean renderPhotograph(@NotNull T entity, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, ItemStack item, int size) {
        poseStack.pushPose();
        boolean frameInvisible = ((PhotographFrameEntity)((Object)entity)).isFrameInvisible();
        float frameBorderOffset = frameInvisible ? 0.0f : 0.125f;
        float offsetFromCenter = frameInvisible ? 0.497f : 0.48f;
        offsetFromCenter = (float)((double)offsetFromCenter - (Double)Config.Client.PHOTOGRAPH_FRAME_IMAGE_OFFSET.get());
        float desiredSize = (float)(size + 1) - frameBorderOffset * 2.0f;
        poseStack.mulPose(Axis.ZP.rotationDegrees((float)((PhotographFrameEntity)((Object)entity)).getItemRotation() * 360.0f / 4.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        poseStack.translate(-0.5 * (double)(size + 1) + (double)frameBorderOffset, -0.5 * (double)(size + 1) + (double)frameBorderOffset, (double)offsetFromCenter);
        poseStack.scale(desiredSize, desiredSize, 1.0f);
        boolean isGlowing = ((PhotographFrameEntity)((Object)entity)).isGlowing();
        if (isGlowing) {
            packedLight = 0xF000F0;
        }
        int brightness = isGlowing ? 255 : this.getPhotographBrightness(entity);
        boolean photographRendered = false;
        if (((Boolean)Config.Client.PIXEL_PERFECT_PHOTOGRAPH_FRAME.get()).booleanValue()) {
            Item item2 = item.getItem();
            if (item2 instanceof PhotographItem) {
                PhotographItem photographItem = (PhotographItem)item2;
                PhotographStyle style = PhotographStyle.of(item);
                Frame frame = photographItem.getFrame(item);
                RenderableImage image = style.process(ExposureClient.renderedExposures().getOrCreate(frame));
                int pixels = 16 * (((PhotographFrameEntity)((Object)entity)).getSize() + 1);
                if (!frameInvisible) {
                    pixels -= 4;
                }
                image = image.modifyWith(ImageEffect.Resize.to(pixels)::modify, "pixels-" + pixels);
                ExposureClient.imageRenderer().render(image, poseStack, bufferSource, RenderCoordinates.DEFAULT, packedLight, brightness, brightness, brightness, 255);
                photographRendered = !image.isEmpty();
            }
        } else {
            photographRendered = ExposureClient.photographRenderer().render(item, false, false, poseStack, bufferSource, packedLight, brightness, brightness, brightness, 255);
        }
        poseStack.popPose();
        return photographRendered;
    }

    public int getPhotographBrightness(T entity) {
        if (entity.getDirection() == Direction.UP) {
            return 255;
        }
        int lightLevel = entity.level().getBrightness(LightLayer.BLOCK, entity.blockPosition());
        float shadeFactor = entity.level().getShade(entity.getDirection(), true);
        shadeFactor += (1.0f - shadeFactor) * 0.2f;
        int shadedBrightness = (int)(255.0f * shadeFactor);
        int missingLight = 255 - shadedBrightness;
        int lightUp = (int)((float)missingLight * ((float)lightLevel / 15.0f * 0.5f));
        return Math.min(255, shadedBrightness + lightUp);
    }

    protected void renderNameTag(T entity, Component displayName, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, float partialTick) {
        Vec3 vec3;
        double d = this.entityRenderDispatcher.distanceToSqr(entity);
        if (!(d > 4096.0) && (vec3 = entity.getAttachments().getNullable(EntityAttachment.NAME_TAG, 0, entity.getViewYRot(partialTick))) != null) {
            boolean bl = !entity.isDiscrete();
            poseStack.pushPose();
            double yOffset = entity.getDirection().getAxis().isHorizontal() ? vec3.y - 0.2 + (double)((PhotographFrameEntity)((Object)entity)).getSize() * 0.5 : (entity.getDirection().getStepY() > 0 ? vec3.y - 0.5 : vec3.y - 1.0);
            poseStack.translate(vec3.x, vec3.y + yOffset, vec3.z);
            poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
            poseStack.scale(0.025f, -0.025f, 0.025f);
            Matrix4f matrix4f = poseStack.last().pose();
            float f = Minecraft.getInstance().options.getBackgroundOpacity(0.25f);
            int j = (int)(f * 255.0f) << 24;
            Font font = this.getFont();
            float g = -font.width((FormattedText)displayName) / 2;
            font.drawInBatch(displayName, g, 0.0f, 0x20FFFFFF, false, matrix4f, bufferSource, bl ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL, j, packedLight);
            if (bl) {
                font.drawInBatch(displayName, g, 0.0f, -1, false, matrix4f, bufferSource, Font.DisplayMode.NORMAL, 0, packedLight);
            }
            poseStack.popPose();
        }
    }

    protected boolean shouldShowName(T entity) {
        if (Minecraft.renderNames() && !((PhotographFrameEntity)((Object)entity)).getItem().isEmpty() && ((PhotographFrameEntity)((Object)entity)).getItem().has(DataComponents.CUSTOM_NAME) && Minecraft.getInstance().crosshairPickEntity == entity) {
            double distSqr = Minecraft.getInstance().crosshairPickEntity.distanceToSqr(entity);
            float showRangeSqr = entity.isDiscrete() ? 32.0f : 64.0f;
            return distSqr < (double)(showRangeSqr * showRangeSqr);
        }
        return false;
    }
}

