/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.image;

import com.mojang.blaze3d.platform.NativeImage;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.client.image.Image;
import io.github.mortuusars.exposure.client.image.renderable.RenderableImage;
import io.github.mortuusars.exposure.client.image.renderable.RenderableImageIdentifier;
import io.github.mortuusars.exposure.util.color.Color;
import java.io.IOException;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceImage
extends SimpleTexture
implements RenderableImage {
    @Nullable
    protected NativeImage image;

    public ResourceImage(ResourceLocation location) {
        super(location);
    }

    @NotNull
    public static RenderableImage getOrCreate(ResourceLocation location) {
        TextureManager textureManager = Minecraft.getInstance().getTextureManager();
        @Nullable AbstractTexture existingTexture = (AbstractTexture)textureManager.byPath.get(location);
        if (existingTexture instanceof ResourceImage) {
            ResourceImage resourceImage = (ResourceImage)existingTexture;
            return resourceImage;
        }
        try {
            ResourceImage texture = new ResourceImage(location);
            textureManager.register(location, (AbstractTexture)texture);
            return texture;
        }
        catch (Exception e) {
            Exposure.LOGGER.error("Cannot load texture [{}]. {}", (Object)location, (Object)e);
            return RenderableImage.MISSING;
        }
    }

    @Override
    public int width() {
        @Nullable NativeImage image = this.getNativeImage();
        return image != null ? image.getWidth() : 1;
    }

    @Override
    public int height() {
        @Nullable NativeImage image = this.getNativeImage();
        return image != null ? image.getHeight() : 1;
    }

    @Override
    public int getPixelARGB(int x, int y) {
        @Nullable NativeImage image = this.getNativeImage();
        return image != null ? Color.ABGRtoARGB(image.getPixelRGBA(x, y)) : 0;
    }

    @Nullable
    public NativeImage getNativeImage() {
        if (this.image != null) {
            return this.image;
        }
        try {
            NativeImage image;
            this.image = image = super.getTextureImage(Minecraft.getInstance().getResourceManager()).getImage();
            return image;
        }
        catch (IOException e) {
            Exposure.LOGGER.error("Cannot load texture: {}", (Object)e.toString());
            return null;
        }
    }

    public void reset(@NotNull TextureManager textureManager, @NotNull ResourceManager resourceManager, @NotNull ResourceLocation path, @NotNull Executor executor) {
        super.reset(textureManager, resourceManager, path, executor);
        if (this.image != null) {
            this.image.close();
            this.image = null;
        }
    }

    @Override
    public void close() {
        super.close();
        if (this.image != null) {
            this.image.close();
            this.image = null;
        }
    }

    @Override
    public Image getImage() {
        return this;
    }

    @Override
    public RenderableImageIdentifier getIdentifier() {
        return new RenderableImageIdentifier(this.location.toString());
    }
}

